/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.node;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.discover.node.statistics.MessageCount;
import org.tron.common.overlay.message.Message;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.SyncPool;
import org.tron.common.utils.ExecutorLoop;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.SlidingWindowCounter;
import org.tron.common.utils.Time;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.exception.BadBlockException;
import org.tron.core.exception.BadTransactionException;
import org.tron.core.exception.NonCommonBlockException;
import org.tron.core.exception.P2pException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.TraitorPeerException;
import org.tron.core.exception.TronException;
import org.tron.core.exception.UnLinkedBlockException;
import org.tron.core.net.message.BlockMessage;
import org.tron.core.net.message.ChainInventoryMessage;
import org.tron.core.net.message.FetchInvDataMessage;
import org.tron.core.net.message.InventoryMessage;
import org.tron.core.net.message.ItemNotFound;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.SyncBlockChainMessage;
import org.tron.core.net.message.TransactionMessage;
import org.tron.core.net.message.TransactionsMessage;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.node.Item;
import org.tron.core.net.node.Node;
import org.tron.core.net.node.NodeDelegate;
import org.tron.core.net.node.TrxHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerConnectionDelegate;
import org.tron.core.services.WitnessProductBlockService;
import org.tron.protos.Protocol;

@Component
public class NodeImpl
extends PeerConnectionDelegate
implements Node {
    private static final Logger logger = LoggerFactory.getLogger(NodeImpl.class);
    @Autowired
    private TrxHandler trxHandler;
    @Autowired
    private SyncPool pool;
    @Autowired
    private WitnessProductBlockService witnessProductBlockService;
    private MessageCount trxCount = new MessageCount();
    private Cache<Sha256Hash, TransactionMessage> TrxCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(1L, TimeUnit.HOURS).initialCapacity(50000).recordStats().build();
    private Cache<Sha256Hash, BlockMessage> BlockCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(60L, TimeUnit.SECONDS).recordStats().build();
    private SlidingWindowCounter fetchWaterLine = new SlidingWindowCounter(150);
    private int maxTrxsSize = 1000000;
    private int maxTrxsCnt = 100;
    private long blockUpdateTimeout = 20000L;
    private Object syncBlock = new Object();
    private ScheduledExecutorService logExecutor = Executors.newSingleThreadScheduledExecutor();
    private ExecutorService trxsHandlePool = Executors.newFixedThreadPool(Args.getInstance().getValidateSignThreadNum(), new ThreadFactoryBuilder().setNameFormat("TrxsHandlePool-%d").build());
    private Queue<BlockCapsule.BlockId> freshBlockId = new ConcurrentLinkedQueue<BlockCapsule.BlockId>(){

        @Override
        public boolean offer(BlockCapsule.BlockId blockId) {
            if (this.size() > 200) {
                super.poll();
            }
            return super.offer(blockId);
        }
    };
    private ConcurrentHashMap<Sha256Hash, PeerConnection> syncMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Sha256Hash, PeerConnection> fetchMap = new ConcurrentHashMap();
    private NodeDelegate del;
    private volatile boolean isAdvertiseActive;
    private volatile boolean isFetchActive;
    private ScheduledExecutorService disconnectInactiveExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService cleanInventoryExecutor = Executors.newSingleThreadScheduledExecutor();
    private ConcurrentHashMap<Sha256Hash, Protocol.Inventory.InventoryType> advObjToSpread = new ConcurrentHashMap();
    private HashMap<Sha256Hash, Long> advObjWeRequested = new HashMap();
    private ConcurrentHashMap<Sha256Hash, PriorItem> advObjToFetch = new ConcurrentHashMap();
    private ExecutorService broadPool = Executors.newFixedThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "broad-msg");
        }
    });
    private Cache<BlockCapsule.BlockId, Long> syncBlockIdWeRequested = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.HOURS).initialCapacity(10000).recordStats().build();
    private Long unSyncNum = 0L;
    private Map<BlockMessage, PeerConnection> blockWaitToProc = new ConcurrentHashMap<BlockMessage, PeerConnection>();
    private Map<BlockMessage, PeerConnection> blockJustReceived = new ConcurrentHashMap<BlockMessage, PeerConnection>();
    private ExecutorLoop<SyncBlockChainMessage> loopSyncBlockChain;
    private ExecutorLoop<FetchInvDataMessage> loopFetchBlocks;
    private ExecutorLoop<Message> loopAdvertiseInv;
    private ScheduledExecutorService fetchSyncBlocksExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService handleSyncBlockExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService fetchWaterLineExecutor = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean isHandleSyncBlockActive = false;
    private AtomicLong fetchSequenceCounter = new AtomicLong(0L);
    private volatile boolean isSuspendFetch = false;
    private volatile boolean isFetchSyncActive = false;

    @Override
    public void onMessage(PeerConnection peer, TronMessage msg) throws Exception {
        switch (msg.getType()) {
            case BLOCK: {
                this.onHandleBlockMessage(peer, (BlockMessage)msg);
                break;
            }
            case TRXS: {
                this.trxHandler.handleTransactionsMessage(peer, (TransactionsMessage)msg);
                break;
            }
            case SYNC_BLOCK_CHAIN: {
                this.onHandleSyncBlockChainMessage(peer, (SyncBlockChainMessage)msg);
                break;
            }
            case FETCH_INV_DATA: {
                this.onHandleFetchDataMessage(peer, (FetchInvDataMessage)msg);
                break;
            }
            case BLOCK_CHAIN_INVENTORY: {
                this.onHandleChainInventoryMessage(peer, (ChainInventoryMessage)msg);
                break;
            }
            case INVENTORY: {
                this.onHandleInventoryMessage(peer, (InventoryMessage)msg);
                break;
            }
            default: {
                throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, "msg type: " + (Object)((Object)msg.getType()));
            }
        }
    }

    @Override
    public Message getMessage(Sha256Hash msgId) {
        return null;
    }

    @Override
    public void setNodeDelegate(NodeDelegate nodeDel) {
        this.del = nodeDel;
    }

    public void setPool(SyncPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(Message msg) {
        Protocol.Inventory.InventoryType type;
        if (msg instanceof BlockMessage) {
            logger.info("Ready to broadcast block {}", (Object)((BlockMessage)msg).getBlockId());
            this.freshBlockId.offer(((BlockMessage)msg).getBlockId());
            this.BlockCache.put((Object)msg.getMessageId(), (Object)((BlockMessage)msg));
            type = Protocol.Inventory.InventoryType.BLOCK;
        } else if (msg instanceof TransactionMessage) {
            this.TrxCache.put((Object)msg.getMessageId(), (Object)((TransactionMessage)msg));
            type = Protocol.Inventory.InventoryType.TRX;
        } else {
            return;
        }
        ConcurrentHashMap<Sha256Hash, Protocol.Inventory.InventoryType> concurrentHashMap = this.advObjToSpread;
        synchronized (concurrentHashMap) {
            this.advObjToSpread.put(msg.getMessageId(), type);
        }
    }

    @Override
    public void listen() {
        this.pool.init(this);
        this.trxHandler.init(this);
        this.isAdvertiseActive = true;
        this.isFetchActive = true;
        this.activeTronPump();
    }

    @Override
    public void close() {
        this.getActivePeer().forEach(peer -> this.disconnectPeer((PeerConnection)peer, Protocol.ReasonCode.REQUESTED));
    }

    private void activeTronPump() {
        this.loopAdvertiseInv = new ExecutorLoop<Message>(2, 10, b -> {
            for (PeerConnection peer : this.getActivePeer()) {
                if (peer.isNeedSyncFromUs()) continue;
                logger.info("Advertise adverInv to " + peer);
                peer.sendMessage((Message)b);
            }
        }, throwable -> logger.error("Unhandled exception: ", throwable));
        this.loopFetchBlocks = new ExecutorLoop<FetchInvDataMessage>(2, 10, c -> {
            logger.info("loop fetch blocks");
            if (this.fetchMap.containsKey(c.getMessageId())) {
                this.fetchMap.get(c.getMessageId()).sendMessage((Message)c);
            }
        }, throwable -> logger.error("Unhandled exception: ", throwable));
        this.loopSyncBlockChain = new ExecutorLoop<SyncBlockChainMessage>(2, 10, d -> {
            if (this.syncMap.containsKey(d.getMessageId())) {
                this.syncMap.get(d.getMessageId()).sendMessage((Message)d);
            }
        }, throwable -> logger.error("Unhandled exception: ", throwable));
        this.broadPool.submit(() -> {
            while (this.isAdvertiseActive) {
                this.consumerAdvObjToSpread();
            }
        });
        this.broadPool.submit(() -> {
            while (this.isFetchActive) {
                this.consumerAdvObjToFetch();
            }
        });
        this.handleSyncBlockExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (this.isHandleSyncBlockActive) {
                    this.isHandleSyncBlockActive = false;
                    this.handleSyncBlock();
                }
            }
            catch (Throwable t) {
                logger.error("Unhandled exception", t);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
        this.disconnectInactiveExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.disconnectInactive();
            }
            catch (Throwable t) {
                logger.error("Unhandled exception", t);
            }
        }, 30000L, 1500L, TimeUnit.MILLISECONDS);
        this.logExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.logNodeStatus();
            }
            catch (Throwable t) {
                logger.error("Exception in log worker", t);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        this.cleanInventoryExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.getActivePeer().forEach(p -> p.cleanInvGarbage());
            }
            catch (Throwable t) {
                logger.error("Unhandled exception", t);
            }
        }, 2L, 1L, TimeUnit.MINUTES);
        this.fetchSyncBlocksExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (this.isFetchSyncActive) {
                    if (!this.isSuspendFetch) {
                        this.startFetchSyncBlock();
                    } else {
                        logger.debug("suspend");
                    }
                }
                this.isFetchSyncActive = false;
            }
            catch (Throwable t) {
                logger.error("Unhandled exception", t);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
        this.fetchWaterLineExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.fetchWaterLine.advance();
            }
            catch (Throwable t) {
                logger.error("Unhandled exception", t);
            }
        }, 1000L, 100L, TimeUnit.MILLISECONDS);
    }

    private void consumerAdvObjToFetch() {
        Collection filterActivePeer = this.getActivePeer().stream().filter(peer -> !peer.isBusy()).collect(Collectors.toList());
        if (this.advObjToFetch.isEmpty() || filterActivePeer.isEmpty()) {
            try {
                Thread.sleep(100L);
                return;
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        InvToSend sendPackage = new InvToSend();
        long now = Time.getCurrentMillis();
        this.advObjToFetch.values().stream().sorted(PriorItem::compareTo).forEach(idToFetch -> {
            Sha256Hash hash = idToFetch.getHash();
            if (idToFetch.getTime() < now - 15000L) {
                logger.info("This obj is too late to fetch, type: {} hash: {}.", (Object)idToFetch.getType(), (Object)idToFetch.getHash());
                this.advObjToFetch.remove(hash);
                return;
            }
            filterActivePeer.stream().filter(peer -> peer.getAdvObjSpreadToUs().containsKey(hash) && (long)sendPackage.getSize((PeerConnection)peer) < 200L).sorted(Comparator.comparingInt(peer -> sendPackage.getSize((PeerConnection)peer))).findFirst().ifPresent(peer -> {
                sendPackage.add((PriorItem)idToFetch, (PeerConnection)peer);
                peer.getAdvObjWeRequested().put(idToFetch.getItem(), now);
                this.advObjToFetch.remove(hash);
            });
        });
        sendPackage.sendFetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerAdvObjToSpread() {
        if (this.advObjToSpread.isEmpty()) {
            try {
                Thread.sleep(100L);
                return;
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        InvToSend sendPackage = new InvToSend();
        HashMap<Sha256Hash, Protocol.Inventory.InventoryType> spread = new HashMap<Sha256Hash, Protocol.Inventory.InventoryType>();
        ConcurrentHashMap<Sha256Hash, Protocol.Inventory.InventoryType> concurrentHashMap = this.advObjToSpread;
        synchronized (concurrentHashMap) {
            spread.putAll(this.advObjToSpread);
            this.advObjToSpread.clear();
        }
        for (Protocol.Inventory.InventoryType type : spread.values()) {
            if (type != Protocol.Inventory.InventoryType.TRX) continue;
            this.trxCount.add();
        }
        this.getActivePeer().stream().filter(peer -> !peer.isNeedSyncFromUs()).forEach(peer -> spread.entrySet().stream().filter(idToSpread -> !peer.getAdvObjSpreadToUs().containsKey(idToSpread.getKey()) && !peer.getAdvObjWeSpread().containsKey(idToSpread.getKey())).forEach(idToSpread -> {
            peer.getAdvObjWeSpread().put((Sha256Hash)idToSpread.getKey(), Time.getCurrentMillis());
            sendPackage.add((Map.Entry<Sha256Hash, Protocol.Inventory.InventoryType>)idToSpread, (PeerConnection)peer);
        }));
        sendPackage.sendInv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleSyncBlock() {
        if (this.isSuspendFetch) {
            this.isSuspendFetch = false;
        }
        boolean[] isBlockProc = new boolean[]{true};
        while (isBlockProc[0]) {
            isBlockProc[0] = false;
            Map<BlockMessage, PeerConnection> map = this.blockJustReceived;
            synchronized (map) {
                this.blockWaitToProc.putAll(this.blockJustReceived);
                this.blockJustReceived.clear();
            }
            this.blockWaitToProc.forEach((msg, peerConnection) -> {
                if (peerConnection.isDisconnect()) {
                    logger.error("Peer {} is disconnect, drop block {}", (Object)peerConnection.getNode().getHost(), (Object)msg.getBlockId().getString());
                    this.blockWaitToProc.remove(msg);
                    this.syncBlockIdWeRequested.invalidate((Object)msg.getBlockId());
                    this.isFetchSyncActive = true;
                    return;
                }
                Queue<BlockCapsule.BlockId> queue = this.freshBlockId;
                synchronized (queue) {
                    boolean[] isFound = new boolean[]{false};
                    this.getActivePeer().stream().filter(peer -> !peer.getSyncBlockToFetch().isEmpty() && peer.getSyncBlockToFetch().peek().equals(msg.getBlockId())).forEach(peer -> {
                        peer.getSyncBlockToFetch().pop();
                        peer.getBlockInProc().add(msg.getBlockId());
                        isFound[0] = true;
                    });
                    if (isFound[0]) {
                        this.blockWaitToProc.remove(msg);
                        isBlockProc[0] = true;
                        if (this.freshBlockId.contains(msg.getBlockId()) || this.processSyncBlock(msg.getBlockCapsule())) {
                            this.finishProcessSyncBlock(msg.getBlockCapsule());
                        }
                    }
                }
            });
        }
    }

    private synchronized void logNodeStatus() {
        StringBuilder sb = new StringBuilder("LocalNode stats:\n");
        sb.append("============\n");
        sb.append(String.format("MyHeadBlockNum: %d\nadvObjToSpread: %d\nadvObjToFetch: %d\nadvObjWeRequested: %d\nunSyncNum: %d\nblockWaitToProc: %d\nblockJustReceived: %d\nsyncBlockIdWeRequested: %d\n", this.del.getHeadBlockId().getNum(), this.advObjToSpread.size(), this.advObjToFetch.size(), this.advObjWeRequested.size(), this.getUnSyncNum(), this.blockWaitToProc.size(), this.blockJustReceived.size(), this.syncBlockIdWeRequested.size()));
        logger.info(sb.toString());
    }

    public synchronized void disconnectInactive() {
        this.getActivePeer().forEach(peer -> {
            boolean[] isDisconnected = new boolean[]{false};
            if (peer.isNeedSyncFromPeer() && peer.getLastBlockUpdateTime() < System.currentTimeMillis() - this.blockUpdateTimeout) {
                logger.warn("Peer {} not sync for a long time.", (Object)peer.getInetAddress());
                isDisconnected[0] = true;
            }
            peer.getAdvObjWeRequested().values().stream().filter(time -> time < Time.getCurrentMillis() - 20000L).findFirst().ifPresent(time -> {
                isDisconnected[0] = true;
            });
            if (!isDisconnected[0]) {
                peer.getSyncBlockRequested().values().stream().filter(time -> time < Time.getCurrentMillis() - 5000L).findFirst().ifPresent(time -> {
                    isDisconnected[0] = true;
                });
            }
            if (isDisconnected[0]) {
                this.disconnectPeer((PeerConnection)peer, Protocol.ReasonCode.TIME_OUT);
            }
        });
    }

    private void onHandleInventoryMessage(PeerConnection peer, InventoryMessage msg) {
        int count = peer.getNodeStatistics().messageStatistics.tronInTrxInventoryElement.getCount(10);
        if (count > 10000) {
            logger.warn("Inventory count {} from Peer {} is overload.", (Object)count, (Object)peer.getInetAddress());
            return;
        }
        if (this.trxHandler.isBusy() && msg.getInventoryType().equals((Object)Protocol.Inventory.InventoryType.TRX)) {
            logger.warn("Too many trx msg to handle, drop inventory msg from peer {}, size {}", (Object)peer.getInetAddress(), (Object)msg.getHashList().size());
            return;
        }
        for (Sha256Hash id : msg.getHashList()) {
            if (msg.getInventoryType().equals((Object)Protocol.Inventory.InventoryType.TRX) && this.TrxCache.getIfPresent((Object)id) != null) continue;
            boolean[] spreaded = new boolean[]{false};
            boolean[] requested = new boolean[]{false};
            this.getActivePeer().forEach(p -> {
                if (p.getAdvObjWeSpread().containsKey(id)) {
                    spreaded[0] = true;
                }
                if (p.getAdvObjWeRequested().containsKey(new Item(id, msg.getInventoryType()))) {
                    requested[0] = true;
                }
            });
            if (spreaded[0] || peer.isNeedSyncFromPeer() || peer.isNeedSyncFromUs()) continue;
            peer.getAdvObjSpreadToUs().put(id, System.currentTimeMillis());
            if (requested[0]) continue;
            PriorItem targetPriorItem = this.advObjToFetch.get(id);
            if (targetPriorItem != null) {
                targetPriorItem.refreshTime();
                continue;
            }
            this.fetchWaterLine.increase();
            this.advObjToFetch.put(id, new PriorItem(new Item(id, msg.getInventoryType()), this.fetchSequenceCounter.incrementAndGet()));
        }
    }

    private boolean isFlooded() {
        return (long)this.fetchWaterLine.totalCount() > 3000L * Args.getInstance().getNetMaxTrxPerSecond() * 5L / 1000L;
    }

    @Override
    public void syncFrom(Sha256Hash myHeadBlockHash) {
        try {
            while (this.getActivePeer().isEmpty()) {
                logger.info("other peer is nil, please wait ... ");
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("wait end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHandleBlockMessage(PeerConnection peer, BlockMessage blkMsg) {
        Map<Item, Long> advObjWeRequested = peer.getAdvObjWeRequested();
        Map<BlockCapsule.BlockId, Long> syncBlockRequested = peer.getSyncBlockRequested();
        BlockCapsule.BlockId blockId = blkMsg.getBlockId();
        Item item = new Item(blockId, Protocol.Inventory.InventoryType.BLOCK);
        boolean syncFlag = false;
        if (syncBlockRequested.containsKey(blockId)) {
            if (!peer.getSyncFlag()) {
                logger.info("Received a block {} from no need sync peer {}", (Object)blockId.getNum(), (Object)peer.getNode().getHost());
                return;
            }
            peer.getSyncBlockRequested().remove(blockId);
            Map<BlockMessage, PeerConnection> map = this.blockJustReceived;
            synchronized (map) {
                this.blockJustReceived.put(blkMsg, peer);
            }
            this.isHandleSyncBlockActive = true;
            syncFlag = true;
            if (!peer.isBusy()) {
                if (peer.getUnfetchSyncNum() > 0L && (long)peer.getSyncBlockToFetch().size() <= 2000L) {
                    this.syncNextBatchChainIds(peer);
                } else {
                    this.isFetchSyncActive = true;
                }
            }
        }
        if (advObjWeRequested.containsKey(item)) {
            advObjWeRequested.remove(item);
            if (!syncFlag) {
                this.processAdvBlock(peer, blkMsg.getBlockCapsule());
                this.startFetchItem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdvBlock(PeerConnection peer, BlockCapsule block) {
        Queue<BlockCapsule.BlockId> queue = this.freshBlockId;
        synchronized (queue) {
            if (!this.freshBlockId.contains(block.getBlockId())) {
                try {
                    this.witnessProductBlockService.validWitnessProductTwoBlock(block);
                    LinkedList<Sha256Hash> trxIds = null;
                    trxIds = this.del.handleBlock(block, false);
                    this.freshBlockId.offer(block.getBlockId());
                    trxIds.forEach(trxId -> this.advObjToFetch.remove(trxId));
                    this.getActivePeer().stream().filter(p -> p.getAdvObjSpreadToUs().containsKey(block.getBlockId())).forEach(p -> this.updateBlockWeBothHave((PeerConnection)p, block));
                    this.broadcast(new BlockMessage(block));
                }
                catch (BadBlockException e) {
                    logger.error("We get a bad block {}, from {}, reason is {} ", new Object[]{block.getBlockId().getString(), peer.getNode().getHost(), e.getMessage()});
                    this.disconnectPeer(peer, Protocol.ReasonCode.BAD_BLOCK);
                }
                catch (UnLinkedBlockException e) {
                    logger.error("We get a unlinked block {}, from {}, head is {}", new Object[]{block.getBlockId().getString(), peer.getNode().getHost(), this.del.getHeadBlockId().getString()});
                    this.startSyncWithPeer(peer);
                }
                catch (NonCommonBlockException e) {
                    logger.error("We get a block {} that do not have the most recent common ancestor with the main chain, from {}, reason is {} ", new Object[]{block.getBlockId().getString(), peer.getNode().getHost(), e.getMessage()});
                    this.disconnectPeer(peer, Protocol.ReasonCode.FORKED);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private boolean processSyncBlock(BlockCapsule block) {
        boolean isAccept = false;
        Protocol.ReasonCode reason = null;
        try {
            try {
                this.del.handleBlock(block, true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.freshBlockId.offer(block.getBlockId());
            logger.info("Success handle block {}", (Object)block.getBlockId().getString());
            isAccept = true;
        }
        catch (BadBlockException e) {
            logger.error("We get a bad block {}, reason is {} ", (Object)block.getBlockId().getString(), (Object)e.getMessage());
            reason = Protocol.ReasonCode.BAD_BLOCK;
        }
        catch (UnLinkedBlockException e) {
            logger.error("We get a unlinked block {}, head is {}", (Object)block.getBlockId().getString(), (Object)this.del.getHeadBlockId().getString());
            reason = Protocol.ReasonCode.UNLINKABLE;
        }
        catch (NonCommonBlockException e) {
            logger.error("We get a block {} that do not have the most recent common ancestor with the main chain, head is {}", (Object)block.getBlockId().getString(), (Object)this.del.getHeadBlockId().getString());
            reason = Protocol.ReasonCode.FORKED;
        }
        if (!isAccept) {
            Protocol.ReasonCode finalReason = reason;
            this.getActivePeer().stream().filter(peer -> peer.getBlockInProc().contains(block.getBlockId())).forEach(peer -> this.disconnectPeer((PeerConnection)peer, finalReason));
        }
        this.isHandleSyncBlockActive = true;
        return isAccept;
    }

    private void finishProcessSyncBlock(BlockCapsule block) {
        this.getActivePeer().forEach(peer -> {
            if (peer.getSyncBlockToFetch().isEmpty() && peer.getBlockInProc().isEmpty() && !peer.isNeedSyncFromPeer() && !peer.isNeedSyncFromUs()) {
                this.startSyncWithPeer((PeerConnection)peer);
            } else if (peer.getBlockInProc().remove(block.getBlockId())) {
                this.updateBlockWeBothHave((PeerConnection)peer, block);
                if (peer.getSyncBlockToFetch().isEmpty()) {
                    this.syncNextBatchChainIds((PeerConnection)peer);
                }
            }
        });
    }

    synchronized boolean isTrxExist(TransactionMessage trxMsg) {
        if (this.TrxCache.getIfPresent((Object)trxMsg.getMessageId()) != null) {
            return true;
        }
        this.TrxCache.put((Object)trxMsg.getMessageId(), (Object)trxMsg);
        return false;
    }

    public void onHandleTransactionMessage(PeerConnection peer, TransactionMessage trxMsg) {
        try {
            if (this.isTrxExist(trxMsg)) {
                logger.info("Trx {} from Peer {} already processed.", (Object)trxMsg.getMessageId(), (Object)peer.getNode().getHost());
                return;
            }
            TransactionCapsule transactionCapsule = trxMsg.getTransactionCapsule();
            if (this.del.handleTransaction(transactionCapsule)) {
                this.broadcast(trxMsg);
            }
        }
        catch (BadTransactionException e) {
            logger.error("Bad Trx {} from peer {}, error: {}", new Object[]{trxMsg.getMessageId(), peer.getInetAddress(), e.getMessage()});
            this.banTraitorPeer(peer, Protocol.ReasonCode.BAD_TX);
        }
        catch (Exception e) {
            logger.error("Process trx {} from peer {} failed", new Object[]{trxMsg.getMessageId(), peer.getInetAddress(), e});
        }
    }

    private boolean checkSyncBlockChainMessage(PeerConnection peer, SyncBlockChainMessage syncMsg) {
        long lastBlockNum = syncMsg.getBlockIds().get(syncMsg.getBlockIds().size() - 1).getNum();
        BlockCapsule.BlockId lastSyncBlockId = peer.getLastSyncBlockId();
        if (lastSyncBlockId != null && lastBlockNum < lastSyncBlockId.getNum()) {
            logger.warn("Peer {} receive bad SyncBlockChain message, firstNum {} lastSyncNum {}.", new Object[]{peer.getInetAddress(), lastBlockNum, lastSyncBlockId.getNum()});
            return false;
        }
        return true;
    }

    private void onHandleSyncBlockChainMessage(PeerConnection peer, SyncBlockChainMessage syncMsg) {
        peer.setTronState(Channel.TronState.SYNCING);
        BlockCapsule.BlockId headBlockId = this.del.getHeadBlockId();
        long remainNum = 0L;
        LinkedList<Object> blockIds = new LinkedList();
        List<BlockCapsule.BlockId> summaryChainIds = syncMsg.getBlockIds();
        if (!this.checkSyncBlockChainMessage(peer, syncMsg)) {
            this.disconnectPeer(peer, Protocol.ReasonCode.BAD_PROTOCOL);
            return;
        }
        try {
            blockIds = this.del.getLostBlockIds(summaryChainIds);
        }
        catch (StoreException e) {
            logger.error(e.getMessage());
        }
        if (blockIds.isEmpty()) {
            if (CollectionUtils.isNotEmpty(summaryChainIds) && !this.del.canChainRevoke(summaryChainIds.get(0).getNum())) {
                logger.info("Node sync block fail, disconnect peer {}, no block {}", (Object)peer, (Object)summaryChainIds.get(0).getString());
                peer.disconnect(Protocol.ReasonCode.SYNC_FAIL);
                return;
            }
            peer.setNeedSyncFromUs(false);
        } else if (blockIds.size() == 1 && !summaryChainIds.isEmpty() && (summaryChainIds.contains(blockIds.peekFirst()) || ((BlockCapsule.BlockId)blockIds.peek()).getNum() == 0L)) {
            peer.setNeedSyncFromUs(false);
        } else {
            peer.setNeedSyncFromUs(true);
            remainNum = this.del.getHeadBlockId().getNum() - ((BlockCapsule.BlockId)blockIds.peekLast()).getNum();
        }
        if (!peer.isNeedSyncFromPeer() && CollectionUtils.isNotEmpty(summaryChainIds) && !this.del.contain((Sha256Hash)Iterables.getLast(summaryChainIds), MessageTypes.BLOCK) && this.del.canChainRevoke(summaryChainIds.get(0).getNum())) {
            this.startSyncWithPeer(peer);
        }
        if (blockIds.peekLast() == null) {
            peer.setLastSyncBlockId(headBlockId);
        } else {
            peer.setLastSyncBlockId((BlockCapsule.BlockId)blockIds.peekLast());
        }
        peer.setRemainNum(remainNum);
        peer.sendMessage(new ChainInventoryMessage(blockIds, remainNum));
    }

    private boolean checkFetchInvDataMsg(PeerConnection peer, FetchInvDataMessage fetchInvDataMsg) {
        MessageTypes type = fetchInvDataMsg.getInvMessageType();
        if (type == MessageTypes.TRX) {
            int maxCount;
            int elementCount = peer.getNodeStatistics().messageStatistics.tronInTrxFetchInvDataElement.getCount(10);
            if (elementCount > (maxCount = this.trxCount.getCount(60))) {
                logger.warn("Check FetchInvDataMsg failed: Peer {} request count {} in 10s gt trx count {} generate in 60s", new Object[]{peer.getInetAddress(), elementCount, maxCount});
                return false;
            }
            for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
                if (peer.getAdvObjWeSpread().containsKey(hash)) continue;
                logger.warn("Check FetchInvDataMsg failed: Peer {} get trx {} we not spread.", (Object)peer.getInetAddress(), (Object)hash);
                return false;
            }
        } else {
            boolean isAdv = true;
            for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
                if (peer.getAdvObjWeSpread().containsKey(hash)) continue;
                isAdv = false;
                break;
            }
            if (isAdv) {
                MessageCount tronOutAdvBlock = peer.getNodeStatistics().messageStatistics.tronOutAdvBlock;
                tronOutAdvBlock.add(fetchInvDataMsg.getHashList().size());
                int outBlockCountIn1min = tronOutAdvBlock.getCount(60);
                int producedBlockIn2min = 40;
                if (outBlockCountIn1min > producedBlockIn2min) {
                    logger.warn("Check FetchInvDataMsg failed: Peer {} outBlockCount {} producedBlockIn2min {}", new Object[]{peer.getInetAddress(), outBlockCountIn1min, producedBlockIn2min});
                    return false;
                }
            } else {
                if (!peer.isNeedSyncFromUs()) {
                    logger.warn("Check FetchInvDataMsg failed: Peer {} not need sync from us.", (Object)peer.getInetAddress());
                    return false;
                }
                for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
                    long minBlockNum;
                    long blockNum = new BlockCapsule.BlockId(hash).getNum();
                    if (blockNum < (minBlockNum = peer.getLastSyncBlockId().getNum() - 4000L)) {
                        logger.warn("Check FetchInvDataMsg failed: Peer {} blockNum {} lt minBlockNum {}", new Object[]{peer.getInetAddress(), blockNum, minBlockNum});
                        return false;
                    }
                    if (peer.getSyncBlockIdCache().getIfPresent((Object)hash) != null) {
                        logger.warn("Check FetchInvDataMsg failed: Peer {} blockNum {} hash {} is exist", new Object[]{peer.getInetAddress(), blockNum, hash});
                        return false;
                    }
                    peer.getSyncBlockIdCache().put((Object)hash, (Object)1);
                }
            }
        }
        return true;
    }

    private void onHandleFetchDataMessage(PeerConnection peer, FetchInvDataMessage fetchInvDataMsg) {
        if (!this.checkFetchInvDataMsg(peer, fetchInvDataMsg)) {
            this.disconnectPeer(peer, Protocol.ReasonCode.BAD_PROTOCOL);
            return;
        }
        MessageTypes type = fetchInvDataMsg.getInvMessageType();
        BlockCapsule block = null;
        ArrayList transactions = Lists.newArrayList();
        int size = 0;
        for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
            Message msg = type == MessageTypes.BLOCK ? (Message)this.BlockCache.getIfPresent((Object)hash) : (Message)this.TrxCache.getIfPresent((Object)hash);
            if (msg == null) {
                try {
                    msg = this.del.getData(hash, type);
                }
                catch (StoreException e) {
                    logger.error("fetch message {} {} failed.", (Object)type, (Object)hash);
                    peer.sendMessage(new ItemNotFound());
                    return;
                }
            }
            if (type.equals((Object)MessageTypes.BLOCK)) {
                block = ((BlockMessage)msg).getBlockCapsule();
                peer.sendMessage(msg);
                continue;
            }
            transactions.add(((TransactionMessage)msg).getTransactionCapsule().getInstance());
            if (transactions.size() % this.maxTrxsCnt != 0 && (size += ((TransactionMessage)msg).getTransactionCapsule().getInstance().getSerializedSize()) <= this.maxTrxsSize) continue;
            peer.sendMessage(new TransactionsMessage(transactions));
            transactions = Lists.newArrayList();
            size = 0;
        }
        if (block != null) {
            this.updateBlockWeBothHave(peer, block);
        }
        if (transactions.size() > 0) {
            peer.sendMessage(new TransactionsMessage(transactions));
        }
    }

    private void banTraitorPeer(PeerConnection peer, Protocol.ReasonCode reason) {
        this.disconnectPeer(peer, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHandleChainInventoryMessage(PeerConnection peer, ChainInventoryMessage msg) {
        block35: {
            try {
                if (peer.getSyncChainRequested() != null) {
                    LinkedList<BlockCapsule.BlockId> blockIdWeGet = new LinkedList<BlockCapsule.BlockId>(msg.getBlockIds());
                    if (blockIdWeGet.size() > 0) {
                        peer.setNeedSyncFromPeer(true);
                    }
                    if (!blockIdWeGet.isEmpty()) {
                        long num = ((BlockCapsule.BlockId)blockIdWeGet.peek()).getNum();
                        for (BlockCapsule.BlockId id : blockIdWeGet) {
                            if (id.getNum() == num++) continue;
                            throw new TraitorPeerException("We get a not continuous block inv from " + peer);
                        }
                        if (((Deque)peer.getSyncChainRequested().getKey()).isEmpty()) {
                            if (((BlockCapsule.BlockId)blockIdWeGet.peek()).getNum() != 1L) {
                                throw new TraitorPeerException("We want a block inv starting from beginning from " + peer);
                            }
                        } else if (!((Deque)peer.getSyncChainRequested().getKey()).contains(blockIdWeGet.peek())) {
                            throw new TraitorPeerException(String.format("We get a unlinked block chain from " + peer + "\n Our head is " + ((BlockCapsule.BlockId)((Deque)peer.getSyncChainRequested().getKey()).getLast()).getString() + "\n Peer give us is " + ((BlockCapsule.BlockId)blockIdWeGet.peek()).getString(), new Object[0]));
                        }
                        if (this.del.getHeadBlockId().getNum() > 0L) {
                            long maxRemainTime = 3600000L + System.currentTimeMillis() - this.del.getBlockTime(this.del.getSolidBlockId());
                            long maxFutureNum = maxRemainTime / 3000L + this.del.getSolidBlockId().getNum();
                            if (((BlockCapsule.BlockId)blockIdWeGet.peekLast()).getNum() + msg.getRemainNum() > maxFutureNum) {
                                throw new TraitorPeerException("Block num " + ((BlockCapsule.BlockId)blockIdWeGet.peekLast()).getNum() + "+" + msg.getRemainNum() + " is gt future max num " + maxFutureNum + " from " + peer + ", maybe the local clock is not right.");
                            }
                        }
                    }
                    if (msg.getRemainNum() == 0L && (blockIdWeGet.isEmpty() || blockIdWeGet.size() == 1 && this.del.containBlock((BlockCapsule.BlockId)blockIdWeGet.peek())) && peer.getSyncBlockToFetch().isEmpty() && peer.getUnfetchSyncNum() == 0L) {
                        peer.setNeedSyncFromPeer(false);
                        this.unSyncNum = this.getUnSyncNum();
                        if (this.unSyncNum == 0L) {
                            this.del.syncToCli(0L);
                        }
                        peer.setSyncChainRequested(null);
                        return;
                    }
                    if (!blockIdWeGet.isEmpty() && peer.getSyncBlockToFetch().isEmpty()) {
                        boolean isFound = false;
                        for (PeerConnection peerToCheck : this.getActivePeer()) {
                            BlockCapsule.BlockId blockId = peerToCheck.getSyncBlockToFetch().peekFirst();
                            if (peerToCheck.equals(peer) || blockId == null || !blockId.equals(blockIdWeGet.peekFirst())) continue;
                            isFound = true;
                            break;
                        }
                        if (!isFound) {
                            while (!blockIdWeGet.isEmpty() && this.del.containBlock((BlockCapsule.BlockId)blockIdWeGet.peek())) {
                                this.updateBlockWeBothHave(peer, (BlockCapsule.BlockId)blockIdWeGet.peek());
                                blockIdWeGet.poll();
                            }
                        }
                    } else if (!blockIdWeGet.isEmpty()) {
                        while (!peer.getSyncBlockToFetch().isEmpty() && !peer.getSyncBlockToFetch().peekLast().equals(blockIdWeGet.peekFirst())) {
                            peer.getSyncBlockToFetch().pollLast();
                        }
                        if (peer.getSyncBlockToFetch().isEmpty() && this.del.containBlock((BlockCapsule.BlockId)blockIdWeGet.peek())) {
                            this.updateBlockWeBothHave(peer, (BlockCapsule.BlockId)blockIdWeGet.peek());
                        }
                        blockIdWeGet.poll();
                    }
                    peer.setUnfetchSyncNum(msg.getRemainNum());
                    peer.getSyncBlockToFetch().addAll(blockIdWeGet);
                    Queue<BlockCapsule.BlockId> isFound = this.freshBlockId;
                    synchronized (isFound) {
                        while (!peer.getSyncBlockToFetch().isEmpty() && this.freshBlockId.contains(peer.getSyncBlockToFetch().peek())) {
                            BlockCapsule.BlockId blockId = peer.getSyncBlockToFetch().pop();
                            this.updateBlockWeBothHave(peer, blockId);
                            logger.info("Block {} from {} is processed", (Object)blockId.getString(), (Object)peer.getNode().getHost());
                        }
                    }
                    if (msg.getRemainNum() == 0L && peer.getSyncBlockToFetch().isEmpty()) {
                        peer.setNeedSyncFromPeer(false);
                    }
                    long newUnSyncNum = this.getUnSyncNum();
                    if (this.unSyncNum != newUnSyncNum) {
                        this.unSyncNum = newUnSyncNum;
                        this.del.syncToCli(this.unSyncNum);
                    }
                    peer.setSyncChainRequested(null);
                    if (msg.getRemainNum() == 0L) {
                        if (!peer.getSyncBlockToFetch().isEmpty()) {
                            this.isFetchSyncActive = true;
                        } else {
                            this.syncNextBatchChainIds(peer);
                        }
                    } else if ((long)peer.getSyncBlockToFetch().size() > 2000L) {
                        this.isFetchSyncActive = true;
                    } else {
                        this.syncNextBatchChainIds(peer);
                    }
                    break block35;
                }
                throw new TraitorPeerException("We don't send sync request to " + peer);
            }
            catch (TraitorPeerException e) {
                logger.error(e.getMessage());
                this.banTraitorPeer(peer, Protocol.ReasonCode.BAD_PROTOCOL);
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
                this.banTraitorPeer(peer, Protocol.ReasonCode.BAD_BLOCK);
            }
        }
    }

    private void startFetchItem() {
    }

    private long getUnSyncNum() {
        if (this.getActivePeer().isEmpty()) {
            return 0L;
        }
        return this.getActivePeer().stream().mapToLong(peer -> peer.getUnfetchSyncNum() + (long)peer.getSyncBlockToFetch().size()).max().getAsLong();
    }

    private synchronized void startFetchSyncBlock() {
        HashMap<PeerConnection, List> send = new HashMap<PeerConnection, List>();
        HashSet request = new HashSet();
        this.getActivePeer().stream().filter(peer -> peer.isNeedSyncFromPeer() && !peer.isBusy()).forEach(peer -> {
            if (!send.containsKey(peer)) {
                send.put((PeerConnection)peer, new LinkedList());
            }
            for (BlockCapsule.BlockId blockId : peer.getSyncBlockToFetch()) {
                if (request.contains(blockId) || this.syncBlockIdWeRequested.getIfPresent((Object)blockId) != null) continue;
                ((List)send.get(peer)).add(blockId);
                request.add(blockId);
                if ((long)((List)send.get(peer)).size() <= 1000L) continue;
                break;
            }
        });
        send.forEach((peer, blockIds) -> {
            blockIds.forEach(blockId -> {
                this.syncBlockIdWeRequested.put(blockId, (Object)System.currentTimeMillis());
                peer.getSyncBlockRequested().put((BlockCapsule.BlockId)blockId, System.currentTimeMillis());
            });
            LinkedList<Sha256Hash> ids = new LinkedList<Sha256Hash>();
            ids.addAll((Collection<Sha256Hash>)blockIds);
            if (!ids.isEmpty()) {
                peer.sendMessage(new FetchInvDataMessage(ids, Protocol.Inventory.InventoryType.BLOCK));
            }
        });
        send.clear();
    }

    private void updateBlockWeBothHave(PeerConnection peer, BlockCapsule block) {
        logger.info("update peer {} block both we have {}", (Object)peer.getNode().getHost(), (Object)block.getBlockId().getString());
        peer.setHeadBlockWeBothHave(block.getBlockId());
        peer.setHeadBlockTimeWeBothHave(block.getTimeStamp());
        peer.setLastBlockUpdateTime(System.currentTimeMillis());
    }

    private void updateBlockWeBothHave(PeerConnection peer, BlockCapsule.BlockId blockId) throws StoreException {
        logger.info("update peer {} block both we have, {}", (Object)peer.getNode().getHost(), (Object)blockId.getString());
        peer.setHeadBlockWeBothHave(blockId);
        long time = ((BlockMessage)this.del.getData(blockId, MessageTypes.BLOCK)).getBlockCapsule().getTimeStamp();
        peer.setHeadBlockTimeWeBothHave(time);
        peer.setLastBlockUpdateTime(System.currentTimeMillis());
    }

    public Collection<PeerConnection> getActivePeer() {
        return this.pool.getActivePeers();
    }

    private void startSyncWithPeer(PeerConnection peer) {
        peer.setNeedSyncFromPeer(true);
        peer.getSyncBlockToFetch().clear();
        peer.setUnfetchSyncNum(0L);
        this.updateBlockWeBothHave(peer, this.del.getGenesisBlock());
        peer.setBanned(false);
        this.syncNextBatchChainIds(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncNextBatchChainIds(PeerConnection peer) {
        Object object = this.syncBlock;
        synchronized (object) {
            if (peer.isDisconnect()) {
                logger.warn("Peer {} is disconnect", (Object)peer.getInetAddress());
                return;
            }
            if (peer.getSyncChainRequested() != null) {
                logger.info("Peer {} is in sync.", (Object)peer.getInetAddress());
                return;
            }
            try {
                Deque<BlockCapsule.BlockId> chainSummary = this.del.getBlockChainSummary(peer.getHeadBlockWeBothHave(), peer.getSyncBlockToFetch());
                peer.setSyncChainRequested((Pair<Deque<BlockCapsule.BlockId>, Long>)new Pair(chainSummary, (Object)System.currentTimeMillis()));
                peer.sendMessage(new SyncBlockChainMessage((LinkedList)chainSummary));
            }
            catch (TronException e) {
                logger.error("Peer {} sync next batch chainIds failed, error: {}.", (Object)peer.getNode().getHost(), (Object)e.getMessage());
                this.disconnectPeer(peer, Protocol.ReasonCode.FORKED);
            }
        }
    }

    @Override
    public void onConnectPeer(PeerConnection peer) {
        if (peer.getHelloMessage().getHeadBlockId().getNum() > this.del.getHeadBlockId().getNum()) {
            peer.setTronState(Channel.TronState.SYNCING);
            this.startSyncWithPeer(peer);
        } else {
            peer.setTronState(Channel.TronState.SYNC_COMPLETED);
        }
    }

    @Override
    public void onDisconnectPeer(PeerConnection peer) {
        if (!peer.getSyncBlockRequested().isEmpty()) {
            peer.getSyncBlockRequested().keySet().forEach(blockId -> this.syncBlockIdWeRequested.invalidate(blockId));
            this.isFetchSyncActive = true;
        }
        if (!peer.getAdvObjWeRequested().isEmpty()) {
            peer.getAdvObjWeRequested().keySet().forEach(item -> {
                if (this.getActivePeer().stream().filter(peerConnection -> !peerConnection.equals(peer)).filter(peerConnection -> peerConnection.getInvToUs().contains(item.getHash())).findFirst().isPresent()) {
                    this.advObjToFetch.put(item.getHash(), new PriorItem((Item)item, this.fetchSequenceCounter.incrementAndGet()));
                }
            });
        }
    }

    public void shutDown() {
        this.logExecutor.shutdown();
        this.trxsHandlePool.shutdown();
        this.disconnectInactiveExecutor.shutdown();
        this.cleanInventoryExecutor.shutdown();
        this.broadPool.shutdown();
        this.loopSyncBlockChain.shutdown();
        this.loopFetchBlocks.shutdown();
        this.loopAdvertiseInv.shutdown();
        this.fetchSyncBlocksExecutor.shutdown();
        this.handleSyncBlockExecutor.shutdown();
    }

    private void disconnectPeer(PeerConnection peer, Protocol.ReasonCode reason) {
        peer.setSyncFlag(false);
        peer.disconnect(reason);
    }

    class InvToSend {
        private HashMap<PeerConnection, HashMap<Protocol.Inventory.InventoryType, LinkedList<Sha256Hash>>> send = new HashMap();

        InvToSend() {
        }

        public void clear() {
            this.send.clear();
        }

        public void add(Map.Entry<Sha256Hash, Protocol.Inventory.InventoryType> id, PeerConnection peer) {
            if (this.send.containsKey(peer) && !this.send.get(peer).containsKey((Object)id.getValue())) {
                this.send.get(peer).put(id.getValue(), new LinkedList());
            } else if (!this.send.containsKey(peer)) {
                this.send.put(peer, new HashMap());
                this.send.get(peer).put(id.getValue(), new LinkedList());
            }
            this.send.get(peer).get((Object)id.getValue()).offer(id.getKey());
        }

        public void add(PriorItem id, PeerConnection peer) {
            if (this.send.containsKey(peer) && !this.send.get(peer).containsKey((Object)id.getType())) {
                this.send.get(peer).put(id.getType(), new LinkedList());
            } else if (!this.send.containsKey(peer)) {
                this.send.put(peer, new HashMap());
                this.send.get(peer).put(id.getType(), new LinkedList());
            }
            this.send.get(peer).get((Object)id.getType()).offer(id.getHash());
        }

        public int getSize(PeerConnection peer) {
            if (this.send.containsKey(peer)) {
                return this.send.get(peer).values().stream().mapToInt(LinkedList::size).sum();
            }
            return 0;
        }

        void sendInv() {
            this.send.forEach((peer, ids) -> ids.forEach((key, value) -> {
                if (key.equals((Object)Protocol.Inventory.InventoryType.BLOCK)) {
                    value.sort(Comparator.comparingLong(value1 -> new BlockCapsule.BlockId((Sha256Hash)value1).getNum()));
                }
                peer.sendMessage(new InventoryMessage((List<Sha256Hash>)value, (Protocol.Inventory.InventoryType)((Object)((Object)key))));
            }));
        }

        void sendFetch() {
            this.send.forEach((peer, ids) -> ids.forEach((key, value) -> {
                if (key.equals((Object)Protocol.Inventory.InventoryType.BLOCK)) {
                    value.sort(Comparator.comparingLong(value1 -> new BlockCapsule.BlockId((Sha256Hash)value1).getNum()));
                }
                peer.sendMessage(new FetchInvDataMessage((List<Sha256Hash>)value, (Protocol.Inventory.InventoryType)((Object)((Object)key))));
            }));
        }
    }

    class PriorItem
    implements Comparable<PriorItem> {
        private long count;
        private Item item;
        private long time;

        public Sha256Hash getHash() {
            return this.item.getHash();
        }

        public Protocol.Inventory.InventoryType getType() {
            return this.item.getType();
        }

        public PriorItem(Item item, long count) {
            this.item = item;
            this.count = count;
            this.time = Time.getCurrentMillis();
        }

        public void refreshTime() {
            this.time = Time.getCurrentMillis();
        }

        @Override
        public int compareTo(PriorItem o) {
            if (!this.item.getType().equals((Object)o.getItem().getType())) {
                return this.item.getType().equals((Object)Protocol.Inventory.InventoryType.BLOCK) ? -1 : 1;
            }
            return Long.compare(this.count, o.getCount());
        }

        public long getCount() {
            return this.count;
        }

        public Item getItem() {
            return this.item;
        }

        public long getTime() {
            return this.time;
        }
    }
}

