/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message;

import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;

public class BlockMessage
extends TronMessage {
    private BlockCapsule block;

    public BlockMessage(byte[] data) throws BadItemException {
        this.type = MessageTypes.BLOCK.asByte();
        this.data = data;
        this.block = new BlockCapsule(data);
    }

    public BlockMessage(BlockCapsule block) {
        this.data = block.getData();
        this.type = MessageTypes.BLOCK.asByte();
        this.block = block;
    }

    public BlockCapsule.BlockId getBlockId() {
        return this.getBlockCapsule().getBlockId();
    }

    public BlockCapsule getBlockCapsule() {
        return this.block;
    }

    @Override
    public Class<?> getAnswerMessage() {
        return null;
    }

    @Override
    public Sha256Hash getMessageId() {
        return this.getBlockCapsule().getBlockId();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + this.block.getBlockId().getString() + ", trx size: " + this.block.getTransactions().size() + "\n";
    }
}

