/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.common.Key;
import org.tron.core.db2.common.LevelDB;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.core.AbstractSnapshot;
import org.tron.core.db2.core.Snapshot;
import org.tron.core.db2.core.SnapshotImpl;

public class SnapshotRoot
extends AbstractSnapshot<byte[], byte[]> {
    private Snapshot solidity;

    public SnapshotRoot(String parentName, String name) {
        this.db = new LevelDB(parentName, name);
        this.solidity = this;
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.db.get(key);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.db.put(key, value);
    }

    @Override
    public void remove(byte[] key) {
        this.db.remove(key);
    }

    @Override
    public void merge(Snapshot from) {
        LevelDB levelDB = (LevelDB)this.db;
        SnapshotImpl snapshot = (SnapshotImpl)from;
        Map<WrappedByteArray, WrappedByteArray> batch = Streams.stream((Iterable)snapshot.db).map(e -> Maps.immutableEntry((Object)WrappedByteArray.of(((Key)e.getKey()).getBytes()), (Object)WrappedByteArray.of(((Value)e.getValue()).getBytes()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        levelDB.flush(batch);
    }

    public void merge(List<Snapshot> snapshots) {
        HashMap<WrappedByteArray, WrappedByteArray> batch = new HashMap<WrappedByteArray, WrappedByteArray>();
        for (Snapshot snapshot : snapshots) {
            SnapshotImpl from = (SnapshotImpl)snapshot;
            Streams.stream((Iterable)from.db).map(e -> Maps.immutableEntry((Object)WrappedByteArray.of(((Key)e.getKey()).getBytes()), (Object)WrappedByteArray.of(((Value)e.getValue()).getBytes()))).forEach(e -> {
                WrappedByteArray cfr_ignored_0 = (WrappedByteArray)batch.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
            });
        }
        ((LevelDB)this.db).flush(batch);
    }

    @Override
    public Snapshot retreat() {
        return this;
    }

    @Override
    public Snapshot getRoot() {
        return this;
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return this.db.iterator();
    }

    @Override
    public void close() {
        ((LevelDB)this.db).close();
    }

    @Override
    public void reset() {
        ((LevelDB)this.db).reset();
    }

    @Override
    public void resetSolidity() {
        this.solidity = this;
    }

    @Override
    public void updateSolidity() {
        this.solidity = this.solidity.getNext();
    }

    @Override
    public Snapshot getSolidity() {
        return this.solidity;
    }
}

