/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.common.utils.FileUtil;
import org.tron.core.config.args.Args;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.common.DB;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.db2.common.Key;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.core.ISession;
import org.tron.core.db2.core.RevokingDBWithCachingNewValue;
import org.tron.core.db2.core.Snapshot;
import org.tron.core.db2.core.SnapshotImpl;
import org.tron.core.db2.core.SnapshotRoot;
import org.tron.core.exception.RevokingStoreIllegalStateException;

public class SnapshotManager
implements RevokingDatabase {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotManager.class);
    private static final int DEFAULT_STACK_MAX_SIZE = 256;
    public static final int DEFAULT_MAX_FLUSH_COUNT = 500;
    public static final int DEFAULT_MIN_FLUSH_COUNT = 1;
    private List<RevokingDBWithCachingNewValue> dbs = new ArrayList<RevokingDBWithCachingNewValue>();
    private int size = 0;
    private AtomicInteger maxSize = new AtomicInteger(256);
    private boolean disabled = true;
    private int activeSession = 0;
    private boolean unChecked = true;
    private volatile int flushCount = 0;
    private Map<String, ListeningExecutorService> flushServices = new HashMap<String, ListeningExecutorService>();
    private volatile int maxFlushCount = 1;

    @Override
    public ISession buildSession() {
        return this.buildSession(false);
    }

    @Override
    public synchronized ISession buildSession(boolean forceEnable) {
        boolean disableOnExit;
        if (this.disabled && !forceEnable) {
            return new Session(this);
        }
        boolean bl = disableOnExit = this.disabled && forceEnable;
        if (forceEnable) {
            this.disabled = false;
        }
        if (this.size > this.maxSize.get()) {
            this.flushCount += this.size - this.maxSize.get();
            this.updateSolidity(this.size - this.maxSize.get());
            this.size = this.maxSize.get();
            this.flush();
        }
        this.advance();
        ++this.activeSession;
        return new Session(this, disableOnExit);
    }

    @Override
    public void add(IRevokingDB db) {
        RevokingDBWithCachingNewValue revokingDB = (RevokingDBWithCachingNewValue)db;
        this.dbs.add(revokingDB);
        this.flushServices.put(revokingDB.getDbName(), MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(revokingDB.getDbName()).build())));
    }

    private void advance() {
        this.dbs.forEach(db -> db.setHead(db.getHead().advance()));
        ++this.size;
    }

    private void retreat() {
        this.dbs.forEach(db -> db.setHead(db.getHead().retreat()));
        --this.size;
    }

    @Override
    public void merge() {
        if (this.activeSession <= 0) {
            throw new RevokingStoreIllegalStateException("activeDialog has to be greater than 0");
        }
        if (this.size < 2) {
            return;
        }
        this.dbs.forEach(db -> db.getHead().getPrevious().merge(db.getHead()));
        this.retreat();
        --this.activeSession;
    }

    @Override
    public synchronized void revoke() {
        if (this.disabled) {
            return;
        }
        if (this.activeSession <= 0) {
            throw new RevokingStoreIllegalStateException("activeSession has to be greater than 0");
        }
        if (this.size <= 0) {
            return;
        }
        this.disabled = true;
        try {
            this.retreat();
        }
        finally {
            this.disabled = false;
        }
        --this.activeSession;
    }

    @Override
    public synchronized void commit() {
        if (this.activeSession <= 0) {
            throw new RevokingStoreIllegalStateException("activeSession has to be greater than 0");
        }
        --this.activeSession;
    }

    @Override
    public synchronized void pop() {
        if (this.activeSession != 0) {
            throw new RevokingStoreIllegalStateException("activeSession has to be equal 0");
        }
        if (this.size <= 0) {
            throw new RevokingStoreIllegalStateException("there is not snapshot to be popped");
        }
        this.disabled = true;
        try {
            this.retreat();
        }
        finally {
            this.disabled = false;
        }
    }

    @Override
    public void fastPop() {
        this.pop();
    }

    @Override
    public synchronized void enable() {
        this.disabled = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize.set(maxSize);
    }

    public int getMaxSize() {
        return this.maxSize.get();
    }

    @Override
    public synchronized void disable() {
        this.disabled = true;
    }

    @Override
    public void shutdown() {
        System.err.println("******** begin to pop revokingDb ********");
        System.err.println("******** before revokingDb size:" + this.size);
        try {
            while (this.shouldBeRefreshed()) {
                logger.info("waiting leveldb flush done");
                TimeUnit.MILLISECONDS.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage() + e);
            Thread.currentThread().interrupt();
        }
        System.err.println("******** end to pop revokingDb ********");
    }

    public void updateSolidity(int hops) {
        for (int i = 0; i < hops; ++i) {
            for (RevokingDBWithCachingNewValue db : this.dbs) {
                db.getHead().updateSolidity();
            }
        }
    }

    private boolean shouldBeRefreshed() {
        return this.flushCount >= this.maxFlushCount;
    }

    private void refresh() {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(this.dbs.size());
        for (RevokingDBWithCachingNewValue db : this.dbs) {
            futures.add(this.flushServices.get(db.getDbName()).submit(() -> this.refreshOne(db)));
        }
        ListenableFuture future = Futures.allAsList(futures);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void refreshOne(RevokingDBWithCachingNewValue db) {
        if (Snapshot.isRoot(db.getHead())) {
            return;
        }
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        SnapshotRoot root = (SnapshotRoot)db.getHead().getRoot();
        Snapshot next = root;
        for (int i = 0; i < this.flushCount; ++i) {
            next = next.getNext();
            snapshots.add(next);
        }
        root.merge(snapshots);
        root.resetSolidity();
        if (db.getHead() == next) {
            db.setHead(root);
        } else {
            next.getNext().setPrevious(root);
            root.setNext(next.getNext());
        }
    }

    public void flush() {
        if (this.unChecked) {
            return;
        }
        if (this.shouldBeRefreshed()) {
            long start = System.currentTimeMillis();
            this.deleteCheckPoint();
            this.createCheckPoint();
            long checkPointEnd = System.currentTimeMillis();
            this.refresh();
            this.flushCount = 0;
            logger.info("flush cost:{}, create checkpoint cost:{}, refresh cost:{}", new Object[]{System.currentTimeMillis() - start, checkPointEnd - start, System.currentTimeMillis() - checkPointEnd});
        }
    }

    private void createCheckPoint() {
        HashMap<WrappedByteArray, WrappedByteArray> batch = new HashMap<WrappedByteArray, WrappedByteArray>();
        for (RevokingDBWithCachingNewValue db : this.dbs) {
            Snapshot head = db.getHead();
            if (Snapshot.isRoot(head)) {
                return;
            }
            String dbName = db.getDbName();
            Snapshot next = head.getRoot();
            for (int i = 0; i < this.flushCount; ++i) {
                next = next.getNext();
                SnapshotImpl snapshot = (SnapshotImpl)next;
                DB keyValueDB = snapshot.getDb();
                for (Map.Entry entry : keyValueDB) {
                    Key k2 = (Key)entry.getKey();
                    Value v = (Value)entry.getValue();
                    batch.put(WrappedByteArray.of(Bytes.concat((byte[][])new byte[][]{this.simpleEncode(dbName), k2.getBytes()})), WrappedByteArray.of(v.encode()));
                }
            }
        }
        LevelDbDataSourceImpl levelDbDataSource = new LevelDbDataSourceImpl(Args.getInstance().getOutputDirectoryByDbName("tmp"), "tmp");
        levelDbDataSource.initDB();
        levelDbDataSource.updateByBatch(batch.entrySet().stream().map(e -> Maps.immutableEntry((Object)((WrappedByteArray)e.getKey()).getBytes(), (Object)((WrappedByteArray)e.getValue()).getBytes())).collect(HashMap::new, (m, k) -> {
            byte[] cfr_ignored_0 = (byte[])m.put(k.getKey(), k.getValue());
        }, HashMap::putAll), new WriteOptions().sync(true));
        levelDbDataSource.closeDB();
    }

    private void deleteCheckPoint() {
        LevelDbDataSourceImpl levelDbDataSource = new LevelDbDataSourceImpl(Args.getInstance().getOutputDirectoryByDbName("tmp"), "tmp");
        FileUtil.recursiveDelete(levelDbDataSource.getDbPath().toString());
    }

    @Override
    public void check() {
        for (RevokingDBWithCachingNewValue db2 : this.dbs) {
            if (Snapshot.isRoot(db2.getHead())) continue;
            throw new IllegalStateException("first check.");
        }
        LevelDbDataSourceImpl levelDbDataSource = new LevelDbDataSourceImpl(Args.getInstance().getOutputDirectoryByDbName("tmp"), "tmp");
        levelDbDataSource.initDB();
        if (!levelDbDataSource.allKeys().isEmpty()) {
            Map<String, RevokingDBWithCachingNewValue> dbMap = this.dbs.stream().map(db -> Maps.immutableEntry((Object)db.getDbName(), (Object)db)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.advance();
            for (Map.Entry e : levelDbDataSource) {
                byte[] realValue;
                byte[] key = (byte[])e.getKey();
                byte[] value = (byte[])e.getValue();
                String db3 = SnapshotManager.simpleDecode(key);
                byte[] realKey = Arrays.copyOfRange(key, db3.getBytes().length + 4, key.length);
                byte[] byArray = realValue = value.length == 1 ? null : Arrays.copyOfRange(value, 1, value.length);
                if (realValue != null) {
                    dbMap.get(db3).getHead().put(realKey, realValue);
                    continue;
                }
                dbMap.get(db3).getHead().remove(realKey);
            }
            this.dbs.forEach(db -> db.getHead().getRoot().merge(db.getHead()));
            this.retreat();
        }
        levelDbDataSource.closeDB();
        this.unChecked = false;
    }

    private byte[] simpleEncode(String s) {
        byte[] bytes = s.getBytes();
        byte[] length = Ints.toByteArray((int)bytes.length);
        byte[] r = new byte[4 + bytes.length];
        System.arraycopy(length, 0, r, 0, 4);
        System.arraycopy(bytes, 0, r, 4, bytes.length);
        return r;
    }

    public static String simpleDecode(byte[] bytes) {
        byte[] lengthBytes = Arrays.copyOf(bytes, 4);
        int length = Ints.fromByteArray((byte[])lengthBytes);
        byte[] value = Arrays.copyOfRange(bytes, 4, 4 + length);
        return new String(value);
    }

    public List<RevokingDBWithCachingNewValue> getDbs() {
        return this.dbs;
    }

    public int getSize() {
        return this.size;
    }

    public int getActiveSession() {
        return this.activeSession;
    }

    public void setUnChecked(boolean unChecked) {
        this.unChecked = unChecked;
    }

    @Override
    public void setMaxFlushCount(int maxFlushCount) {
        this.maxFlushCount = maxFlushCount;
    }

    public static class Session
    implements ISession {
        private static final Logger logger = LoggerFactory.getLogger(Session.class);
        private SnapshotManager snapshotManager;
        private boolean applySnapshot = true;
        private boolean disableOnExit = false;

        public Session(SnapshotManager snapshotManager) {
            this(snapshotManager, false);
        }

        public Session(SnapshotManager snapshotManager, boolean disableOnExit) {
            this.snapshotManager = snapshotManager;
            this.disableOnExit = disableOnExit;
        }

        @Override
        public void commit() {
            this.applySnapshot = false;
            this.snapshotManager.commit();
        }

        @Override
        public void revoke() {
            if (this.applySnapshot) {
                this.snapshotManager.revoke();
            }
            this.applySnapshot = false;
        }

        @Override
        public void merge() {
            if (this.applySnapshot) {
                this.snapshotManager.merge();
            }
            this.applySnapshot = false;
        }

        @Override
        public void destroy() {
            try {
                if (this.applySnapshot) {
                    this.snapshotManager.revoke();
                }
            }
            catch (Exception e) {
                logger.error("revoke database error.", (Throwable)e);
            }
            if (this.disableOnExit) {
                this.snapshotManager.disable();
            }
        }

        @Override
        public void close() {
            try {
                if (this.applySnapshot) {
                    this.snapshotManager.revoke();
                }
            }
            catch (Exception e) {
                logger.error("revoke database error.", (Throwable)e);
                throw new RevokingStoreIllegalStateException(e);
            }
            if (this.disableOnExit) {
                this.snapshotManager.disable();
            }
        }

        public SnapshotManager getSnapshotManager() {
            return this.snapshotManager;
        }

        public boolean isApplySnapshot() {
            return this.applySnapshot;
        }

        public boolean isDisableOnExit() {
            return this.disableOnExit;
        }
    }
}

