/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.common.HashDB;
import org.tron.core.db2.common.Key;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.core.AbstractSnapshot;
import org.tron.core.db2.core.Snapshot;

public class SnapshotImpl
extends AbstractSnapshot<Key, Value> {
    protected Snapshot root;

    SnapshotImpl(Snapshot snapshot) {
        this.root = snapshot.getRoot();
        this.previous = snapshot;
        snapshot.setNext(this);
        this.db = new HashDB();
    }

    @Override
    public byte[] get(byte[] key) {
        return this.get(this, key);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        Preconditions.checkNotNull((Object)key, (Object)"key in db is not null.");
        Preconditions.checkNotNull((Object)value, (Object)"value in db is not null.");
        byte[] v = this.get(this.previous, key);
        Value.Operator operator = v == null ? Value.Operator.CREATE : Value.Operator.MODIFY;
        this.db.put(Key.copyOf(key), Value.copyOf(operator, value));
    }

    @Override
    public void remove(byte[] key) {
        Preconditions.checkNotNull((Object)key, (Object)"key in db is not null.");
        if (this.get(key) != null) {
            this.db.put(Key.of(key), Value.of(Value.Operator.DELETE, null));
        }
    }

    private byte[] get(Snapshot head, byte[] key) {
        Snapshot snapshot = head;
        while (Snapshot.isImpl(snapshot)) {
            Value value = (Value)((SnapshotImpl)snapshot).db.get(Key.of(key));
            if (value != null) {
                return value.getBytes();
            }
            snapshot = snapshot.getPrevious();
        }
        return snapshot == null ? null : snapshot.get(key);
    }

    @Override
    public void merge(Snapshot from) {
        SnapshotImpl fromImpl = (SnapshotImpl)from;
        Streams.stream((Iterable)fromImpl.db).filter(e -> ((Value)e.getValue()).getOperator() == Value.Operator.CREATE).forEach(e -> {
            Key k = (Key)e.getKey();
            Value v = (Value)e.getValue();
            Value value = (Value)this.db.get(k);
            if (value == null) {
                this.db.put(k, v);
            } else if (value.getOperator() == Value.Operator.DELETE) {
                this.db.put(k, Value.copyOf(Value.Operator.MODIFY, v.getBytes()));
            } else {
                throw new IllegalStateException();
            }
        });
        Streams.stream((Iterable)fromImpl.db).filter(e -> ((Value)e.getValue()).getOperator() == Value.Operator.MODIFY).forEach(e -> {
            Key k = (Key)e.getKey();
            Value v = (Value)e.getValue();
            Value value = (Value)this.db.get(k);
            if (value == null || value.getOperator() == Value.Operator.MODIFY) {
                this.db.put(k, v);
            } else if (value.getOperator() == Value.Operator.CREATE) {
                this.db.put(k, Value.copyOf(Value.Operator.CREATE, v.getBytes()));
            } else {
                throw new IllegalStateException();
            }
        });
        Streams.stream((Iterable)fromImpl.db).filter(e -> ((Value)e.getValue()).getOperator() == Value.Operator.DELETE).map(Map.Entry::getKey).forEach(k -> {
            Value value = (Value)this.db.get(k);
            if (value == null || value.getOperator() == Value.Operator.MODIFY) {
                this.db.put(k, Value.of(Value.Operator.DELETE, null));
            } else if (value.getOperator() == Value.Operator.CREATE) {
                this.db.remove(k);
            } else {
                throw new IllegalStateException();
            }
        });
    }

    @Override
    public Snapshot retreat() {
        return this.previous;
    }

    @Override
    public Snapshot getSolidity() {
        return this.root.getSolidity();
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        HashMap<WrappedByteArray, WrappedByteArray> all = new HashMap<WrappedByteArray, WrappedByteArray>();
        this.collect(all);
        HashSet keys = new HashSet(all.keySet());
        all.entrySet().removeIf(entry -> entry.getValue() == null || ((WrappedByteArray)entry.getValue()).getBytes() == null);
        return Iterators.concat((Iterator)Iterators.transform(all.entrySet().iterator(), e -> Maps.immutableEntry((Object)((WrappedByteArray)e.getKey()).getBytes(), (Object)((WrappedByteArray)e.getValue()).getBytes())), (Iterator)Iterators.filter(this.getRoot().iterator(), e -> !keys.contains(WrappedByteArray.of((byte[])e.getKey()))));
    }

    void collect(Map<WrappedByteArray, WrappedByteArray> all) {
        for (Snapshot next = this.getRoot().getNext(); next != null; next = next.getNext()) {
            Streams.stream((Iterable)((SnapshotImpl)next).db).forEach(e -> all.put(WrappedByteArray.of(((Key)e.getKey()).getBytes()), WrappedByteArray.of(((Value)e.getValue()).getBytes())));
        }
    }

    @Override
    public void close() {
        this.getRoot().close();
    }

    @Override
    public void reset() {
        this.getRoot().reset();
    }

    @Override
    public void resetSolidity() {
        this.root.resetSolidity();
    }

    @Override
    public void updateSolidity() {
        this.root.updateSolidity();
    }

    @Override
    public Snapshot getRoot() {
        return this.root;
    }
}

