/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.iq80.leveldb.WriteOptions;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db2.common.DB;

public class LevelDB
implements DB<byte[], byte[]> {
    private LevelDbDataSourceImpl db;
    private WriteOptions writeOptions = new WriteOptions().sync(true);

    public LevelDB(String parentName, String name) {
        this.db = new LevelDbDataSourceImpl(parentName, name);
        this.db.initDB();
    }

    @Override
    public byte[] get(byte[] key) {
        return this.db.getData(key);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.db.putData(key, value);
    }

    @Override
    public long size() {
        return this.db.getTotal();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public void remove(byte[] key) {
        this.db.deleteData(key);
    }

    public DBIterator iterator() {
        return this.db.iterator();
    }

    public void flush(Map<WrappedByteArray, WrappedByteArray> batch) {
        Map rows = batch.entrySet().stream().map(e -> Maps.immutableEntry((Object)((WrappedByteArray)e.getKey()).getBytes(), (Object)((WrappedByteArray)e.getValue()).getBytes())).collect(HashMap::new, (m, k) -> {
            byte[] cfr_ignored_0 = (byte[])m.put(k.getKey(), k.getValue());
        }, HashMap::putAll);
        this.db.updateByBatch(rows, this.writeOptions);
    }

    public void close() {
        this.db.closeDB();
    }

    public void reset() {
        this.db.resetDb();
    }

    public LevelDbDataSourceImpl getDb() {
        return this.db;
    }
}

