/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api.index;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import com.googlecode.cqengine.query.QueryFactory;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.db.api.index.AbstractIndex;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.protos.Protocol;

@Component
public class AccountIndex
extends AbstractIndex<AccountCapsule, Protocol.Account> {
    private static final Logger logger = LoggerFactory.getLogger(AccountIndex.class);
    public static SimpleAttribute<WrappedByteArray, String> Account_ADDRESS;

    @Autowired
    public AccountIndex(@Qualifier(value="accountStore") ITronChainBase<AccountCapsule> database) {
        super(database);
    }

    @PostConstruct
    public void init() {
        this.initIndex((Persistence<WrappedByteArray, Comparable>)DiskPersistence.onPrimaryKeyInFile(Account_ADDRESS, (File)this.indexPath));
    }

    @Override
    protected void setAttribute() {
        Account_ADDRESS = QueryFactory.attribute((String)"account address", bytes -> ByteArray.toHexString(bytes.getBytes()));
    }
}

