/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api;

import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.api.index.Index;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class IndexHelper {
    private static final Logger logger = LoggerFactory.getLogger(IndexHelper.class);
    @Resource
    private Index.Iface<Protocol.Transaction> transactionIndex;
    @Resource
    private Index.Iface<Protocol.Block> blockIndex;
    @Resource
    private Index.Iface<Protocol.Witness> witnessIndex;
    @Resource
    private Index.Iface<Protocol.Account> accountIndex;
    @Resource
    private Index.Iface<Contract.AssetIssueContract> assetIssueIndex;

    public void init() {
        this.transactionIndex.fill();
    }

    private <T> void add(Index.Iface<T> index, byte[] bytes) {
        index.add(bytes);
    }

    public void add(Protocol.Transaction t) {
        this.add(this.transactionIndex, this.getKey(t));
    }

    public void add(Protocol.Block b) {
    }

    public void add(Protocol.Witness w) {
    }

    public void add(Protocol.Account a) {
    }

    public void add(Contract.AssetIssueContract a) {
    }

    private <T> void update(Index.Iface<T> index, byte[] bytes) {
        index.update(bytes);
    }

    public void update(Protocol.Transaction t) {
        this.update(this.transactionIndex, this.getKey(t));
    }

    public void update(Protocol.Block b) {
    }

    public void update(Protocol.Witness w) {
    }

    public void update(Protocol.Account a) {
    }

    public void update(Contract.AssetIssueContract a) {
    }

    private <T> void remove(Index.Iface<T> index, byte[] bytes) {
        index.remove(bytes);
    }

    public void remove(Protocol.Transaction t) {
        this.remove(this.transactionIndex, this.getKey(t));
    }

    public void remove(Protocol.Block b) {
    }

    public void remove(Protocol.Witness w) {
    }

    public void remove(Protocol.Account a) {
    }

    public void remove(Contract.AssetIssueContract a) {
    }

    private byte[] getKey(Protocol.Transaction t) {
        return new TransactionCapsule(t).getTransactionId().getBytes();
    }

    private byte[] getKey(Protocol.Block b) {
        return new BlockCapsule(b).getBlockId().getBytes();
    }

    private byte[] getKey(Protocol.Witness w) {
        return new WitnessCapsule(w).createDbKey();
    }

    private byte[] getKey(Protocol.Account a) {
        return new AccountCapsule(a).createDbKey();
    }

    private byte[] getKey(Contract.AssetIssueContract a) {
        return new AssetIssueCapsule(a).createDbKey();
    }

    public Index.Iface<Protocol.Transaction> getTransactionIndex() {
        return this.transactionIndex;
    }

    public Index.Iface<Protocol.Block> getBlockIndex() {
        return this.blockIndex;
    }

    public Index.Iface<Protocol.Witness> getWitnessIndex() {
        return this.witnessIndex;
    }

    public Index.Iface<Protocol.Account> getAccountIndex() {
        return this.accountIndex;
    }

    public Index.Iface<Contract.AssetIssueContract> getAssetIssueIndex() {
        return this.assetIssueIndex;
    }
}

