/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.AbstractRevokingStore;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db.api.IndexHelper;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.core.db2.core.RevokingDBWithCachingNewValue;
import org.tron.core.db2.core.RevokingDBWithCachingOldValue;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;

public abstract class TronStoreWithRevoking<T extends ProtoCapsule>
implements ITronChainBase<T> {
    private static final Logger logger = LoggerFactory.getLogger(TronStoreWithRevoking.class);
    protected IRevokingDB revokingDB;
    private TypeToken<T> token = new TypeToken<T>(this.getClass()){};
    @Autowired
    private RevokingDatabase revokingDatabase;
    @Autowired(required=false)
    protected IndexHelper indexHelper;
    private String dbName;

    protected TronStoreWithRevoking(String dbName) {
        this.dbName = dbName;
        int dbVersion = Args.getInstance().getStorage().getDbVersion();
        if (dbVersion == 1) {
            this.revokingDB = new RevokingDBWithCachingOldValue(dbName);
        } else if (dbVersion == 2) {
            this.revokingDB = new RevokingDBWithCachingNewValue(dbName);
        } else {
            throw new RuntimeException("db version is error.");
        }
    }

    @PostConstruct
    private void init() {
        this.revokingDatabase.add(this.revokingDB);
    }

    protected TronStoreWithRevoking(String dbName, RevokingDatabase revokingDatabase) {
        this.revokingDB = new RevokingDBWithCachingOldValue(dbName, (AbstractRevokingStore)revokingDatabase);
    }

    @Override
    public void put(byte[] key, T item) {
        if (Objects.isNull(key) || Objects.isNull(item)) {
            return;
        }
        this.revokingDB.put(key, item.getData());
    }

    @Override
    public void delete(byte[] key) {
        this.revokingDB.delete(key);
    }

    @Override
    public T get(byte[] key) throws ItemNotFoundException, BadItemException {
        return this.of(this.revokingDB.get(key));
    }

    @Override
    public T getUnchecked(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        try {
            return this.of(value);
        }
        catch (BadItemException e) {
            return null;
        }
    }

    public T getOnSolidity(byte[] key) throws ItemNotFoundException, BadItemException {
        return this.of(this.revokingDB.getOnSolidity(key));
    }

    public T getUncheckedOnSolidity(byte[] key) {
        byte[] value = this.revokingDB.getUncheckedOnSolidity(key);
        try {
            return this.of(value);
        }
        catch (BadItemException e) {
            return null;
        }
    }

    public T of(byte[] value) throws BadItemException {
        try {
            Constructor constructor = this.token.getRawType().getConstructor(byte[].class);
            ProtoCapsule t = (ProtoCapsule)constructor.newInstance(new Object[]{value});
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadItemException(e.getMessage());
        }
    }

    public boolean hasOnSolidity(byte[] key) {
        return this.revokingDB.hasOnSolidity(key);
    }

    @Override
    public boolean has(byte[] key) {
        return this.revokingDB.has(key);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void close() {
        this.revokingDB.close();
    }

    @Override
    public void reset() {
        this.revokingDB.reset();
    }

    @Override
    public Iterator<Map.Entry<byte[], T>> iterator() {
        return Iterators.transform(this.revokingDB.iterator(), e -> {
            try {
                return Maps.immutableEntry(e.getKey(), this.of((byte[])e.getValue()));
            }
            catch (BadItemException e1) {
                throw new RuntimeException(e1);
            }
        });
    }

    public Iterator<Map.Entry<byte[], T>> iteratorOnSolidity() {
        return Iterators.transform(((RevokingDBWithCachingNewValue)this.revokingDB).iteratorOnSolidity(), e -> {
            try {
                return Maps.immutableEntry(e.getKey(), this.of((byte[])e.getValue()));
            }
            catch (BadItemException e1) {
                throw new RuntimeException(e1);
            }
        });
    }

    public long size() {
        return Streams.stream(this.revokingDB.iterator()).count();
    }

    public IRevokingDB getRevokingDB() {
        return this.revokingDB;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }
}

