/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.TronDatabase;
import org.tron.core.exception.BadNumberBlockException;
import org.tron.core.exception.NonCommonBlockException;
import org.tron.core.exception.UnLinkedBlockException;

@Component
public class KhaosDatabase
extends TronDatabase {
    private KhaosBlock head;
    private KhaosStore miniStore = new KhaosStore();
    private KhaosStore miniUnlinkedStore = new KhaosStore();

    @Autowired
    protected KhaosDatabase(@Value(value="block_KDB") String dbName) {
        super(dbName);
    }

    @Override
    public void put(byte[] key, Object item) {
    }

    @Override
    public void delete(byte[] key) {
    }

    @Override
    public Object get(byte[] key) {
        return null;
    }

    @Override
    public boolean has(byte[] key) {
        return false;
    }

    void start(BlockCapsule blk) {
        this.head = new KhaosBlock(blk);
        this.miniStore.insert(this.head);
    }

    void setHead(KhaosBlock blk) {
        this.head = blk;
    }

    void removeBlk(Sha256Hash hash) {
        if (!this.miniStore.remove(hash)) {
            this.miniUnlinkedStore.remove(hash);
        }
        this.head = this.miniStore.numKblkMap.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getKey)).map(Map.Entry::getValue).map(list -> (KhaosBlock)list.get(0)).orElseThrow(() -> new RuntimeException("khaosDB head should not be null."));
    }

    public Boolean containBlock(Sha256Hash hash) {
        return this.miniStore.getByHash(hash) != null || this.miniUnlinkedStore.getByHash(hash) != null;
    }

    public Boolean containBlockInMiniStore(Sha256Hash hash) {
        return this.miniStore.getByHash(hash) != null;
    }

    public BlockCapsule getBlock(Sha256Hash hash) {
        return Stream.of(this.miniStore.getByHash(hash), this.miniUnlinkedStore.getByHash(hash)).filter(Objects::nonNull).map(block -> block.blk).findFirst().orElse(null);
    }

    public BlockCapsule push(BlockCapsule blk) throws UnLinkedBlockException, BadNumberBlockException {
        KhaosBlock block = new KhaosBlock(blk);
        if (this.head != null && block.getParentHash() != Sha256Hash.ZERO_HASH) {
            KhaosBlock kblock = this.miniStore.getByHash(block.getParentHash());
            if (kblock != null) {
                if (blk.getNum() != kblock.num + 1L) {
                    throw new BadNumberBlockException("parent number :" + kblock.num + ",block number :" + blk.getNum());
                }
                block.setParent(kblock);
            } else {
                this.miniUnlinkedStore.insert(block);
                throw new UnLinkedBlockException();
            }
        }
        this.miniStore.insert(block);
        if (this.head == null || block.num > this.head.num) {
            this.head = block;
        }
        return this.head.blk;
    }

    public BlockCapsule getHead() {
        return this.head.blk;
    }

    public boolean pop() {
        KhaosBlock prev = this.head.getParent();
        if (prev != null) {
            this.head = prev;
            return true;
        }
        return false;
    }

    public void setMaxSize(int maxSize) {
        this.miniUnlinkedStore.setMaxCapcity(maxSize);
        this.miniStore.setMaxCapcity(maxSize);
    }

    public Pair<LinkedList<KhaosBlock>, LinkedList<KhaosBlock>> getBranch(Sha256Hash block1, Sha256Hash block2) throws NonCommonBlockException {
        LinkedList<KhaosBlock> list1 = new LinkedList<KhaosBlock>();
        LinkedList<KhaosBlock> list2 = new LinkedList<KhaosBlock>();
        KhaosBlock kblk1 = this.miniStore.getByHash(block1);
        this.checkNull(kblk1);
        KhaosBlock kblk2 = this.miniStore.getByHash(block2);
        this.checkNull(kblk2);
        while (kblk1.num > kblk2.num) {
            list1.add(kblk1);
            kblk1 = kblk1.getParent();
            this.checkNull(kblk1);
            this.checkNull(this.miniStore.getByHash(kblk1.id));
        }
        while (kblk2.num > kblk1.num) {
            list2.add(kblk2);
            kblk2 = kblk2.getParent();
            this.checkNull(kblk2);
            this.checkNull(this.miniStore.getByHash(kblk2.id));
        }
        while (!Objects.equals(kblk1, kblk2)) {
            list1.add(kblk1);
            list2.add(kblk2);
            kblk1 = kblk1.getParent();
            this.checkNull(kblk1);
            this.checkNull(this.miniStore.getByHash(kblk1.id));
            kblk2 = kblk2.getParent();
            this.checkNull(kblk2);
            this.checkNull(this.miniStore.getByHash(kblk2.id));
        }
        return new Pair(list1, list2);
    }

    private void checkNull(Object o) throws NonCommonBlockException {
        if (o == null) {
            throw new NonCommonBlockException();
        }
    }

    @Deprecated
    public Pair<LinkedList<BlockCapsule>, LinkedList<BlockCapsule>> getBranch(BlockCapsule.BlockId block1, BlockCapsule.BlockId block2) {
        LinkedList<BlockCapsule> list1 = new LinkedList<BlockCapsule>();
        LinkedList<BlockCapsule> list2 = new LinkedList<BlockCapsule>();
        KhaosBlock kblk1 = this.miniStore.getByHash(block1);
        KhaosBlock kblk2 = this.miniStore.getByHash(block2);
        if (kblk1 != null && kblk2 != null) {
            while (!Objects.equals(kblk1, kblk2)) {
                if (kblk1.num > kblk2.num) {
                    list1.add(kblk1.blk);
                    kblk1 = kblk1.getParent();
                    continue;
                }
                if (kblk1.num < kblk2.num) {
                    list2.add(kblk2.blk);
                    kblk2 = kblk2.getParent();
                    continue;
                }
                list1.add(kblk1.blk);
                list2.add(kblk2.blk);
                kblk1 = kblk1.getParent();
                kblk2 = kblk2.getParent();
            }
        }
        return new Pair(list1, list2);
    }

    public BlockCapsule getParentBlock(Sha256Hash hash) {
        return Stream.of(this.miniStore.getByHash(hash), this.miniUnlinkedStore.getByHash(hash)).filter(Objects::nonNull).map(KhaosBlock::getParent).map(khaosBlock -> khaosBlock == null ? null : khaosBlock.blk).filter(Objects::nonNull).filter(b -> this.containBlock(b.getBlockId())).findFirst().orElse(null);
    }

    public boolean hasData() {
        return !this.miniStore.hashKblkMap.isEmpty();
    }

    public KhaosStore getMiniStore() {
        return this.miniStore;
    }

    public KhaosStore getMiniUnlinkedStore() {
        return this.miniUnlinkedStore;
    }

    public class KhaosStore {
        private HashMap<BlockCapsule.BlockId, KhaosBlock> hashKblkMap = new HashMap();
        private int maxCapcity = 1024;
        private LinkedHashMap<Long, ArrayList<KhaosBlock>> numKblkMap = new LinkedHashMap<Long, ArrayList<KhaosBlock>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, ArrayList<KhaosBlock>> entry) {
                long minNum = Long.max(0L, ((KhaosDatabase)KhaosDatabase.this).head.num - (long)KhaosStore.this.maxCapcity);
                Map<Long, ArrayList> minNumMap = KhaosStore.this.numKblkMap.entrySet().stream().filter(e -> (Long)e.getKey() < minNum).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                minNumMap.forEach((k, v) -> {
                    KhaosStore.this.numKblkMap.remove(k);
                    v.forEach((? super E b) -> {
                        KhaosBlock cfr_ignored_0 = (KhaosBlock)KhaosStore.this.hashKblkMap.remove(b.id);
                    });
                });
                return false;
            }
        };

        public void setMaxCapcity(int maxCapcity) {
            this.maxCapcity = maxCapcity;
        }

        public void insert(KhaosBlock block) {
            this.hashKblkMap.put(block.id, block);
            this.numKblkMap.computeIfAbsent(block.num, listBlk -> new ArrayList()).add(block);
        }

        public boolean remove(Sha256Hash hash) {
            KhaosBlock block = this.hashKblkMap.get(hash);
            if (block != null) {
                long num = block.num;
                ArrayList<KhaosBlock> listBlk = this.numKblkMap.get(num);
                if (listBlk != null) {
                    listBlk.removeIf(b -> b.id.equals(hash));
                }
                if (CollectionUtils.isEmpty(listBlk)) {
                    this.numKblkMap.remove(num);
                }
                this.hashKblkMap.remove(hash);
                return true;
            }
            return false;
        }

        public List<KhaosBlock> getBlockByNum(Long num) {
            return this.numKblkMap.get(num);
        }

        public KhaosBlock getByHash(Sha256Hash hash) {
            return this.hashKblkMap.get(hash);
        }

        public int size() {
            return this.hashKblkMap.size();
        }

        public LinkedHashMap<Long, ArrayList<KhaosBlock>> getNumKblkMap() {
            return this.numKblkMap;
        }
    }

    public static class KhaosBlock {
        BlockCapsule blk;
        Reference<KhaosBlock> parent = new WeakReference<Object>(null);
        BlockCapsule.BlockId id;
        Boolean invalid;
        long num;

        public Sha256Hash getParentHash() {
            return this.blk.getParentHash();
        }

        public KhaosBlock(BlockCapsule blk) {
            this.blk = blk;
            this.id = blk.getBlockId();
            this.num = blk.getNum();
        }

        public KhaosBlock getParent() {
            return this.parent == null ? null : this.parent.get();
        }

        public void setParent(KhaosBlock parent) {
            this.parent = new WeakReference<KhaosBlock>(parent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KhaosBlock that = (KhaosBlock)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public BlockCapsule getBlk() {
            return this.blk;
        }
    }
}

