/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.ResourceProcessor;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Protocol;

public class EnergyProcessor
extends ResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EnergyProcessor.class);

    public EnergyProcessor(Manager manager) {
        super(manager);
    }

    @Override
    public void updateUsage(AccountCapsule accountCapsule) {
        long now = this.dbManager.getWitnessController().getHeadSlot();
        this.updateUsage(accountCapsule, now);
    }

    private void updateUsage(AccountCapsule accountCapsule, long now) {
        Protocol.Account.AccountResource accountResource = accountCapsule.getAccountResource();
        long oldEnergyUsage = accountResource.getEnergyUsage();
        long latestConsumeTime = accountResource.getLatestConsumeTimeForEnergy();
        accountCapsule.setEnergyUsage(this.increase(oldEnergyUsage, 0L, latestConsumeTime, now));
    }

    public void updateTotalEnergyAverageUsage(long now, long energy) {
        long totalNetAverageUsage = this.dbManager.getDynamicPropertiesStore().getTotalEnergyAverageUsage();
        long totalNetAverageTime = this.dbManager.getDynamicPropertiesStore().getTotalEnergyAverageTime();
        long newPublicNetAverageUsage = this.increase(totalNetAverageUsage, energy, totalNetAverageTime, now, this.averageWindowSize);
        this.dbManager.getDynamicPropertiesStore().saveTotalEnergyAverageUsage(newPublicNetAverageUsage);
        this.dbManager.getDynamicPropertiesStore().saveTotalEnergyAverageTime(now);
    }

    @Override
    public void consume(TransactionCapsule trx, TransactionTrace trace) throws ContractValidateException, AccountResourceInsufficientException {
        List<Protocol.Transaction.Contract> contracts = trx.getInstance().getRawData().getContractList();
        for (Protocol.Transaction.Contract contract : contracts) {
            long energy = 100L;
            logger.debug("trxId {},energy cost :{}", (Object)trx.getTransactionId(), (Object)energy);
            byte[] address = TransactionCapsule.getOwner(contract);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(address);
            if (accountCapsule == null) {
                throw new ContractValidateException("account not exists");
            }
            long now = this.dbManager.getWitnessController().getHeadSlot();
            int creatorRatio = 50;
            long creatorEnergy = energy * (long)creatorRatio / 100L;
            AccountCapsule contractProvider = this.dbManager.getAccountStore().get(contract.getProvider().toByteArray());
            if (!this.useEnergy(contractProvider, creatorEnergy, now)) {
                throw new ContractValidateException("creator has not enough energy[" + creatorEnergy + "]");
            }
            long userEnergy = energy * (long)(100 - creatorRatio) / 100L;
            if (this.useEnergy(accountCapsule, userEnergy, now)) continue;
            long feeLimit = 1000000L;
            long fee = this.calculateFee(userEnergy);
            if (fee > feeLimit) {
                throw new AccountResourceInsufficientException("Account has Insufficient Energy[" + userEnergy + "] and feeLimit[" + feeLimit + "] is not enough to trigger this contract");
            }
            if (this.useFee(accountCapsule, fee, trace)) continue;
            throw new AccountResourceInsufficientException("Account has insufficient Energy[" + userEnergy + "] and balance[" + fee + "] to trigger this contract");
        }
    }

    private long calculateFee(long userEnergy) {
        return userEnergy * 30L;
    }

    private boolean useFee(AccountCapsule accountCapsule, long fee, TransactionTrace trace) {
        if (this.consumeFee(accountCapsule, fee)) {
            trace.setNetBill(0L, fee);
            return true;
        }
        return false;
    }

    public boolean useEnergy(AccountCapsule accountCapsule, long energy, long now) {
        long newEnergyUsage;
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        long energyLimit = this.calculateGlobalEnergyLimit(accountCapsule);
        if (energy > energyLimit - (newEnergyUsage = this.increase(energyUsage, 0L, latestConsumeTime, now))) {
            return false;
        }
        latestConsumeTime = now;
        long latestOperationTime = this.dbManager.getHeadBlockTimeStamp();
        newEnergyUsage = this.increase(newEnergyUsage, energy, latestConsumeTime, now);
        accountCapsule.setEnergyUsage(newEnergyUsage);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        accountCapsule.setLatestConsumeTimeForEnergy(latestConsumeTime);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        if (this.dbManager.getDynamicPropertiesStore().getAllowAdaptiveEnergy() == 1L) {
            this.updateTotalEnergyAverageUsage(now, energy);
        }
        return true;
    }

    public long calculateGlobalEnergyLimit(AccountCapsule accountCapsule) {
        long frozeBalance = accountCapsule.getAllFrozenBalanceForEnergy();
        if (frozeBalance < 1000000L) {
            return 0L;
        }
        long energyWeight = frozeBalance / 1000000L;
        long totalEnergyLimit = this.dbManager.getDynamicPropertiesStore().getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.dbManager.getDynamicPropertiesStore().getTotalEnergyWeight();
        assert (totalEnergyWeight > 0L);
        return (long)((double)energyWeight * ((double)totalEnergyLimit / (double)totalEnergyWeight));
    }

    public long getAccountLeftEnergyFromFreeze(AccountCapsule accountCapsule) {
        long now = this.dbManager.getWitnessController().getHeadSlot();
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        long energyLimit = this.calculateGlobalEnergyLimit(accountCapsule);
        long newEnergyUsage = this.increase(energyUsage, 0L, latestConsumeTime, now);
        return Long.max(energyLimit - newEnergyUsage, 0L);
    }
}

