/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.collect.Streams;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.protos.Protocol;

@Component
public class ContractStore
extends TronStoreWithRevoking<ContractCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(ContractStore.class);
    private static ContractStore instance;

    @Autowired
    private ContractStore(@Value(value="contract") String dbName) {
        super(dbName);
    }

    @Override
    public ContractCapsule get(byte[] key) {
        return (ContractCapsule)this.getUnchecked(key);
    }

    public long getTotalContracts() {
        return Streams.stream(this.revokingDB.iterator()).count();
    }

    public static void destory() {
        instance = null;
    }

    void destroy() {
        instance = null;
    }

    public byte[] findContractByHash(byte[] trxHash) {
        return this.revokingDB.getUnchecked(trxHash);
    }

    public Protocol.SmartContract.ABI getABI(byte[] contractAddress) {
        byte[] value = this.revokingDB.getUnchecked(contractAddress);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return null;
        }
        ContractCapsule contractCapsule = new ContractCapsule(value);
        Protocol.SmartContract smartContract = contractCapsule.getInstance();
        if (smartContract == null) {
            return null;
        }
        return smartContract.getAbi();
    }
}

