/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.collect.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.CodeCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class CodeStore
extends TronStoreWithRevoking<CodeCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(CodeStore.class);
    private static CodeStore instance;

    @Autowired
    private CodeStore(@Value(value="code") String dbName) {
        super(dbName);
    }

    @Override
    public CodeCapsule get(byte[] key) {
        return (CodeCapsule)this.getUnchecked(key);
    }

    public long getTotalCodes() {
        return Streams.stream(this.revokingDB.iterator()).count();
    }

    public static void destory() {
        instance = null;
    }

    void destroy() {
        instance = null;
    }

    public byte[] findCodeByHash(byte[] hash) {
        return this.revokingDB.getUnchecked(hash);
    }
}

