/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.db2.core.RevokingDBWithCachingNewValue;
import org.tron.core.exception.BadItemException;

@Component
public class BlockStore
extends TronStoreWithRevoking<BlockCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(BlockStore.class);

    @Autowired
    private BlockStore(@Value(value="block") String dbName) {
        super(dbName);
    }

    public List<BlockCapsule> getLimitNumber(long startNumber, long limit) {
        BlockCapsule.BlockId startBlockId = new BlockCapsule.BlockId(Sha256Hash.ZERO_HASH, startNumber);
        return this.revokingDB.getValuesNext(startBlockId.getBytes(), limit).stream().map(bytes -> {
            try {
                return new BlockCapsule((byte[])bytes);
            }
            catch (BadItemException badItemException) {
                return null;
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparing(BlockCapsule::getNum)).collect(Collectors.toList());
    }

    public List<BlockCapsule> getLimitNumberOnSolidity(long startNumber, long limit) {
        BlockCapsule.BlockId startBlockId = new BlockCapsule.BlockId(Sha256Hash.ZERO_HASH, startNumber);
        return ((RevokingDBWithCachingNewValue)this.revokingDB).getValuesNextOnSolidity(startBlockId.getBytes(), limit).stream().map(bytes -> {
            try {
                return new BlockCapsule((byte[])bytes);
            }
            catch (BadItemException badItemException) {
                return null;
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparing(BlockCapsule::getNum)).collect(Collectors.toList());
    }

    public List<BlockCapsule> getBlockByLatestNum(long getNum) {
        return this.revokingDB.getlatestValues(getNum).stream().map(bytes -> {
            try {
                return new BlockCapsule((byte[])bytes);
            }
            catch (BadItemException badItemException) {
                return null;
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparing(BlockCapsule::getNum)).collect(Collectors.toList());
    }

    public List<BlockCapsule> getBlockByLatestNumOnSolidity(long getNum) {
        return ((RevokingDBWithCachingNewValue)this.revokingDB).getlatestValuesOnSolidity(getNum).stream().map(bytes -> {
            try {
                return new BlockCapsule((byte[])bytes);
            }
            catch (BadItemException badItemException) {
                return null;
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparing(BlockCapsule::getNum)).collect(Collectors.toList());
    }
}

