/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.ResourceProcessor;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class BandwidthProcessor
extends ResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BandwidthProcessor.class);

    public BandwidthProcessor(Manager manager) {
        super(manager);
    }

    @Override
    public void updateUsage(AccountCapsule accountCapsule) {
        long now = this.dbManager.getWitnessController().getHeadSlot();
        this.updateUsage(accountCapsule, now);
    }

    private void updateUsage(AccountCapsule accountCapsule, long now) {
        long oldNetUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        accountCapsule.setNetUsage(this.increase(oldNetUsage, 0L, latestConsumeTime, now));
        long oldFreeNetUsage = accountCapsule.getFreeNetUsage();
        long latestConsumeFreeTime = accountCapsule.getLatestConsumeFreeTime();
        accountCapsule.setFreeNetUsage(this.increase(oldFreeNetUsage, 0L, latestConsumeFreeTime, now));
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            Map<String, Long> assetMap = accountCapsule.getAssetMap();
            assetMap.forEach((assetName, balance) -> {
                long oldFreeAssetNetUsage = accountCapsule.getFreeAssetNetUsage((String)assetName);
                long latestAssetOperationTime = accountCapsule.getLatestAssetOperationTime((String)assetName);
                accountCapsule.putFreeAssetNetUsage((String)assetName, this.increase(oldFreeAssetNetUsage, 0L, latestAssetOperationTime, now));
            });
        }
        Map<String, Long> assetMapV2 = accountCapsule.getAssetMapV2();
        assetMapV2.forEach((assetName, balance) -> {
            long oldFreeAssetNetUsage = accountCapsule.getFreeAssetNetUsageV2((String)assetName);
            long latestAssetOperationTime = accountCapsule.getLatestAssetOperationTimeV2((String)assetName);
            accountCapsule.putFreeAssetNetUsageV2((String)assetName, this.increase(oldFreeAssetNetUsage, 0L, latestAssetOperationTime, now));
        });
    }

    @Override
    public void consume(TransactionCapsule trx, TransactionTrace trace) throws ContractValidateException, AccountResourceInsufficientException, TooBigTransactionResultException {
        List<Protocol.Transaction.Contract> contracts = trx.getInstance().getRawData().getContractList();
        if (trx.getResultSerializedSize() > 64L * (long)contracts.size()) {
            throw new TooBigTransactionResultException();
        }
        long bytesSize = this.dbManager.getDynamicPropertiesStore().supportVM() ? (long)trx.getInstance().toBuilder().clearRet().build().getSerializedSize() : trx.getSerializedSize();
        for (Protocol.Transaction.Contract contract : contracts) {
            if (this.dbManager.getDynamicPropertiesStore().supportVM()) {
                bytesSize += 64L;
            }
            logger.debug("trxId {},bandwidth cost :{}", (Object)trx.getTransactionId(), (Object)bytesSize);
            trace.setNetBill(bytesSize, 0L);
            byte[] address = TransactionCapsule.getOwner(contract);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(address);
            if (accountCapsule == null) {
                throw new ContractValidateException("account not exists");
            }
            long now = this.dbManager.getWitnessController().getHeadSlot();
            if (this.contractCreateNewAccount(contract)) {
                this.consumeForCreateNewAccount(accountCapsule, bytesSize, now, trace);
                continue;
            }
            if (contract.getType() == Protocol.Transaction.Contract.ContractType.TransferAssetContract && this.useAssetAccountNet(contract, accountCapsule, now, bytesSize) || this.useAccountNet(accountCapsule, bytesSize, now) || this.useFreeNet(accountCapsule, bytesSize, now) || this.useTransactionFee(accountCapsule, bytesSize, trace)) continue;
            long fee = this.dbManager.getDynamicPropertiesStore().getTransactionFee() * bytesSize;
            throw new AccountResourceInsufficientException("Account Insufficient bandwidth[" + bytesSize + "] and balance[" + fee + "] to create new account");
        }
    }

    private boolean useTransactionFee(AccountCapsule accountCapsule, long bytes, TransactionTrace trace) {
        long fee = this.dbManager.getDynamicPropertiesStore().getTransactionFee() * bytes;
        if (this.consumeFee(accountCapsule, fee)) {
            trace.setNetBill(0L, fee);
            this.dbManager.getDynamicPropertiesStore().addTotalTransactionCost(fee);
            return true;
        }
        return false;
    }

    private void consumeForCreateNewAccount(AccountCapsule accountCapsule, long bytes, long now, TransactionTrace trace) throws AccountResourceInsufficientException {
        boolean ret = this.consumeBandwidthForCreateNewAccount(accountCapsule, bytes, now);
        if (!ret && !(ret = this.consumeFeeForCreateNewAccount(accountCapsule, trace))) {
            throw new AccountResourceInsufficientException();
        }
    }

    public boolean consumeBandwidthForCreateNewAccount(AccountCapsule accountCapsule, long bytes, long now) {
        long newNetUsage;
        long createNewAccountBandwidthRatio = this.dbManager.getDynamicPropertiesStore().getCreateNewAccountBandwidthRate();
        long netUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        long netLimit = this.calculateGlobalNetLimit(accountCapsule);
        if (bytes * createNewAccountBandwidthRatio <= netLimit - (newNetUsage = this.increase(netUsage, 0L, latestConsumeTime, now))) {
            latestConsumeTime = now;
            long latestOperationTime = this.dbManager.getHeadBlockTimeStamp();
            newNetUsage = this.increase(newNetUsage, bytes * createNewAccountBandwidthRatio, latestConsumeTime, now);
            accountCapsule.setLatestConsumeTime(latestConsumeTime);
            accountCapsule.setLatestOperationTime(latestOperationTime);
            accountCapsule.setNetUsage(newNetUsage);
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            return true;
        }
        return false;
    }

    public boolean consumeFeeForCreateNewAccount(AccountCapsule accountCapsule, TransactionTrace trace) {
        long fee = this.dbManager.getDynamicPropertiesStore().getCreateAccountFee();
        if (this.consumeFee(accountCapsule, fee)) {
            trace.setNetBill(0L, fee);
            this.dbManager.getDynamicPropertiesStore().addTotalCreateAccountCost(fee);
            return true;
        }
        return false;
    }

    public boolean contractCreateNewAccount(Protocol.Transaction.Contract contract) {
        switch (contract.getType()) {
            case AccountCreateContract: {
                return true;
            }
            case TransferContract: {
                Contract.TransferContract transferContract;
                try {
                    transferContract = (Contract.TransferContract)contract.getParameter().unpack(Contract.TransferContract.class);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                AccountCapsule toAccount = this.dbManager.getAccountStore().get(transferContract.getToAddress().toByteArray());
                return toAccount == null;
            }
            case TransferAssetContract: {
                Contract.TransferAssetContract transferAssetContract;
                try {
                    transferAssetContract = (Contract.TransferAssetContract)contract.getParameter().unpack(Contract.TransferAssetContract.class);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                AccountCapsule toAccount = this.dbManager.getAccountStore().get(transferAssetContract.getToAddress().toByteArray());
                return toAccount == null;
            }
        }
        return false;
    }

    private boolean useAssetAccountNet(Protocol.Transaction.Contract contract, AccountCapsule accountCapsule, long now, long bytes) throws ContractValidateException {
        long newIssuerNetUsage;
        long latestAssetOperationTime;
        long freeAssetNetUsage;
        long publicLatestFreeNetTime;
        long publicFreeAssetNetUsage;
        long newPublicFreeAssetNetUsage;
        ByteString assetName;
        try {
            assetName = ((Contract.TransferAssetContract)contract.getParameter().unpack(Contract.TransferAssetContract.class)).getAssetName();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        AssetIssueCapsule assetIssueCapsule = this.dbManager.getAssetIssueStoreFinal().get(assetName.toByteArray());
        if (assetIssueCapsule == null) {
            throw new ContractValidateException("asset not exists");
        }
        String tokenName = ByteArray.toStr(assetName.toByteArray());
        String tokenID = assetIssueCapsule.getId();
        if (assetIssueCapsule.getOwnerAddress() == accountCapsule.getAddress()) {
            return this.useAccountNet(accountCapsule, bytes, now);
        }
        long publicFreeAssetNetLimit = assetIssueCapsule.getPublicFreeAssetNetLimit();
        if (bytes > publicFreeAssetNetLimit - (newPublicFreeAssetNetUsage = this.increase(publicFreeAssetNetUsage = assetIssueCapsule.getPublicFreeAssetNetUsage(), 0L, publicLatestFreeNetTime = assetIssueCapsule.getPublicLatestFreeNetTime(), now))) {
            logger.debug("The " + tokenID + " public free bandwidth is not enough");
            return false;
        }
        long freeAssetNetLimit = assetIssueCapsule.getFreeAssetNetLimit();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            freeAssetNetUsage = accountCapsule.getFreeAssetNetUsage(tokenName);
            latestAssetOperationTime = accountCapsule.getLatestAssetOperationTime(tokenName);
        } else {
            freeAssetNetUsage = accountCapsule.getFreeAssetNetUsageV2(tokenID);
            latestAssetOperationTime = accountCapsule.getLatestAssetOperationTimeV2(tokenID);
        }
        long newFreeAssetNetUsage = this.increase(freeAssetNetUsage, 0L, latestAssetOperationTime, now);
        if (bytes > freeAssetNetLimit - newFreeAssetNetUsage) {
            logger.debug("The " + tokenID + " free bandwidth is not enough");
            return false;
        }
        AccountCapsule issuerAccountCapsule = this.dbManager.getAccountStore().get(assetIssueCapsule.getOwnerAddress().toByteArray());
        long issuerNetUsage = issuerAccountCapsule.getNetUsage();
        long latestConsumeTime = issuerAccountCapsule.getLatestConsumeTime();
        long issuerNetLimit = this.calculateGlobalNetLimit(issuerAccountCapsule);
        if (bytes > issuerNetLimit - (newIssuerNetUsage = this.increase(issuerNetUsage, 0L, latestConsumeTime, now))) {
            logger.debug("The " + tokenID + " issuer'bandwidth is not enough");
            return false;
        }
        latestConsumeTime = now;
        latestAssetOperationTime = now;
        publicLatestFreeNetTime = now;
        long latestOperationTime = this.dbManager.getHeadBlockTimeStamp();
        newIssuerNetUsage = this.increase(newIssuerNetUsage, bytes, latestConsumeTime, now);
        newFreeAssetNetUsage = this.increase(newFreeAssetNetUsage, bytes, latestAssetOperationTime, now);
        newPublicFreeAssetNetUsage = this.increase(newPublicFreeAssetNetUsage, bytes, publicLatestFreeNetTime, now);
        issuerAccountCapsule.setNetUsage(newIssuerNetUsage);
        issuerAccountCapsule.setLatestConsumeTime(latestConsumeTime);
        assetIssueCapsule.setPublicFreeAssetNetUsage(newPublicFreeAssetNetUsage);
        assetIssueCapsule.setPublicLatestFreeNetTime(publicLatestFreeNetTime);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            accountCapsule.putLatestAssetOperationTimeMap(tokenName, latestAssetOperationTime);
            accountCapsule.putFreeAssetNetUsage(tokenName, newFreeAssetNetUsage);
            accountCapsule.putLatestAssetOperationTimeMapV2(tokenID, latestAssetOperationTime);
            accountCapsule.putFreeAssetNetUsageV2(tokenID, newFreeAssetNetUsage);
            this.dbManager.getAssetIssueStore().put(assetIssueCapsule.createDbKey(), assetIssueCapsule);
            AssetIssueCapsule assetIssueCapsuleV2 = this.dbManager.getAssetIssueV2Store().get(assetIssueCapsule.createDbV2Key());
            assetIssueCapsuleV2.setPublicFreeAssetNetUsage(newPublicFreeAssetNetUsage);
            assetIssueCapsuleV2.setPublicLatestFreeNetTime(publicLatestFreeNetTime);
            this.dbManager.getAssetIssueV2Store().put(assetIssueCapsuleV2.createDbV2Key(), assetIssueCapsuleV2);
        } else {
            accountCapsule.putLatestAssetOperationTimeMapV2(tokenID, latestAssetOperationTime);
            accountCapsule.putFreeAssetNetUsageV2(tokenID, newFreeAssetNetUsage);
            this.dbManager.getAssetIssueV2Store().put(assetIssueCapsule.createDbV2Key(), assetIssueCapsule);
        }
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        this.dbManager.getAccountStore().put(issuerAccountCapsule.createDbKey(), issuerAccountCapsule);
        return true;
    }

    public long calculateGlobalNetLimit(AccountCapsule accountCapsule) {
        long frozeBalance = accountCapsule.getAllFrozenBalanceForBandwidth();
        if (frozeBalance < 1000000L) {
            return 0L;
        }
        long netWeight = frozeBalance / 1000000L;
        long totalNetLimit = this.dbManager.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.dbManager.getDynamicPropertiesStore().getTotalNetWeight();
        if (totalNetWeight == 0L) {
            return 0L;
        }
        return (long)((double)netWeight * ((double)totalNetLimit / (double)totalNetWeight));
    }

    private boolean useAccountNet(AccountCapsule accountCapsule, long bytes, long now) {
        long newNetUsage;
        long netUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        long netLimit = this.calculateGlobalNetLimit(accountCapsule);
        if (bytes > netLimit - (newNetUsage = this.increase(netUsage, 0L, latestConsumeTime, now))) {
            logger.debug("net usage is running out. now use free net usage");
            return false;
        }
        latestConsumeTime = now;
        long latestOperationTime = this.dbManager.getHeadBlockTimeStamp();
        newNetUsage = this.increase(newNetUsage, bytes, latestConsumeTime, now);
        accountCapsule.setNetUsage(newNetUsage);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        accountCapsule.setLatestConsumeTime(latestConsumeTime);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        return true;
    }

    private boolean useFreeNet(AccountCapsule accountCapsule, long bytes, long now) {
        long publicNetTime;
        long publicNetUsage;
        long newPublicNetUsage;
        long latestConsumeFreeTime;
        long freeNetUsage;
        long newFreeNetUsage;
        long freeNetLimit = this.dbManager.getDynamicPropertiesStore().getFreeNetLimit();
        if (bytes > freeNetLimit - (newFreeNetUsage = this.increase(freeNetUsage = accountCapsule.getFreeNetUsage(), 0L, latestConsumeFreeTime = accountCapsule.getLatestConsumeFreeTime(), now))) {
            logger.debug("free net usage is running out");
            return false;
        }
        long publicNetLimit = this.dbManager.getDynamicPropertiesStore().getPublicNetLimit();
        if (bytes > publicNetLimit - (newPublicNetUsage = this.increase(publicNetUsage = this.dbManager.getDynamicPropertiesStore().getPublicNetUsage(), 0L, publicNetTime = this.dbManager.getDynamicPropertiesStore().getPublicNetTime(), now))) {
            logger.debug("free public net usage is running out");
            return false;
        }
        latestConsumeFreeTime = now;
        long latestOperationTime = this.dbManager.getHeadBlockTimeStamp();
        publicNetTime = now;
        newFreeNetUsage = this.increase(newFreeNetUsage, bytes, latestConsumeFreeTime, now);
        newPublicNetUsage = this.increase(newPublicNetUsage, bytes, publicNetTime, now);
        accountCapsule.setFreeNetUsage(newFreeNetUsage);
        accountCapsule.setLatestConsumeFreeTime(latestConsumeFreeTime);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        this.dbManager.getDynamicPropertiesStore().savePublicNetUsage(newPublicNetUsage);
        this.dbManager.getDynamicPropertiesStore().savePublicNetTime(publicNetTime);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        return true;
    }
}

