/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.springframework.stereotype.Component;
import org.tron.common.crypto.ECKey;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.config.Configuration;
import org.tron.core.config.args.Account;
import org.tron.core.config.args.GenesisBlock;
import org.tron.core.config.args.LocalWitnesses;
import org.tron.core.config.args.Overlay;
import org.tron.core.config.args.SeedNode;
import org.tron.core.config.args.Storage;
import org.tron.core.config.args.Witness;
import org.tron.core.db.AccountStore;
import org.tron.keystore.CipherException;
import org.tron.keystore.Credentials;
import org.tron.keystore.WalletUtils;
import org.tron.program.Version;

@Component
public class Args {
    private static final Logger logger = LoggerFactory.getLogger(Args.class);
    private static final Args INSTANCE = new Args();
    @Parameter(names={"-c", "--config"}, description="Config File")
    private String shellConfFileName = "";
    @Parameter(names={"-d", "--output-directory"}, description="Directory")
    private String outputDirectory = "output-directory";
    @Parameter(names={"-h", "--help"}, help=true, description="HELP message")
    private boolean help = false;
    @Parameter(names={"-w", "--witness"})
    private boolean witness = false;
    @Parameter(names={"--support-constant"})
    private boolean supportConstant = false;
    @Parameter(names={"--debug"})
    private boolean debug = false;
    @Parameter(names={"--min-time-ratio"})
    private double minTimeRatio = 0.0;
    @Parameter(names={"--max-time-ratio"})
    private double maxTimeRatio = Args.calcMaxTimeRatio();
    @Parameter(names={"--long-running-time"})
    private int longRunningTime = 10;
    @Parameter(description="--seed-nodes")
    private List<String> seedNodes = new ArrayList<String>();
    @Parameter(names={"-p", "--private-key"}, description="private-key")
    private String privateKey = "";
    @Parameter(names={"--password"}, description="password")
    private String password;
    @Parameter(names={"--storage-db-directory"}, description="Storage db directory")
    private String storageDbDirectory = "";
    @Parameter(names={"--storage-db-version"}, description="Storage db version.(1 or 2)")
    private String storageDbVersion = "";
    @Parameter(names={"--storage-index-directory"}, description="Storage index directory")
    private String storageIndexDirectory = "";
    @Parameter(names={"--storage-index-switch"}, description="Storage index switch.(on or off)")
    private String storageIndexSwitch = "";
    private Storage storage;
    private Overlay overlay;
    private SeedNode seedNode;
    private GenesisBlock genesisBlock;
    private String chainId;
    private LocalWitnesses localWitnesses = new LocalWitnesses();
    private boolean needSyncCheck;
    private boolean nodeDiscoveryEnable;
    private boolean nodeDiscoveryPersist;
    private int nodeConnectionTimeout;
    private List<Node> activeNodes;
    private List<Node> passiveNodes;
    private int nodeChannelReadTimeout;
    private int nodeMaxActiveNodes;
    private int nodeMaxActiveNodesWithSameIp;
    private int minParticipationRate;
    private int nodeListenPort;
    private String nodeDiscoveryBindIp;
    private String nodeExternalIp;
    private boolean nodeDiscoveryPublicHomeNode;
    private long nodeP2pPingInterval;
    private int nodeP2pVersion;
    private String p2pNodeId;
    private boolean solidityNode = false;
    private int rpcPort;
    private int rpcOnSolidityPort;
    private int fullNodeHttpPort;
    private int solidityHttpPort;
    @Parameter(names={"--rpc-thread"}, description="Num of gRPC thread")
    private int rpcThreadNum;
    private int maxConcurrentCallsPerConnection;
    private int flowControlWindow;
    private long maxConnectionIdleInMillis;
    private int blockProducedTimeOut;
    private long netMaxTrxPerSecond;
    private long maxConnectionAgeInMillis;
    private int maxMessageSize;
    private int maxHeaderListSize;
    @Parameter(names={"--validate-sign-thread"}, description="Num of validate thread")
    private int validateSignThreadNum;
    private long maintenanceTimeInterval;
    private long proposalExpireTime;
    private int checkFrozenTime;
    private long allowCreationOfContracts;
    private long allowAdaptiveEnergy;
    private long allowDelegateResource;
    private long allowSameTokenName;
    private long allowTvmTransferTrc10;
    private int tcpNettyWorkThreadNum;
    private int udpNettyWorkThreadNum;
    @Parameter(names={"--trust-node"}, description="Trust node addr")
    private String trustNodeAddr;
    private boolean walletExtensionApi;
    private int backupPriority;
    private int backupPort;
    private List<String> backupMembers;
    private double connectFactor;
    private double activeConnectFactor;
    private double disconnectNumberFactor;
    private double maxConnectNumberFactor;
    private long receiveTcpMinDataLength;
    private boolean isOpenFullTcpDisconnect;
    private String logLevel;
    private boolean vmTrace;
    private boolean needToUpdateAsset;
    private String trxReferenceBlock;

    public static void clearParam() {
        Args.INSTANCE.outputDirectory = "output-directory";
        Args.INSTANCE.help = false;
        Args.INSTANCE.witness = false;
        Args.INSTANCE.seedNodes = new ArrayList<String>();
        Args.INSTANCE.privateKey = "";
        Args.INSTANCE.storageDbDirectory = "";
        Args.INSTANCE.storageIndexDirectory = "";
        Args.INSTANCE.storageIndexSwitch = "";
        if (Args.INSTANCE.storage != null) {
            Args.INSTANCE.storage.deleteAllStoragePaths();
            Args.INSTANCE.storage = null;
        }
        Args.INSTANCE.overlay = null;
        Args.INSTANCE.seedNode = null;
        Args.INSTANCE.genesisBlock = null;
        Args.INSTANCE.chainId = null;
        Args.INSTANCE.localWitnesses = null;
        Args.INSTANCE.needSyncCheck = false;
        Args.INSTANCE.nodeDiscoveryEnable = false;
        Args.INSTANCE.nodeDiscoveryPersist = false;
        Args.INSTANCE.nodeConnectionTimeout = 0;
        Args.INSTANCE.activeNodes = Collections.emptyList();
        Args.INSTANCE.passiveNodes = Collections.emptyList();
        Args.INSTANCE.nodeChannelReadTimeout = 0;
        Args.INSTANCE.nodeMaxActiveNodes = 30;
        Args.INSTANCE.nodeMaxActiveNodesWithSameIp = 2;
        Args.INSTANCE.minParticipationRate = 0;
        Args.INSTANCE.nodeListenPort = 0;
        Args.INSTANCE.nodeDiscoveryBindIp = "";
        Args.INSTANCE.nodeExternalIp = "";
        Args.INSTANCE.nodeDiscoveryPublicHomeNode = false;
        Args.INSTANCE.nodeP2pPingInterval = 0L;
        Args.INSTANCE.nodeP2pVersion = 0;
        Args.INSTANCE.rpcPort = 0;
        Args.INSTANCE.rpcOnSolidityPort = 0;
        Args.INSTANCE.fullNodeHttpPort = 0;
        Args.INSTANCE.solidityHttpPort = 0;
        Args.INSTANCE.maintenanceTimeInterval = 0L;
        Args.INSTANCE.proposalExpireTime = 0L;
        Args.INSTANCE.checkFrozenTime = 1;
        Args.INSTANCE.allowCreationOfContracts = 0L;
        Args.INSTANCE.allowAdaptiveEnergy = 0L;
        Args.INSTANCE.allowTvmTransferTrc10 = 0L;
        Args.INSTANCE.allowDelegateResource = 0L;
        Args.INSTANCE.allowSameTokenName = 0L;
        Args.INSTANCE.tcpNettyWorkThreadNum = 0;
        Args.INSTANCE.udpNettyWorkThreadNum = 0;
        Args.INSTANCE.p2pNodeId = "";
        Args.INSTANCE.solidityNode = false;
        Args.INSTANCE.trustNodeAddr = "";
        Args.INSTANCE.walletExtensionApi = false;
        Args.INSTANCE.connectFactor = 0.3;
        Args.INSTANCE.activeConnectFactor = 0.1;
        Args.INSTANCE.disconnectNumberFactor = 0.4;
        Args.INSTANCE.maxConnectNumberFactor = 0.8;
        Args.INSTANCE.receiveTcpMinDataLength = 2048L;
        Args.INSTANCE.isOpenFullTcpDisconnect = false;
        Args.INSTANCE.supportConstant = false;
        Args.INSTANCE.debug = false;
        Args.INSTANCE.minTimeRatio = 0.0;
        Args.INSTANCE.maxTimeRatio = 5.0;
        Args.INSTANCE.longRunningTime = 10;
    }

    public static void setParam(String[] args, String confFileName) {
        JCommander.newBuilder().addObject((Object)INSTANCE).build().parse(args);
        Config config = Configuration.getByFileName(Args.INSTANCE.shellConfFileName, confFileName);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Args.INSTANCE.privateKey})) {
            INSTANCE.setLocalWitnesses(new LocalWitnesses(Args.INSTANCE.privateKey));
            logger.debug("Got privateKey from cmd");
        } else if (config.hasPath("localwitness")) {
            Args.INSTANCE.localWitnesses = new LocalWitnesses();
            List localwitness = config.getStringList("localwitness");
            if (localwitness.size() > 1) {
                logger.warn("localwitness size must be one, get the first one");
                localwitness = localwitness.subList(0, 1);
            }
            Args.INSTANCE.localWitnesses.setPrivateKeys(localwitness);
            logger.debug("Got privateKey from config.conf");
        } else if (config.hasPath("localwitnesskeystore")) {
            List localwitness;
            Args.INSTANCE.localWitnesses = new LocalWitnesses();
            ArrayList<String> privateKeys = new ArrayList<String>();
            if (INSTANCE.isWitness() && (localwitness = config.getStringList("localwitnesskeystore")).size() > 0) {
                String password;
                String fileName = System.getProperty("user.dir") + "/" + (String)localwitness.get(0);
                if (StringUtils.isEmpty((CharSequence)Args.INSTANCE.password)) {
                    System.out.println("Please input your password.");
                    password = WalletUtils.inputPassword();
                } else {
                    password = Args.INSTANCE.password;
                    Args.INSTANCE.password = null;
                }
                try {
                    Credentials credentials = WalletUtils.loadCredentials(password, new File(fileName));
                    ECKey ecKeyPair = credentials.getEcKeyPair();
                    String prikey = ByteArray.toHexString(ecKeyPair.getPrivKeyBytes());
                    privateKeys.add(prikey);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    logger.error("Witness node start faild!");
                    System.exit(-1);
                }
                catch (CipherException e) {
                    logger.error(e.getMessage());
                    logger.error("Witness node start faild!");
                    System.exit(-1);
                }
            }
            Args.INSTANCE.localWitnesses.setPrivateKeys(privateKeys);
            logger.debug("Got privateKey from keystore");
        }
        if (INSTANCE.isWitness() && CollectionUtils.isEmpty(Args.INSTANCE.localWitnesses.getPrivateKeys())) {
            logger.warn("This is a witness node,but localWitnesses is null");
        }
        if (config.hasPath("vm.supportConstant")) {
            Args.INSTANCE.supportConstant = config.getBoolean("vm.supportConstant");
        }
        if (config.hasPath("vm.minTimeRatio")) {
            Args.INSTANCE.minTimeRatio = config.getDouble("vm.minTimeRatio");
        }
        if (config.hasPath("vm.maxTimeRatio")) {
            Args.INSTANCE.maxTimeRatio = config.getDouble("vm.maxTimeRatio");
        }
        if (config.hasPath("vm.longRunningTime")) {
            Args.INSTANCE.longRunningTime = config.getInt("vm.longRunningTime");
        }
        Args.INSTANCE.storage = new Storage();
        Args.INSTANCE.storage.setDbVersion(Optional.ofNullable(Args.INSTANCE.storageDbVersion).filter(StringUtils::isNotEmpty).map(Integer::valueOf).orElse(Storage.getDbVersionFromConfig(config)));
        Args.INSTANCE.storage.setDbDirectory(Optional.ofNullable(Args.INSTANCE.storageDbDirectory).filter(StringUtils::isNotEmpty).orElse(Storage.getDbDirectoryFromConfig(config)));
        Args.INSTANCE.storage.setIndexDirectory(Optional.ofNullable(Args.INSTANCE.storageIndexDirectory).filter(StringUtils::isNotEmpty).orElse(Storage.getIndexDirectoryFromConfig(config)));
        Args.INSTANCE.storage.setIndexSwitch(Optional.ofNullable(Args.INSTANCE.storageIndexSwitch).filter(StringUtils::isNotEmpty).orElse(Storage.getIndexSwitchFromConfig(config)));
        Args.INSTANCE.storage.setPropertyMapFromConfig(config);
        Args.INSTANCE.seedNode = new SeedNode();
        Args.INSTANCE.seedNode.setIpList(Optional.ofNullable(Args.INSTANCE.seedNodes).filter(seedNode -> 0 != seedNode.size()).orElse(config.getStringList("seed.node.ip.list")));
        if (config.hasPath("net.type") && "mainnet".equalsIgnoreCase(config.getString("net.type"))) {
            Wallet.setAddressPreFixByte((byte)65);
            Wallet.setAddressPreFixString("41");
        } else {
            Wallet.setAddressPreFixByte((byte)-96);
            Wallet.setAddressPreFixString("a0");
        }
        if (config.hasPath("genesis.block")) {
            Args.INSTANCE.genesisBlock = new GenesisBlock();
            Args.INSTANCE.genesisBlock.setTimestamp(config.getString("genesis.block.timestamp"));
            Args.INSTANCE.genesisBlock.setParentHash(config.getString("genesis.block.parentHash"));
            if (config.hasPath("genesis.block.assets")) {
                Args.INSTANCE.genesisBlock.setAssets(Args.getAccountsFromConfig(config));
                AccountStore.setAccount(config);
            }
            if (config.hasPath("genesis.block.witnesses")) {
                Args.INSTANCE.genesisBlock.setWitnesses(Args.getWitnessesFromConfig(config));
            }
        } else {
            Args.INSTANCE.genesisBlock = GenesisBlock.getDefault();
        }
        Args.INSTANCE.needSyncCheck = config.hasPath("block.needSyncCheck") && config.getBoolean("block.needSyncCheck");
        Args.INSTANCE.nodeDiscoveryEnable = config.hasPath("node.discovery.enable") && config.getBoolean("node.discovery.enable");
        Args.INSTANCE.nodeDiscoveryPersist = config.hasPath("node.discovery.persist") && config.getBoolean("node.discovery.persist");
        Args.INSTANCE.nodeConnectionTimeout = config.hasPath("node.connection.timeout") ? config.getInt("node.connection.timeout") * 1000 : 0;
        Args.INSTANCE.activeNodes = Args.getNodes(config, "node.active");
        Args.INSTANCE.passiveNodes = Args.getNodes(config, "node.passive");
        Args.INSTANCE.nodeChannelReadTimeout = config.hasPath("node.channel.read.timeout") ? config.getInt("node.channel.read.timeout") : 0;
        Args.INSTANCE.nodeMaxActiveNodes = config.hasPath("node.maxActiveNodes") ? config.getInt("node.maxActiveNodes") : 30;
        Args.INSTANCE.nodeMaxActiveNodesWithSameIp = config.hasPath("node.maxActiveNodesWithSameIp") ? config.getInt("node.maxActiveNodesWithSameIp") : 2;
        Args.INSTANCE.minParticipationRate = config.hasPath("node.minParticipationRate") ? config.getInt("node.minParticipationRate") : 0;
        Args.INSTANCE.nodeListenPort = config.hasPath("node.listen.port") ? config.getInt("node.listen.port") : 0;
        Args.bindIp(config);
        Args.externalIp(config);
        Args.INSTANCE.nodeDiscoveryPublicHomeNode = config.hasPath("node.discovery.public.home.node") && config.getBoolean("node.discovery.public.home.node");
        Args.INSTANCE.nodeP2pPingInterval = config.hasPath("node.p2p.pingInterval") ? config.getLong("node.p2p.pingInterval") : 0L;
        Args.INSTANCE.nodeP2pVersion = config.hasPath("node.p2p.version") ? config.getInt("node.p2p.version") : 0;
        Args.INSTANCE.rpcPort = config.hasPath("node.rpc.port") ? config.getInt("node.rpc.port") : 50051;
        Args.INSTANCE.rpcOnSolidityPort = config.hasPath("node.rpc.solidityPort") ? config.getInt("node.rpc.solidityPort") : 50061;
        Args.INSTANCE.fullNodeHttpPort = config.hasPath("node.http.fullNodePort") ? config.getInt("node.http.fullNodePort") : 8090;
        Args.INSTANCE.solidityHttpPort = config.hasPath("node.http.solidityPort") ? config.getInt("node.http.solidityPort") : 8091;
        Args.INSTANCE.rpcThreadNum = config.hasPath("node.rpc.thread") ? config.getInt("node.rpc.thread") : Runtime.getRuntime().availableProcessors() / 2;
        Args.INSTANCE.maxConcurrentCallsPerConnection = config.hasPath("node.rpc.maxConcurrentCallsPerConnection") ? config.getInt("node.rpc.maxConcurrentCallsPerConnection") : Integer.MAX_VALUE;
        Args.INSTANCE.flowControlWindow = config.hasPath("node.rpc.flowControlWindow") ? config.getInt("node.rpc.flowControlWindow") : 0x100000;
        Args.INSTANCE.maxConnectionIdleInMillis = config.hasPath("node.rpc.maxConnectionIdleInMillis") ? config.getLong("node.rpc.maxConnectionIdleInMillis") : Long.MAX_VALUE;
        Args.INSTANCE.blockProducedTimeOut = config.hasPath("node.blockProducedTimeOut") ? config.getInt("node.blockProducedTimeOut") : 75;
        Args.INSTANCE.netMaxTrxPerSecond = config.hasPath("node.netMaxTrxPerSecond") ? (long)config.getInt("node.netMaxTrxPerSecond") : 700L;
        Args.INSTANCE.maxConnectionAgeInMillis = config.hasPath("node.rpc.maxConnectionAgeInMillis") ? config.getLong("node.rpc.maxConnectionAgeInMillis") : Long.MAX_VALUE;
        Args.INSTANCE.maxMessageSize = config.hasPath("node.rpc.maxMessageSize") ? config.getInt("node.rpc.maxMessageSize") : 0x400000;
        Args.INSTANCE.maxHeaderListSize = config.hasPath("node.rpc.maxHeaderListSize") ? config.getInt("node.rpc.maxHeaderListSize") : 8192;
        Args.INSTANCE.maintenanceTimeInterval = config.hasPath("block.maintenanceTimeInterval") ? (long)config.getInt("block.maintenanceTimeInterval") : 21600000L;
        Args.INSTANCE.proposalExpireTime = config.hasPath("block.proposalExpireTime") ? (long)config.getInt("block.proposalExpireTime") : 259200000L;
        Args.INSTANCE.checkFrozenTime = config.hasPath("block.checkFrozenTime") ? config.getInt("block.checkFrozenTime") : 1;
        Args.INSTANCE.allowCreationOfContracts = config.hasPath("committee.allowCreationOfContracts") ? (long)config.getInt("committee.allowCreationOfContracts") : 0L;
        Args.INSTANCE.allowAdaptiveEnergy = config.hasPath("committee.allowAdaptiveEnergy") ? (long)config.getInt("committee.allowAdaptiveEnergy") : 0L;
        Args.INSTANCE.allowDelegateResource = config.hasPath("committee.allowDelegateResource") ? (long)config.getInt("committee.allowDelegateResource") : 0L;
        Args.INSTANCE.allowSameTokenName = config.hasPath("committee.allowSameTokenName") ? (long)config.getInt("committee.allowSameTokenName") : 0L;
        Args.INSTANCE.allowTvmTransferTrc10 = config.hasPath("committee.allowTvmTransferTrc10") ? (long)config.getInt("committee.allowTvmTransferTrc10") : 0L;
        Args.INSTANCE.tcpNettyWorkThreadNum = config.hasPath("node.tcpNettyWorkThreadNum") ? config.getInt("node.tcpNettyWorkThreadNum") : 0;
        int n = Args.INSTANCE.udpNettyWorkThreadNum = config.hasPath("node.udpNettyWorkThreadNum") ? config.getInt("node.udpNettyWorkThreadNum") : 1;
        if (StringUtils.isEmpty((CharSequence)Args.INSTANCE.trustNodeAddr)) {
            Args.INSTANCE.trustNodeAddr = config.hasPath("node.trustNode") ? config.getString("node.trustNode") : null;
        }
        Args.INSTANCE.validateSignThreadNum = config.hasPath("node.validateSignThreadNum") ? config.getInt("node.validateSignThreadNum") : Runtime.getRuntime().availableProcessors() / 2;
        Args.INSTANCE.walletExtensionApi = config.hasPath("node.walletExtensionApi") && config.getBoolean("node.walletExtensionApi");
        Args.INSTANCE.connectFactor = config.hasPath("node.connectFactor") ? config.getDouble("node.connectFactor") : 0.3;
        Args.INSTANCE.activeConnectFactor = config.hasPath("node.activeConnectFactor") ? config.getDouble("node.activeConnectFactor") : 0.1;
        Args.INSTANCE.disconnectNumberFactor = config.hasPath("node.disconnectNumberFactor") ? config.getDouble("node.disconnectNumberFactor") : 0.4;
        Args.INSTANCE.maxConnectNumberFactor = config.hasPath("node.maxConnectNumberFactor") ? config.getDouble("node.maxConnectNumberFactor") : 0.8;
        Args.INSTANCE.receiveTcpMinDataLength = config.hasPath("node.receiveTcpMinDataLength") ? config.getLong("node.receiveTcpMinDataLength") : 2048L;
        Args.INSTANCE.isOpenFullTcpDisconnect = config.hasPath("node.isOpenFullTcpDisconnect") && config.getBoolean("node.isOpenFullTcpDisconnect");
        Args.INSTANCE.logLevel = config.hasPath("log.level.root") ? config.getString("log.level.root") : "INFO";
        Args.INSTANCE.needToUpdateAsset = config.hasPath("storage.needToUpdateAsset") ? config.getBoolean("storage.needToUpdateAsset") : true;
        Args.INSTANCE.trxReferenceBlock = config.hasPath("trx.reference.block") ? config.getString("trx.reference.block") : "head";
        Args.INSTANCE.vmTrace = config.hasPath("vm.vmTrace") ? config.getBoolean("vm.vmTrace") : false;
        Args.initBackupProperty(config);
        Args.logConfig();
    }

    private static List<Witness> getWitnessesFromConfig(Config config) {
        return config.getObjectList("genesis.block.witnesses").stream().map(Args::createWitness).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Witness createWitness(ConfigObject witnessAccount) {
        Witness witness = new Witness();
        witness.setAddress(Wallet.decodeFromBase58Check(witnessAccount.get((Object)"address").unwrapped().toString()));
        witness.setUrl(witnessAccount.get((Object)"url").unwrapped().toString());
        witness.setVoteCount(witnessAccount.toConfig().getLong("voteCount"));
        return witness;
    }

    private static List<Account> getAccountsFromConfig(Config config) {
        return config.getObjectList("genesis.block.assets").stream().map(Args::createAccount).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Account createAccount(ConfigObject asset) {
        Account account = new Account();
        account.setAccountName(asset.get((Object)"accountName").unwrapped().toString());
        account.setAccountType(asset.get((Object)"accountType").unwrapped().toString());
        account.setAddress(Wallet.decodeFromBase58Check(asset.get((Object)"address").unwrapped().toString()));
        account.setBalance(asset.get((Object)"balance").unwrapped().toString());
        return account;
    }

    public static Args getInstance() {
        return INSTANCE;
    }

    public String getOutputDirectoryByDbName(String dbName) {
        String path = this.storage.getPathByDbName(dbName);
        if (!StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        return this.getOutputDirectory();
    }

    public String getOutputDirectory() {
        if (!this.outputDirectory.equals("") && !this.outputDirectory.endsWith(File.separator)) {
            return this.outputDirectory + File.separator;
        }
        return this.outputDirectory;
    }

    private static List<Node> getNodes(Config config, String path) {
        if (!config.hasPath(path)) {
            return Collections.emptyList();
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        List list = config.getStringList(path);
        for (String configString : list) {
            Node n = Node.instanceOf(configString);
            ret.add(n);
        }
        return ret;
    }

    private static void privateKey(Config config) {
        if (config.hasPath("private.key")) {
            Args.INSTANCE.privateKey = config.getString("private.key");
            if (Args.INSTANCE.privateKey.length() != 64) {
                throw new RuntimeException("The peer.privateKey needs to be Hex encoded and 32 byte length");
            }
        } else {
            Args.INSTANCE.privateKey = Args.getGeneratedNodePrivateKey();
        }
    }

    private static String getGeneratedNodePrivateKey() {
        String nodeId;
        try {
            File file = new File(Args.INSTANCE.outputDirectory + File.separator + Args.INSTANCE.storage.getDbDirectory(), "nodeId.properties");
            Properties props = new Properties();
            if (file.canRead()) {
                try (FileReader r = new FileReader(file);){
                    props.load(r);
                }
            }
            ECKey key = new ECKey();
            props.setProperty("nodeIdPrivateKey", Hex.toHexString((byte[])key.getPrivKeyBytes()));
            props.setProperty("nodeId", Hex.toHexString((byte[])key.getNodeId()));
            file.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(file);){
                props.store(w, "Generated NodeID. To use your own nodeId please refer to 'peer.privateKey' config option.");
            }
            logger.info("New nodeID generated: " + props.getProperty("nodeId"));
            logger.info("Generated nodeID and its private key stored in " + file);
            nodeId = props.getProperty("nodeIdPrivateKey");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return nodeId;
    }

    private static void bindIp(Config config) {
        if (!config.hasPath("node.discovery.bind.ip") || config.getString("node.discovery.bind.ip").trim().isEmpty()) {
            if (Args.INSTANCE.nodeDiscoveryBindIp == null) {
                logger.info("Bind address wasn't set, Punching to identify it...");
                try (Socket s = new Socket("www.baidu.com", 80);){
                    Args.INSTANCE.nodeDiscoveryBindIp = s.getLocalAddress().getHostAddress();
                    logger.info("UDP local bound to: {}", (Object)Args.INSTANCE.nodeDiscoveryBindIp);
                }
                catch (IOException e) {
                    logger.warn("Can't get bind IP. Fall back to 0.0.0.0: " + e);
                    Args.INSTANCE.nodeDiscoveryBindIp = "0.0.0.0";
                }
            }
        } else {
            Args.INSTANCE.nodeDiscoveryBindIp = config.getString("node.discovery.bind.ip").trim();
        }
    }

    private static void externalIp(Config config) {
        if (!config.hasPath("node.discovery.external.ip") || config.getString("node.discovery.external.ip").trim().isEmpty()) {
            if (Args.INSTANCE.nodeExternalIp == null) {
                logger.info("External IP wasn't set, using checkip.amazonaws.com to identify it...");
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(new URL("http://checkip.amazonaws.com").openStream()));
                    Args.INSTANCE.nodeExternalIp = in.readLine();
                    if (Args.INSTANCE.nodeExternalIp == null || Args.INSTANCE.nodeExternalIp.trim().isEmpty()) {
                        throw new IOException("Invalid address: '" + Args.INSTANCE.nodeExternalIp + "'");
                    }
                    try {
                        InetAddress.getByName(Args.INSTANCE.nodeExternalIp);
                    }
                    catch (Exception e) {
                        throw new IOException("Invalid address: '" + Args.INSTANCE.nodeExternalIp + "'");
                    }
                    logger.info("External address identified: {}", (Object)Args.INSTANCE.nodeExternalIp);
                }
                catch (IOException e) {
                    Args.INSTANCE.nodeExternalIp = Args.INSTANCE.nodeDiscoveryBindIp;
                    logger.warn("Can't get external IP. Fall back to peer.bind.ip: " + Args.INSTANCE.nodeExternalIp + " :" + e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            Args.INSTANCE.nodeExternalIp = config.getString("node.discovery.external.ip").trim();
        }
    }

    public ECKey getMyKey() {
        if (StringUtils.isEmpty((CharSequence)Args.INSTANCE.p2pNodeId)) {
            Args.INSTANCE.p2pNodeId = Args.getGeneratedNodePrivateKey();
        }
        return ECKey.fromPrivate(Hex.decode((String)Args.INSTANCE.p2pNodeId));
    }

    private static double calcMaxTimeRatio() {
        return 5.0;
    }

    private static void initBackupProperty(Config config) {
        Args.INSTANCE.backupPriority = config.hasPath("node.backup.priority") ? config.getInt("node.backup.priority") : 0;
        Args.INSTANCE.backupPort = config.hasPath("node.backup.port") ? config.getInt("node.backup.port") : 10001;
        Args.INSTANCE.backupMembers = config.hasPath("node.backup.members") ? config.getStringList("node.backup.members") : new ArrayList();
    }

    private static void logConfig() {
        Args args = Args.getInstance();
        logger.info("\n");
        logger.info("************************ Net config ************************");
        logger.info("P2P version: {}", (Object)args.getNodeP2pVersion());
        logger.info("Bind IP: {}", (Object)args.getNodeDiscoveryBindIp());
        logger.info("External IP: {}", (Object)args.getNodeExternalIp());
        logger.info("Listen port: {}", (Object)args.getNodeListenPort());
        logger.info("Discover enable: {}", (Object)args.isNodeDiscoveryEnable());
        logger.info("Active node size: {}", (Object)args.getActiveNodes().size());
        logger.info("Passive node size: {}", (Object)args.getPassiveNodes().size());
        logger.info("Seed node size: {}", (Object)args.getSeedNode().getIpList().size());
        logger.info("Max connection: {}", (Object)args.getNodeMaxActiveNodes());
        logger.info("Max connection with same IP: {}", (Object)args.getNodeMaxActiveNodesWithSameIp());
        logger.info("************************ Backup config ************************");
        logger.info("Backup listen port: {}", (Object)args.getBackupPort());
        logger.info("Backup member size: {}", (Object)args.getBackupMembers().size());
        logger.info("Backup priority: {}", (Object)args.getBackupPriority());
        logger.info("************************ Code version *************************");
        logger.info("Code version : {}", (Object)Version.getVersion());
        logger.info("************************ DB config *************************");
        logger.info("DB version : {}", (Object)args.getStorage().getDbVersion());
        logger.info("***************************************************************");
        logger.info("\n");
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isWitness() {
        return this.witness;
    }

    public void setWitness(boolean witness) {
        this.witness = witness;
    }

    public boolean isSupportConstant() {
        return this.supportConstant;
    }

    public void setSupportConstant(boolean supportConstant) {
        this.supportConstant = supportConstant;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public double getMinTimeRatio() {
        return this.minTimeRatio;
    }

    public void setMinTimeRatio(double minTimeRatio) {
        this.minTimeRatio = minTimeRatio;
    }

    public double getMaxTimeRatio() {
        return this.maxTimeRatio;
    }

    public void setMaxTimeRatio(double maxTimeRatio) {
        this.maxTimeRatio = maxTimeRatio;
    }

    public int getLongRunningTime() {
        return this.longRunningTime;
    }

    public void setLongRunningTime(int longRunningTime) {
        this.longRunningTime = longRunningTime;
    }

    public List<String> getSeedNodes() {
        return this.seedNodes;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public SeedNode getSeedNode() {
        return this.seedNode;
    }

    public GenesisBlock getGenesisBlock() {
        return this.genesisBlock;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public LocalWitnesses getLocalWitnesses() {
        return this.localWitnesses;
    }

    public void setLocalWitnesses(LocalWitnesses localWitnesses) {
        this.localWitnesses = localWitnesses;
    }

    public boolean isNeedSyncCheck() {
        return this.needSyncCheck;
    }

    public void setNeedSyncCheck(boolean needSyncCheck) {
        this.needSyncCheck = needSyncCheck;
    }

    public boolean isNodeDiscoveryEnable() {
        return this.nodeDiscoveryEnable;
    }

    public void setNodeDiscoveryEnable(boolean nodeDiscoveryEnable) {
        this.nodeDiscoveryEnable = nodeDiscoveryEnable;
    }

    public boolean isNodeDiscoveryPersist() {
        return this.nodeDiscoveryPersist;
    }

    public void setNodeDiscoveryPersist(boolean nodeDiscoveryPersist) {
        this.nodeDiscoveryPersist = nodeDiscoveryPersist;
    }

    public int getNodeConnectionTimeout() {
        return this.nodeConnectionTimeout;
    }

    public void setNodeConnectionTimeout(int nodeConnectionTimeout) {
        this.nodeConnectionTimeout = nodeConnectionTimeout;
    }

    public List<Node> getActiveNodes() {
        return this.activeNodes;
    }

    public void setActiveNodes(List<Node> activeNodes) {
        this.activeNodes = activeNodes;
    }

    public List<Node> getPassiveNodes() {
        return this.passiveNodes;
    }

    public void setPassiveNodes(List<Node> passiveNodes) {
        this.passiveNodes = passiveNodes;
    }

    public int getNodeChannelReadTimeout() {
        return this.nodeChannelReadTimeout;
    }

    public void setNodeChannelReadTimeout(int nodeChannelReadTimeout) {
        this.nodeChannelReadTimeout = nodeChannelReadTimeout;
    }

    public int getNodeMaxActiveNodes() {
        return this.nodeMaxActiveNodes;
    }

    public void setNodeMaxActiveNodes(int nodeMaxActiveNodes) {
        this.nodeMaxActiveNodes = nodeMaxActiveNodes;
    }

    public int getNodeMaxActiveNodesWithSameIp() {
        return this.nodeMaxActiveNodesWithSameIp;
    }

    public void setNodeMaxActiveNodesWithSameIp(int nodeMaxActiveNodesWithSameIp) {
        this.nodeMaxActiveNodesWithSameIp = nodeMaxActiveNodesWithSameIp;
    }

    public int getMinParticipationRate() {
        return this.minParticipationRate;
    }

    public void setMinParticipationRate(int minParticipationRate) {
        this.minParticipationRate = minParticipationRate;
    }

    public int getNodeListenPort() {
        return this.nodeListenPort;
    }

    public void setNodeListenPort(int nodeListenPort) {
        this.nodeListenPort = nodeListenPort;
    }

    public String getNodeDiscoveryBindIp() {
        return this.nodeDiscoveryBindIp;
    }

    public void setNodeDiscoveryBindIp(String nodeDiscoveryBindIp) {
        this.nodeDiscoveryBindIp = nodeDiscoveryBindIp;
    }

    public String getNodeExternalIp() {
        return this.nodeExternalIp;
    }

    public void setNodeExternalIp(String nodeExternalIp) {
        this.nodeExternalIp = nodeExternalIp;
    }

    public boolean isNodeDiscoveryPublicHomeNode() {
        return this.nodeDiscoveryPublicHomeNode;
    }

    public void setNodeDiscoveryPublicHomeNode(boolean nodeDiscoveryPublicHomeNode) {
        this.nodeDiscoveryPublicHomeNode = nodeDiscoveryPublicHomeNode;
    }

    public long getNodeP2pPingInterval() {
        return this.nodeP2pPingInterval;
    }

    public void setNodeP2pPingInterval(long nodeP2pPingInterval) {
        this.nodeP2pPingInterval = nodeP2pPingInterval;
    }

    public int getNodeP2pVersion() {
        return this.nodeP2pVersion;
    }

    public void setNodeP2pVersion(int nodeP2pVersion) {
        this.nodeP2pVersion = nodeP2pVersion;
    }

    public String getP2pNodeId() {
        return this.p2pNodeId;
    }

    public void setP2pNodeId(String p2pNodeId) {
        this.p2pNodeId = p2pNodeId;
    }

    public boolean isSolidityNode() {
        return this.solidityNode;
    }

    public void setSolidityNode(boolean solidityNode) {
        this.solidityNode = solidityNode;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getRpcOnSolidityPort() {
        return this.rpcOnSolidityPort;
    }

    public void setRpcOnSolidityPort(int rpcOnSolidityPort) {
        this.rpcOnSolidityPort = rpcOnSolidityPort;
    }

    public int getFullNodeHttpPort() {
        return this.fullNodeHttpPort;
    }

    public void setFullNodeHttpPort(int fullNodeHttpPort) {
        this.fullNodeHttpPort = fullNodeHttpPort;
    }

    public int getSolidityHttpPort() {
        return this.solidityHttpPort;
    }

    public void setSolidityHttpPort(int solidityHttpPort) {
        this.solidityHttpPort = solidityHttpPort;
    }

    public int getRpcThreadNum() {
        return this.rpcThreadNum;
    }

    public void setRpcThreadNum(int rpcThreadNum) {
        this.rpcThreadNum = rpcThreadNum;
    }

    public int getMaxConcurrentCallsPerConnection() {
        return this.maxConcurrentCallsPerConnection;
    }

    public void setMaxConcurrentCallsPerConnection(int maxConcurrentCallsPerConnection) {
        this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public void setFlowControlWindow(int flowControlWindow) {
        this.flowControlWindow = flowControlWindow;
    }

    public long getMaxConnectionIdleInMillis() {
        return this.maxConnectionIdleInMillis;
    }

    public void setMaxConnectionIdleInMillis(long maxConnectionIdleInMillis) {
        this.maxConnectionIdleInMillis = maxConnectionIdleInMillis;
    }

    public int getBlockProducedTimeOut() {
        return this.blockProducedTimeOut;
    }

    public void setBlockProducedTimeOut(int blockProducedTimeOut) {
        this.blockProducedTimeOut = blockProducedTimeOut;
    }

    public long getNetMaxTrxPerSecond() {
        return this.netMaxTrxPerSecond;
    }

    public void setNetMaxTrxPerSecond(long netMaxTrxPerSecond) {
        this.netMaxTrxPerSecond = netMaxTrxPerSecond;
    }

    public long getMaxConnectionAgeInMillis() {
        return this.maxConnectionAgeInMillis;
    }

    public void setMaxConnectionAgeInMillis(long maxConnectionAgeInMillis) {
        this.maxConnectionAgeInMillis = maxConnectionAgeInMillis;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public int getValidateSignThreadNum() {
        return this.validateSignThreadNum;
    }

    public void setValidateSignThreadNum(int validateSignThreadNum) {
        this.validateSignThreadNum = validateSignThreadNum;
    }

    public long getMaintenanceTimeInterval() {
        return this.maintenanceTimeInterval;
    }

    public void setMaintenanceTimeInterval(long maintenanceTimeInterval) {
        this.maintenanceTimeInterval = maintenanceTimeInterval;
    }

    public long getProposalExpireTime() {
        return this.proposalExpireTime;
    }

    public void setProposalExpireTime(long proposalExpireTime) {
        this.proposalExpireTime = proposalExpireTime;
    }

    public int getCheckFrozenTime() {
        return this.checkFrozenTime;
    }

    public void setCheckFrozenTime(int checkFrozenTime) {
        this.checkFrozenTime = checkFrozenTime;
    }

    public long getAllowCreationOfContracts() {
        return this.allowCreationOfContracts;
    }

    public void setAllowCreationOfContracts(long allowCreationOfContracts) {
        this.allowCreationOfContracts = allowCreationOfContracts;
    }

    public long getAllowAdaptiveEnergy() {
        return this.allowAdaptiveEnergy;
    }

    public void setAllowAdaptiveEnergy(long allowAdaptiveEnergy) {
        this.allowAdaptiveEnergy = allowAdaptiveEnergy;
    }

    public long getAllowDelegateResource() {
        return this.allowDelegateResource;
    }

    public void setAllowDelegateResource(long allowDelegateResource) {
        this.allowDelegateResource = allowDelegateResource;
    }

    public long getAllowSameTokenName() {
        return this.allowSameTokenName;
    }

    public void setAllowSameTokenName(long allowSameTokenName) {
        this.allowSameTokenName = allowSameTokenName;
    }

    public long getAllowTvmTransferTrc10() {
        return this.allowTvmTransferTrc10;
    }

    public void setAllowTvmTransferTrc10(long allowTvmTransferTrc10) {
        this.allowTvmTransferTrc10 = allowTvmTransferTrc10;
    }

    public int getTcpNettyWorkThreadNum() {
        return this.tcpNettyWorkThreadNum;
    }

    public void setTcpNettyWorkThreadNum(int tcpNettyWorkThreadNum) {
        this.tcpNettyWorkThreadNum = tcpNettyWorkThreadNum;
    }

    public int getUdpNettyWorkThreadNum() {
        return this.udpNettyWorkThreadNum;
    }

    public void setUdpNettyWorkThreadNum(int udpNettyWorkThreadNum) {
        this.udpNettyWorkThreadNum = udpNettyWorkThreadNum;
    }

    public String getTrustNodeAddr() {
        return this.trustNodeAddr;
    }

    public void setTrustNodeAddr(String trustNodeAddr) {
        this.trustNodeAddr = trustNodeAddr;
    }

    public boolean isWalletExtensionApi() {
        return this.walletExtensionApi;
    }

    public void setWalletExtensionApi(boolean walletExtensionApi) {
        this.walletExtensionApi = walletExtensionApi;
    }

    public int getBackupPriority() {
        return this.backupPriority;
    }

    public void setBackupPriority(int backupPriority) {
        this.backupPriority = backupPriority;
    }

    public int getBackupPort() {
        return this.backupPort;
    }

    public void setBackupPort(int backupPort) {
        this.backupPort = backupPort;
    }

    public List<String> getBackupMembers() {
        return this.backupMembers;
    }

    public void setBackupMembers(List<String> backupMembers) {
        this.backupMembers = backupMembers;
    }

    public double getConnectFactor() {
        return this.connectFactor;
    }

    public void setConnectFactor(double connectFactor) {
        this.connectFactor = connectFactor;
    }

    public double getActiveConnectFactor() {
        return this.activeConnectFactor;
    }

    public void setActiveConnectFactor(double activeConnectFactor) {
        this.activeConnectFactor = activeConnectFactor;
    }

    public double getDisconnectNumberFactor() {
        return this.disconnectNumberFactor;
    }

    public void setDisconnectNumberFactor(double disconnectNumberFactor) {
        this.disconnectNumberFactor = disconnectNumberFactor;
    }

    public double getMaxConnectNumberFactor() {
        return this.maxConnectNumberFactor;
    }

    public void setMaxConnectNumberFactor(double maxConnectNumberFactor) {
        this.maxConnectNumberFactor = maxConnectNumberFactor;
    }

    public long getReceiveTcpMinDataLength() {
        return this.receiveTcpMinDataLength;
    }

    public void setReceiveTcpMinDataLength(long receiveTcpMinDataLength) {
        this.receiveTcpMinDataLength = receiveTcpMinDataLength;
    }

    public boolean isOpenFullTcpDisconnect() {
        return this.isOpenFullTcpDisconnect;
    }

    public void setOpenFullTcpDisconnect(boolean isOpenFullTcpDisconnect) {
        this.isOpenFullTcpDisconnect = isOpenFullTcpDisconnect;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isVmTrace() {
        return this.vmTrace;
    }

    public void setVmTrace(boolean vmTrace) {
        this.vmTrace = vmTrace;
    }

    public boolean isNeedToUpdateAsset() {
        return this.needToUpdateAsset;
    }

    public void setNeedToUpdateAsset(boolean needToUpdateAsset) {
        this.needToUpdateAsset = needToUpdateAsset;
    }

    public String getTrxReferenceBlock() {
        return this.trxReferenceBlock;
    }

    public void setTrxReferenceBlock(String trxReferenceBlock) {
        this.trxReferenceBlock = trxReferenceBlock;
    }
}

