/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;

public class WitnessCapsule
implements ProtoCapsule<Protocol.Witness>,
Comparable<WitnessCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(WitnessCapsule.class);
    private Protocol.Witness witness;

    @Override
    public int compareTo(WitnessCapsule otherObject) {
        return Long.compare(otherObject.getVoteCount(), this.getVoteCount());
    }

    public WitnessCapsule(ByteString pubKey, String url) {
        Protocol.Witness.Builder witnessBuilder = Protocol.Witness.newBuilder();
        this.witness = witnessBuilder.setPubKey(pubKey).setAddress(ByteString.copyFrom((byte[])ECKey.computeAddress(pubKey.toByteArray()))).setUrl(url).build();
    }

    public WitnessCapsule(Protocol.Witness witness) {
        this.witness = witness;
    }

    public WitnessCapsule(ByteString address) {
        this.witness = Protocol.Witness.newBuilder().setAddress(address).build();
    }

    public WitnessCapsule(ByteString address, long voteCount, String url) {
        Protocol.Witness.Builder witnessBuilder = Protocol.Witness.newBuilder();
        this.witness = witnessBuilder.setAddress(address).setVoteCount(voteCount).setUrl(url).build();
    }

    public WitnessCapsule(byte[] data) {
        try {
            this.witness = Protocol.Witness.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public ByteString getAddress() {
        return this.witness.getAddress();
    }

    public byte[] createDbKey() {
        return this.getAddress().toByteArray();
    }

    public String createReadableString() {
        return ByteArray.toHexString(this.getAddress().toByteArray());
    }

    @Override
    public byte[] getData() {
        return this.witness.toByteArray();
    }

    @Override
    public Protocol.Witness getInstance() {
        return this.witness;
    }

    public void setPubKey(ByteString pubKey) {
        this.witness = this.witness.toBuilder().setPubKey(pubKey).build();
    }

    public long getVoteCount() {
        return this.witness.getVoteCount();
    }

    public void setVoteCount(long voteCount) {
        this.witness = this.witness.toBuilder().setVoteCount(voteCount).build();
    }

    public void setTotalProduced(long totalProduced) {
        this.witness = this.witness.toBuilder().setTotalProduced(totalProduced).build();
    }

    public long getTotalProduced() {
        return this.witness.getTotalProduced();
    }

    public void setTotalMissed(long totalMissed) {
        this.witness = this.witness.toBuilder().setTotalMissed(totalMissed).build();
    }

    public long getTotalMissed() {
        return this.witness.getTotalMissed();
    }

    public void setLatestBlockNum(long latestBlockNum) {
        this.witness = this.witness.toBuilder().setLatestBlockNum(latestBlockNum).build();
    }

    public long getLatestBlockNum() {
        return this.witness.getLatestBlockNum();
    }

    public void setLatestSlotNum(long latestSlotNum) {
        this.witness = this.witness.toBuilder().setLatestSlotNum(latestSlotNum).build();
    }

    public long getLatestSlotNum() {
        return this.witness.getLatestSlotNum();
    }

    public void setIsJobs(boolean isJobs) {
        this.witness = this.witness.toBuilder().setIsJobs(isJobs).build();
    }

    public boolean getIsJobs() {
        return this.witness.getIsJobs();
    }

    public void setUrl(String url) {
        this.witness = this.witness.toBuilder().setUrl(url).build();
    }

    public String getUrl() {
        return this.witness.getUrl();
    }
}

