/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import org.tron.common.runtime.config.VMConfig;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.protos.Protocol;

public class ReceiptCapsule {
    private Protocol.ResourceReceipt receipt;
    private Sha256Hash receiptAddress;

    public ReceiptCapsule(Protocol.ResourceReceipt data, Sha256Hash receiptAddress) {
        this.receipt = data;
        this.receiptAddress = receiptAddress;
    }

    public ReceiptCapsule(Sha256Hash receiptAddress) {
        this.receipt = Protocol.ResourceReceipt.newBuilder().build();
        this.receiptAddress = receiptAddress;
    }

    public void setReceipt(Protocol.ResourceReceipt receipt) {
        this.receipt = receipt;
    }

    public Protocol.ResourceReceipt getReceipt() {
        return this.receipt;
    }

    public Sha256Hash getReceiptAddress() {
        return this.receiptAddress;
    }

    public void setNetUsage(long netUsage) {
        this.receipt = this.receipt.toBuilder().setNetUsage(netUsage).build();
    }

    public void setNetFee(long netFee) {
        this.receipt = this.receipt.toBuilder().setNetFee(netFee).build();
    }

    public long getEnergyUsage() {
        return this.receipt.getEnergyUsage();
    }

    public long getEnergyFee() {
        return this.receipt.getEnergyFee();
    }

    public void setEnergyUsage(long energyUsage) {
        this.receipt = this.receipt.toBuilder().setEnergyUsage(energyUsage).build();
    }

    public void setEnergyFee(long energyFee) {
        this.receipt = this.receipt.toBuilder().setEnergyFee(energyFee).build();
    }

    public long getOriginEnergyUsage() {
        return this.receipt.getOriginEnergyUsage();
    }

    public long getEnergyUsageTotal() {
        return this.receipt.getEnergyUsageTotal();
    }

    public void setOriginEnergyUsage(long energyUsage) {
        this.receipt = this.receipt.toBuilder().setOriginEnergyUsage(energyUsage).build();
    }

    public void setEnergyUsageTotal(long energyUsage) {
        this.receipt = this.receipt.toBuilder().setEnergyUsageTotal(energyUsage).build();
    }

    public long getNetUsage() {
        return this.receipt.getNetUsage();
    }

    public long getNetFee() {
        return this.receipt.getNetFee();
    }

    public void payEnergyBill(Manager manager, AccountCapsule origin, AccountCapsule caller, long percent, long originEnergyLimit, EnergyProcessor energyProcessor, long now) throws BalanceInsufficientException {
        if (this.receipt.getEnergyUsageTotal() <= 0L) {
            return;
        }
        if (caller.getAddress().equals((Object)origin.getAddress())) {
            this.payEnergyBill(manager, caller, this.receipt.getEnergyUsageTotal(), energyProcessor, now);
        } else {
            long originUsage = Math.multiplyExact(this.receipt.getEnergyUsageTotal(), percent) / 100L;
            originUsage = this.getOriginUsage(manager, origin, originEnergyLimit, energyProcessor, originUsage);
            long callerUsage = this.receipt.getEnergyUsageTotal() - originUsage;
            energyProcessor.useEnergy(origin, originUsage, now);
            this.setOriginEnergyUsage(originUsage);
            this.payEnergyBill(manager, caller, callerUsage, energyProcessor, now);
        }
    }

    private long getOriginUsage(Manager manager, AccountCapsule origin, long originEnergyLimit, EnergyProcessor energyProcessor, long originUsage) {
        if (VMConfig.getEnergyLimitHardFork()) {
            return Math.min(originUsage, Math.min(energyProcessor.getAccountLeftEnergyFromFreeze(origin), originEnergyLimit));
        }
        return Math.min(originUsage, energyProcessor.getAccountLeftEnergyFromFreeze(origin));
    }

    private void payEnergyBill(Manager manager, AccountCapsule account, long usage, EnergyProcessor energyProcessor, long now) throws BalanceInsufficientException {
        long accountEnergyLeft = energyProcessor.getAccountLeftEnergyFromFreeze(account);
        if (accountEnergyLeft >= usage) {
            energyProcessor.useEnergy(account, usage, now);
            this.setEnergyUsage(usage);
        } else {
            energyProcessor.useEnergy(account, accountEnergyLeft, now);
            long sunPerEnergy = 100L;
            long dynamicEnergyFee = manager.getDynamicPropertiesStore().getEnergyFee();
            if (dynamicEnergyFee > 0L) {
                sunPerEnergy = dynamicEnergyFee;
            }
            long energyFee = (usage - accountEnergyLeft) * sunPerEnergy;
            this.setEnergyUsage(accountEnergyLeft);
            this.setEnergyFee(energyFee);
            long balance = account.getBalance();
            if (balance < energyFee) {
                throw new BalanceInsufficientException(StringUtil.createReadableString(account.createDbKey()) + " insufficient balance");
            }
            account.setBalance(balance - energyFee);
            manager.adjustBalance(manager.getAccountStore().getBlackhole().getAddress().toByteArray(), energyFee);
        }
        manager.getAccountStore().put(account.getAddress().toByteArray(), account);
    }

    public static Protocol.ResourceReceipt copyReceipt(ReceiptCapsule origin) {
        return origin.getReceipt().toBuilder().build();
    }

    public void setResult(Protocol.Transaction.Result.contractResult success) {
        this.receipt = this.receipt.toBuilder().setResult(success).build();
    }

    public Protocol.Transaction.Result.contractResult getResult() {
        return this.receipt.getResult();
    }
}

