/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.db.Manager;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class AccountCapsule
implements ProtoCapsule<Protocol.Account>,
Comparable<AccountCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(AccountCapsule.class);
    private Protocol.Account account;

    @Override
    public int compareTo(AccountCapsule otherObject) {
        return Long.compare(otherObject.getBalance(), this.getBalance());
    }

    public AccountCapsule(byte[] data) {
        try {
            this.account = Protocol.Account.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage());
        }
    }

    public AccountCapsule(ByteString accountName, ByteString address, Protocol.AccountType accountType, long balance) {
        this.account = Protocol.Account.newBuilder().setAccountName(accountName).setType(accountType).setAddress(address).setBalance(balance).build();
    }

    public AccountCapsule(Contract.AccountCreateContract contract) {
        this.account = Protocol.Account.newBuilder().setType(contract.getType()).setAddress(contract.getAccountAddress()).setTypeValue(contract.getTypeValue()).build();
    }

    public AccountCapsule(Contract.AccountCreateContract contract, long createTime) {
        this.account = Protocol.Account.newBuilder().setType(contract.getType()).setAddress(contract.getAccountAddress()).setTypeValue(contract.getTypeValue()).setCreateTime(createTime).build();
    }

    public AccountCapsule(Contract.AccountUpdateContract contract) {
    }

    public AccountCapsule(ByteString address, ByteString accountName, Protocol.AccountType accountType) {
        this.account = Protocol.Account.newBuilder().setType(accountType).setAccountName(accountName).setAddress(address).build();
    }

    public AccountCapsule(ByteString address, Protocol.AccountType accountType) {
        this.account = Protocol.Account.newBuilder().setType(accountType).setAddress(address).build();
    }

    public AccountCapsule(ByteString address, Protocol.AccountType accountType, long createTime) {
        this.account = Protocol.Account.newBuilder().setType(accountType).setAddress(address).setCreateTime(createTime).build();
    }

    public AccountCapsule(Protocol.Account account) {
        this.account = account;
    }

    @Override
    public byte[] getData() {
        return this.account.toByteArray();
    }

    @Override
    public Protocol.Account getInstance() {
        return this.account;
    }

    public void setInstance(Protocol.Account account) {
        this.account = account;
    }

    public ByteString getAddress() {
        return this.account.getAddress();
    }

    public byte[] createDbKey() {
        return this.getAddress().toByteArray();
    }

    public String createReadableString() {
        return ByteArray.toHexString(this.getAddress().toByteArray());
    }

    public Protocol.AccountType getType() {
        return this.account.getType();
    }

    public ByteString getAccountName() {
        return this.account.getAccountName();
    }

    public ByteString getAccountId() {
        return this.account.getAccountId();
    }

    public long getBalance() {
        return this.account.getBalance();
    }

    public long getLatestOperationTime() {
        return this.account.getLatestOprationTime();
    }

    public void setLatestOperationTime(long latest_time) {
        this.account = this.account.toBuilder().setLatestOprationTime(latest_time).build();
    }

    public long getLatestConsumeTime() {
        return this.account.getLatestConsumeTime();
    }

    public void setLatestConsumeTime(long latest_time) {
        this.account = this.account.toBuilder().setLatestConsumeTime(latest_time).build();
    }

    public long getLatestConsumeFreeTime() {
        return this.account.getLatestConsumeFreeTime();
    }

    public void setLatestConsumeFreeTime(long latest_time) {
        this.account = this.account.toBuilder().setLatestConsumeFreeTime(latest_time).build();
    }

    public void setBalance(long balance) {
        this.account = this.account.toBuilder().setBalance(balance).build();
    }

    public void addDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setDelegatedFrozenBalanceForBandwidth(this.account.getDelegatedFrozenBalanceForBandwidth() + balance).build();
    }

    public long getAcquiredDelegatedFrozenBalanceForBandwidth() {
        return this.account.getAcquiredDelegatedFrozenBalanceForBandwidth();
    }

    public void setAcquiredDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenBalanceForBandwidth(balance).build();
    }

    public void addAcquiredDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenBalanceForBandwidth(this.account.getAcquiredDelegatedFrozenBalanceForBandwidth() + balance).build();
    }

    public long getAcquiredDelegatedFrozenBalanceForEnergy() {
        return this.getAccountResource().getAcquiredDelegatedFrozenBalanceForEnergy();
    }

    public long getDelegatedFrozenBalanceForEnergy() {
        return this.getAccountResource().getDelegatedFrozenBalanceForEnergy();
    }

    public long getDelegatedFrozenBalanceForBandwidth() {
        return this.account.getDelegatedFrozenBalanceForBandwidth();
    }

    public void setDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setDelegatedFrozenBalanceForBandwidth(balance).build();
    }

    public void addAcquiredDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenBalanceForEnergy(this.getAccountResource().getAcquiredDelegatedFrozenBalanceForEnergy() + balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void addDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setDelegatedFrozenBalanceForEnergy(this.getAccountResource().getDelegatedFrozenBalanceForEnergy() + balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void setAllowance(long allowance) {
        this.account = this.account.toBuilder().setAllowance(allowance).build();
    }

    public String toString() {
        return this.account.toString();
    }

    public void addVotes(ByteString voteAddress, long voteAdd) {
        this.account = this.account.toBuilder().addVotes(Protocol.Vote.newBuilder().setVoteAddress(voteAddress).setVoteCount(voteAdd).build()).build();
    }

    public void clearAssetV2() {
        this.account = this.account.toBuilder().clearAssetV2().build();
    }

    public void clearLatestAssetOperationTimeV2() {
        this.account = this.account.toBuilder().clearLatestAssetOperationTimeV2().build();
    }

    public void clearFreeAssetNetUsageV2() {
        this.account = this.account.toBuilder().clearFreeAssetNetUsageV2().build();
    }

    public void clearVotes() {
        this.account = this.account.toBuilder().clearVotes().build();
    }

    public List<Protocol.Vote> getVotesList() {
        if (this.account.getVotesList() != null) {
            return this.account.getVotesList();
        }
        return Lists.newArrayList();
    }

    public long getTronPower() {
        long tp = 0L;
        for (int i = 0; i < this.account.getFrozenCount(); ++i) {
            tp += this.account.getFrozen(i).getFrozenBalance();
        }
        tp += this.account.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
        tp += this.account.getDelegatedFrozenBalanceForBandwidth();
        return tp += this.account.getAccountResource().getDelegatedFrozenBalanceForEnergy();
    }

    public boolean assetBalanceEnough(byte[] key, long amount) {
        Map<String, Long> assetMap = this.account.getAssetMap();
        String nameKey = ByteArray.toStr(key);
        Long currentAmount = assetMap.get(nameKey);
        return amount > 0L && null != currentAmount && amount <= currentAmount;
    }

    public boolean assetBalanceEnoughV2(byte[] key, long amount, Manager manager) {
        Long currentAmount;
        if (manager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            Map<String, Long> assetMap = this.account.getAssetMap();
            String nameKey = ByteArray.toStr(key);
            currentAmount = assetMap.get(nameKey);
        } else {
            String tokenID = ByteArray.toStr(key);
            Map<String, Long> assetMap = this.account.getAssetV2Map();
            currentAmount = assetMap.get(tokenID);
        }
        return amount > 0L && null != currentAmount && amount <= currentAmount;
    }

    public boolean reduceAssetAmount(byte[] key, long amount) {
        Map<String, Long> assetMap = this.account.getAssetMap();
        String nameKey = ByteArray.toStr(key);
        Long currentAmount = assetMap.get(nameKey);
        if (amount > 0L && null != currentAmount && amount <= currentAmount) {
            this.account = this.account.toBuilder().putAsset(nameKey, Math.subtractExact(currentAmount, amount)).build();
            return true;
        }
        return false;
    }

    public boolean reduceAssetAmountV2(byte[] key, long amount, Manager manager) {
        if (manager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            Map<String, Long> assetMap = this.account.getAssetMap();
            AssetIssueCapsule assetIssueCapsule = manager.getAssetIssueStore().get(key);
            String tokenID = assetIssueCapsule.getId();
            String nameKey = ByteArray.toStr(key);
            Long currentAmount = assetMap.get(nameKey);
            if (amount > 0L && null != currentAmount && amount <= currentAmount) {
                this.account = this.account.toBuilder().putAsset(nameKey, Math.subtractExact(currentAmount, amount)).putAssetV2(tokenID, Math.subtractExact(currentAmount, amount)).build();
                return true;
            }
        }
        if (manager.getDynamicPropertiesStore().getAllowSameTokenName() == 1L) {
            String tokenID = ByteArray.toStr(key);
            Map<String, Long> assetMapV2 = this.account.getAssetV2Map();
            Long currentAmount = assetMapV2.get(tokenID);
            if (amount > 0L && null != currentAmount && amount <= currentAmount) {
                this.account = this.account.toBuilder().putAssetV2(tokenID, Math.subtractExact(currentAmount, amount)).build();
                return true;
            }
        }
        return false;
    }

    public boolean addAssetAmount(byte[] key, long amount) {
        String nameKey;
        Map<String, Long> assetMap = this.account.getAssetMap();
        Long currentAmount = assetMap.get(nameKey = ByteArray.toStr(key));
        if (currentAmount == null) {
            currentAmount = 0L;
        }
        this.account = this.account.toBuilder().putAsset(nameKey, Math.addExact(currentAmount, amount)).build();
        return true;
    }

    public boolean addAssetAmountV2(byte[] key, long amount, Manager manager) {
        if (manager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            Map<String, Long> assetMap = this.account.getAssetMap();
            AssetIssueCapsule assetIssueCapsule = manager.getAssetIssueStore().get(key);
            String tokenID = assetIssueCapsule.getId();
            String nameKey = ByteArray.toStr(key);
            Long currentAmount = assetMap.get(nameKey);
            if (currentAmount == null) {
                currentAmount = 0L;
            }
            this.account = this.account.toBuilder().putAsset(nameKey, Math.addExact(currentAmount, amount)).putAssetV2(tokenID, Math.addExact(currentAmount, amount)).build();
        }
        if (manager.getDynamicPropertiesStore().getAllowSameTokenName() == 1L) {
            String tokenIDStr = ByteArray.toStr(key);
            Map<String, Long> assetMapV2 = this.account.getAssetV2Map();
            Long currentAmount = assetMapV2.get(tokenIDStr);
            if (currentAmount == null) {
                currentAmount = 0L;
            }
            this.account = this.account.toBuilder().putAssetV2(tokenIDStr, Math.addExact(currentAmount, amount)).build();
        }
        return true;
    }

    public void setAccountName(byte[] name) {
        this.account = this.account.toBuilder().setAccountName(ByteString.copyFrom((byte[])name)).build();
    }

    public void setAccountId(byte[] id) {
        this.account = this.account.toBuilder().setAccountId(ByteString.copyFrom((byte[])id)).build();
    }

    public boolean addAsset(byte[] key, long value) {
        Map<String, Long> assetMap = this.account.getAssetMap();
        String nameKey = ByteArray.toStr(key);
        if (!assetMap.isEmpty() && assetMap.containsKey(nameKey)) {
            return false;
        }
        this.account = this.account.toBuilder().putAsset(nameKey, value).build();
        return true;
    }

    public boolean addAssetV2(byte[] key, long value) {
        String tokenID = ByteArray.toStr(key);
        Map<String, Long> assetV2Map = this.account.getAssetV2Map();
        if (!assetV2Map.isEmpty() && assetV2Map.containsKey(tokenID)) {
            return false;
        }
        this.account = this.account.toBuilder().putAssetV2(tokenID, value).build();
        return true;
    }

    public boolean addAssetMapV2(Map<String, Long> assetMap) {
        this.account = this.account.toBuilder().putAllAssetV2(assetMap).build();
        return true;
    }

    public Map<String, Long> getAssetMap() {
        HashMap assetMap = this.account.getAssetMap();
        if (assetMap.isEmpty()) {
            assetMap = Maps.newHashMap();
        }
        return assetMap;
    }

    public Map<String, Long> getAssetMapV2() {
        HashMap assetMap = this.account.getAssetV2Map();
        if (assetMap.isEmpty()) {
            assetMap = Maps.newHashMap();
        }
        return assetMap;
    }

    public boolean addAllLatestAssetOperationTimeV2(Map<String, Long> map) {
        this.account = this.account.toBuilder().putAllLatestAssetOperationTimeV2(map).build();
        return true;
    }

    public Map<String, Long> getLatestAssetOperationTimeMap() {
        return this.account.getLatestAssetOperationTimeMap();
    }

    public Map<String, Long> getLatestAssetOperationTimeMapV2() {
        return this.account.getLatestAssetOperationTimeV2Map();
    }

    public long getLatestAssetOperationTime(String assetName) {
        return this.account.getLatestAssetOperationTimeOrDefault(assetName, 0L);
    }

    public long getLatestAssetOperationTimeV2(String assetName) {
        return this.account.getLatestAssetOperationTimeV2OrDefault(assetName, 0L);
    }

    public void putLatestAssetOperationTimeMap(String key, Long value) {
        this.account = this.account.toBuilder().putLatestAssetOperationTime(key, value).build();
    }

    public void putLatestAssetOperationTimeMapV2(String key, Long value) {
        this.account = this.account.toBuilder().putLatestAssetOperationTimeV2(key, value).build();
    }

    public int getFrozenCount() {
        return this.getInstance().getFrozenCount();
    }

    public List<Protocol.Account.Frozen> getFrozenList() {
        return this.getInstance().getFrozenList();
    }

    public long getFrozenBalance() {
        List<Protocol.Account.Frozen> frozenList = this.getFrozenList();
        long[] frozenBalance = new long[]{0L};
        frozenList.forEach(frozen -> {
            frozenBalance[0] = Long.sum(frozenBalance[0], frozen.getFrozenBalance());
        });
        return frozenBalance[0];
    }

    public long getAllFrozenBalanceForBandwidth() {
        return this.getFrozenBalance() + this.getAcquiredDelegatedFrozenBalanceForBandwidth();
    }

    public int getFrozenSupplyCount() {
        return this.getInstance().getFrozenSupplyCount();
    }

    public List<Protocol.Account.Frozen> getFrozenSupplyList() {
        return this.getInstance().getFrozenSupplyList();
    }

    public long getFrozenSupplyBalance() {
        List<Protocol.Account.Frozen> frozenSupplyList = this.getFrozenSupplyList();
        long[] frozenSupplyBalance = new long[]{0L};
        frozenSupplyList.forEach(frozen -> {
            frozenSupplyBalance[0] = Long.sum(frozenSupplyBalance[0], frozen.getFrozenBalance());
        });
        return frozenSupplyBalance[0];
    }

    public ByteString getAssetIssuedName() {
        return this.getInstance().getAssetIssuedName();
    }

    public void setAssetIssuedName(byte[] nameKey) {
        ByteString assetIssuedName = ByteString.copyFrom((byte[])nameKey);
        this.account = this.account.toBuilder().setAssetIssuedName(assetIssuedName).build();
    }

    public ByteString getAssetIssuedID() {
        return this.getInstance().getAssetIssuedID();
    }

    public void setAssetIssuedID(byte[] id) {
        ByteString assetIssuedID = ByteString.copyFrom((byte[])id);
        this.account = this.account.toBuilder().setAssetIssuedID(assetIssuedID).build();
    }

    public long getAllowance() {
        return this.getInstance().getAllowance();
    }

    public long getLatestWithdrawTime() {
        return this.getInstance().getLatestWithdrawTime();
    }

    public boolean getIsWitness() {
        return this.getInstance().getIsWitness();
    }

    public void setIsWitness(boolean isWitness) {
        this.account = this.account.toBuilder().setIsWitness(isWitness).build();
    }

    public boolean getIsCommittee() {
        return this.getInstance().getIsCommittee();
    }

    public void setIsCommittee(boolean isCommittee) {
        this.account = this.account.toBuilder().setIsCommittee(isCommittee).build();
    }

    public void setFrozenForBandwidth(long frozenBalance, long expireTime) {
        Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(frozenBalance).setExpireTime(expireTime).build();
        long frozenCount = this.getFrozenCount();
        if (frozenCount == 0L) {
            this.setInstance(this.getInstance().toBuilder().addFrozen(newFrozen).build());
        } else {
            this.setInstance(this.getInstance().toBuilder().setFrozen(0, newFrozen).build());
        }
    }

    public void setFrozen(long frozenBalance, long expireTime) {
        Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(frozenBalance).setExpireTime(expireTime).build();
        this.account = this.account.toBuilder().addFrozen(newFrozen).build();
    }

    public void setLatestWithdrawTime(long latestWithdrawTime) {
        this.account = this.account.toBuilder().setLatestWithdrawTime(latestWithdrawTime).build();
    }

    public long getNetUsage() {
        return this.account.getNetUsage();
    }

    public void setNetUsage(long netUsage) {
        this.account = this.account.toBuilder().setNetUsage(netUsage).build();
    }

    public Protocol.Account.AccountResource getAccountResource() {
        return this.account.getAccountResource();
    }

    public void setFrozenForEnergy(long newFrozenBalanceForEnergy, long time) {
        Protocol.Account.Frozen newFrozenForEnergy = Protocol.Account.Frozen.newBuilder().setFrozenBalance(newFrozenBalanceForEnergy).setExpireTime(time).build();
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setFrozenBalanceForEnergy(newFrozenForEnergy).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public long getEnergyFrozenBalance() {
        return this.account.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
    }

    public long getEnergyUsage() {
        return this.account.getAccountResource().getEnergyUsage();
    }

    public long getAllFrozenBalanceForEnergy() {
        return this.getEnergyFrozenBalance() + this.getAcquiredDelegatedFrozenBalanceForEnergy();
    }

    public void setEnergyUsage(long energyUsage) {
        this.account = this.account.toBuilder().setAccountResource(this.account.getAccountResource().toBuilder().setEnergyUsage(energyUsage).build()).build();
    }

    public void setLatestConsumeTimeForEnergy(long latest_time) {
        this.account = this.account.toBuilder().setAccountResource(this.account.getAccountResource().toBuilder().setLatestConsumeTimeForEnergy(latest_time).build()).build();
    }

    public long getLatestConsumeTimeForEnergy() {
        return this.account.getAccountResource().getLatestConsumeTimeForEnergy();
    }

    public long getFreeNetUsage() {
        return this.account.getFreeNetUsage();
    }

    public void setFreeNetUsage(long freeNetUsage) {
        this.account = this.account.toBuilder().setFreeNetUsage(freeNetUsage).build();
    }

    public boolean addAllFreeAssetNetUsageV2(Map<String, Long> map) {
        this.account = this.account.toBuilder().putAllFreeAssetNetUsageV2(map).build();
        return true;
    }

    public long getFreeAssetNetUsage(String assetName) {
        return this.account.getFreeAssetNetUsageOrDefault(assetName, 0L);
    }

    public long getFreeAssetNetUsageV2(String assetName) {
        return this.account.getFreeAssetNetUsageV2OrDefault(assetName, 0L);
    }

    public Map<String, Long> getAllFreeAssetNetUsage() {
        return this.account.getFreeAssetNetUsageMap();
    }

    public Map<String, Long> getAllFreeAssetNetUsageV2() {
        return this.account.getFreeAssetNetUsageV2Map();
    }

    public void putFreeAssetNetUsage(String s, long freeAssetNetUsage) {
        this.account = this.account.toBuilder().putFreeAssetNetUsage(s, freeAssetNetUsage).build();
    }

    public void putFreeAssetNetUsageV2(String s, long freeAssetNetUsage) {
        this.account = this.account.toBuilder().putFreeAssetNetUsageV2(s, freeAssetNetUsage).build();
    }

    public long getStorageLimit() {
        return this.account.getAccountResource().getStorageLimit();
    }

    public void setStorageLimit(long limit) {
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setStorageLimit(limit).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public long getStorageUsage() {
        return this.account.getAccountResource().getStorageUsage();
    }

    public long getStorageLeft() {
        return this.getStorageLimit() - this.getStorageUsage();
    }

    public void setStorageUsage(long usage) {
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setStorageUsage(usage).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public long getLatestExchangeStorageTime() {
        return this.account.getAccountResource().getLatestExchangeStorageTime();
    }

    public void setLatestExchangeStorageTime(long time) {
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setLatestExchangeStorageTime(time).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public void addStorageUsage(long storageUsage) {
        if (storageUsage <= 0L) {
            return;
        }
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setStorageUsage(accountResource.getStorageUsage() + storageUsage).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }
}

