/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.math.LongMath;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.storage.Deposit;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.db.VotesStore;
import org.tron.core.db.WitnessStore;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class VoteWitnessActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(VoteWitnessActuator.class);

    VoteWitnessActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.VoteWitnessContract voteContract = (Contract.VoteWitnessContract)this.contract.unpack(Contract.VoteWitnessContract.class);
            this.countVoteAccount(voteContract, this.getDeposit());
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.VoteWitnessContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null && (this.getDeposit() == null || this.getDeposit().getDbManager() == null)) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.VoteWitnessContract.class)) {
            throw new ContractValidateException("contract type error,expected type [VoteWitnessContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.VoteWitnessContract)this.contract.unpack(Contract.VoteWitnessContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!Wallet.addressValid(contract.getOwnerAddress().toByteArray())) {
            throw new ContractValidateException("Invalid address");
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        AccountStore accountStore = this.dbManager.getAccountStore();
        WitnessStore witnessStore = this.dbManager.getWitnessStore();
        if (contract.getVotesCount() == 0) {
            throw new ContractValidateException("VoteNumber must more than 0");
        }
        int maxVoteNumber = 30;
        if (contract.getVotesCount() > maxVoteNumber) {
            throw new ContractValidateException("VoteNumber more than maxVoteNumber " + maxVoteNumber);
        }
        try {
            AccountCapsule accountCapsule;
            Iterator<Contract.VoteWitnessContract.Vote> iterator = contract.getVotesList().iterator();
            Long sum = 0L;
            while (iterator.hasNext()) {
                Contract.VoteWitnessContract.Vote vote = iterator.next();
                byte[] witnessCandidate = vote.getVoteAddress().toByteArray();
                if (!Wallet.addressValid(witnessCandidate)) {
                    throw new ContractValidateException("Invalid vote address!");
                }
                long voteCount = vote.getVoteCount();
                if (voteCount <= 0L) {
                    throw new ContractValidateException("vote count must be greater than 0");
                }
                String readableWitnessAddress = StringUtil.createReadableString(vote.getVoteAddress());
                if (!Objects.isNull(this.getDeposit()) ? Objects.isNull(this.getDeposit().getAccount(witnessCandidate)) : !accountStore.has(witnessCandidate)) {
                    throw new ContractValidateException("Account[" + readableWitnessAddress + "] not exists");
                }
                if (!Objects.isNull(this.getDeposit()) ? Objects.isNull(this.getDeposit().getWitness(witnessCandidate)) : !witnessStore.has(witnessCandidate)) {
                    throw new ContractValidateException("Witness[" + readableWitnessAddress + "] not exists");
                }
                sum = LongMath.checkedAdd((long)sum, (long)vote.getVoteCount());
            }
            AccountCapsule accountCapsule2 = accountCapsule = Objects.isNull(this.getDeposit()) ? accountStore.get(ownerAddress) : this.getDeposit().getAccount(ownerAddress);
            if (accountCapsule == null) {
                throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
            }
            long tronPower = accountCapsule.getTronPower();
            if ((sum = Long.valueOf(LongMath.checkedMultiply((long)sum, (long)1000000L))) > tronPower) {
                throw new ContractValidateException("The total number of votes[" + sum + "] is greater than the tronPower[" + tronPower + "]");
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    private void countVoteAccount(Contract.VoteWitnessContract voteContract, Deposit deposit) {
        VotesCapsule vCapsule;
        AccountCapsule accountCapsule;
        byte[] ownerAddress = voteContract.getOwnerAddress().toByteArray();
        VotesStore votesStore = this.dbManager.getVotesStore();
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountCapsule accountCapsule2 = accountCapsule = Objects.isNull(this.getDeposit()) ? accountStore.get(ownerAddress) : this.getDeposit().getAccount(ownerAddress);
        VotesCapsule votesCapsule = !Objects.isNull(this.getDeposit()) ? (Objects.isNull(vCapsule = this.getDeposit().getVotesCapsule(ownerAddress)) ? new VotesCapsule(voteContract.getOwnerAddress(), accountCapsule.getVotesList()) : vCapsule) : (!votesStore.has(ownerAddress) ? new VotesCapsule(voteContract.getOwnerAddress(), accountCapsule.getVotesList()) : votesStore.get(ownerAddress));
        accountCapsule.clearVotes();
        votesCapsule.clearNewVotes();
        voteContract.getVotesList().forEach(vote -> {
            logger.debug("countVoteAccount,address[{}]", (Object)ByteArray.toHexString(vote.getVoteAddress().toByteArray()));
            votesCapsule.addNewVotes(vote.getVoteAddress(), vote.getVoteCount());
            accountCapsule.addVotes(vote.getVoteAddress(), vote.getVoteCount());
        });
        if (Objects.isNull(deposit)) {
            accountStore.put(accountCapsule.createDbKey(), accountCapsule);
            votesStore.put(ownerAddress, votesCapsule);
        } else {
            deposit.putAccountValue(accountCapsule.createDbKey(), accountCapsule);
            deposit.putVoteValue(ownerAddress, votesCapsule);
        }
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.VoteWitnessContract)this.contract.unpack(Contract.VoteWitnessContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

