/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.AccountIndexStore;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class UpdateAccountActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(UpdateAccountActuator.class);

    UpdateAccountActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.AccountUpdateContract accountUpdateContract;
        long fee = this.calcFee();
        try {
            accountUpdateContract = (Contract.AccountUpdateContract)this.contract.unpack(Contract.AccountUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = accountUpdateContract.getOwnerAddress().toByteArray();
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountIndexStore accountIndexStore = this.dbManager.getAccountIndexStore();
        AccountCapsule account = accountStore.get(ownerAddress);
        account.setAccountName(accountUpdateContract.getAccountName().toByteArray());
        accountStore.put(ownerAddress, account);
        accountIndexStore.put(account);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.AccountUpdateContract accountUpdateContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.AccountUpdateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [AccountUpdateContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            accountUpdateContract = (Contract.AccountUpdateContract)this.contract.unpack(Contract.AccountUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = accountUpdateContract.getOwnerAddress().toByteArray();
        byte[] accountName = accountUpdateContract.getAccountName().toByteArray();
        if (!TransactionUtil.validAccountName(accountName)) {
            throw new ContractValidateException("Invalid accountName");
        }
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule account = this.dbManager.getAccountStore().get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account has not existed");
        }
        if (account.getAccountName() != null && !account.getAccountName().isEmpty() && this.dbManager.getDynamicPropertiesStore().getAllowUpdateAccountName() == 0L) {
            throw new ContractValidateException("This account name already exist");
        }
        if (this.dbManager.getAccountIndexStore().has(accountName) && this.dbManager.getDynamicPropertiesStore().getAllowUpdateAccountName() == 0L) {
            throw new ContractValidateException("This name has existed");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.AccountUpdateContract)this.contract.unpack(Contract.AccountUpdateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

