/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ParticipateAssetIssueActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ParticipateAssetIssueActuator.class);

    ParticipateAssetIssueActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.ParticipateAssetIssueContract participateAssetIssueContract = (Contract.ParticipateAssetIssueContract)this.contract.unpack(Contract.ParticipateAssetIssueContract.class);
            long cost = participateAssetIssueContract.getAmount();
            byte[] ownerAddress = participateAssetIssueContract.getOwnerAddress().toByteArray();
            AccountCapsule ownerAccount = this.dbManager.getAccountStore().get(ownerAddress);
            long balance = Math.subtractExact(ownerAccount.getBalance(), cost);
            balance = Math.subtractExact(balance, fee);
            ownerAccount.setBalance(balance);
            byte[] key = participateAssetIssueContract.getAssetName().toByteArray();
            AssetIssueCapsule assetIssueCapsule = this.dbManager.getAssetIssueStoreFinal().get(key);
            long exchangeAmount = Math.multiplyExact(cost, (long)assetIssueCapsule.getNum());
            exchangeAmount = Math.floorDiv(exchangeAmount, (long)assetIssueCapsule.getTrxNum());
            ownerAccount.addAssetAmountV2(key, exchangeAmount, this.dbManager);
            byte[] toAddress = participateAssetIssueContract.getToAddress().toByteArray();
            AccountCapsule toAccount = this.dbManager.getAccountStore().get(toAddress);
            toAccount.setBalance(Math.addExact(toAccount.getBalance(), cost));
            if (!toAccount.reduceAssetAmountV2(key, exchangeAmount, this.dbManager)) {
                throw new ContractExeException("reduceAssetAmount failed !");
            }
            this.dbManager.getAccountStore().put(ownerAddress, ownerAccount);
            this.dbManager.getAccountStore().put(toAddress, toAccount);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.ParticipateAssetIssueContract participateAssetIssueContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ParticipateAssetIssueContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ParticipateAssetIssueContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            participateAssetIssueContract = (Contract.ParticipateAssetIssueContract)this.contract.unpack(Contract.ParticipateAssetIssueContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = participateAssetIssueContract.getOwnerAddress().toByteArray();
        byte[] toAddress = participateAssetIssueContract.getToAddress().toByteArray();
        byte[] assetName = participateAssetIssueContract.getAssetName().toByteArray();
        long amount = participateAssetIssueContract.getAmount();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!Wallet.addressValid(toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must greater than 0!");
        }
        if (Arrays.equals(ownerAddress, toAddress)) {
            throw new ContractValidateException("Cannot participate asset Issue yourself !");
        }
        AccountCapsule ownerAccount = this.dbManager.getAccountStore().get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Account does not exist!");
        }
        try {
            long fee = this.calcFee();
            if (ownerAccount.getBalance() < Math.addExact(amount, fee)) {
                throw new ContractValidateException("No enough balance !");
            }
            AssetIssueCapsule assetIssueCapsule = this.dbManager.getAssetIssueStoreFinal().get(assetName);
            if (assetIssueCapsule == null) {
                throw new ContractValidateException("No asset named " + ByteArray.toStr(assetName));
            }
            if (!Arrays.equals(toAddress, assetIssueCapsule.getOwnerAddress().toByteArray())) {
                throw new ContractValidateException("The asset is not issued by " + ByteArray.toHexString(toAddress));
            }
            long now = this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
            if (now >= assetIssueCapsule.getEndTime() || now < assetIssueCapsule.getStartTime()) {
                throw new ContractValidateException("No longer valid period!");
            }
            int trxNum = assetIssueCapsule.getTrxNum();
            int num = assetIssueCapsule.getNum();
            long exchangeAmount = Math.multiplyExact(amount, (long)num);
            if ((exchangeAmount = Math.floorDiv(exchangeAmount, (long)trxNum)) <= 0L) {
                throw new ContractValidateException("Can not process the exchange!");
            }
            AccountCapsule toAccount = this.dbManager.getAccountStore().get(toAddress);
            if (toAccount == null) {
                throw new ContractValidateException("To account does not exist!");
            }
            if (!toAccount.assetBalanceEnoughV2(assetName, exchangeAmount, this.dbManager)) {
                throw new ContractValidateException("Asset balance is not enough !");
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ParticipateAssetIssueContract)this.contract.unpack(Contract.ParticipateAssetIssueContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

