/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ExchangeWithdrawActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeWithdrawActuator.class);

    ExchangeWithdrawActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            long anotherTokenQuant;
            byte[] anotherTokenID;
            Contract.ExchangeWithdrawContract exchangeWithdrawContract = (Contract.ExchangeWithdrawContract)this.contract.unpack(Contract.ExchangeWithdrawContract.class);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(exchangeWithdrawContract.getOwnerAddress().toByteArray());
            ExchangeCapsule exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(ByteArray.fromLong(exchangeWithdrawContract.getExchangeId()));
            byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
            byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
            long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
            long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
            byte[] tokenID = exchangeWithdrawContract.getTokenId().toByteArray();
            long tokenQuant = exchangeWithdrawContract.getQuant();
            BigInteger bigFirstTokenBalance = new BigInteger(String.valueOf(firstTokenBalance));
            BigInteger bigSecondTokenBalance = new BigInteger(String.valueOf(secondTokenBalance));
            BigInteger bigTokenQuant = new BigInteger(String.valueOf(tokenQuant));
            if (Arrays.equals(tokenID, firstTokenID)) {
                anotherTokenID = secondTokenID;
                anotherTokenQuant = bigSecondTokenBalance.multiply(bigTokenQuant).divide(bigFirstTokenBalance).longValueExact();
                exchangeCapsule.setBalance(firstTokenBalance - tokenQuant, secondTokenBalance - anotherTokenQuant);
            } else {
                anotherTokenID = firstTokenID;
                anotherTokenQuant = bigFirstTokenBalance.multiply(bigTokenQuant).divide(bigSecondTokenBalance).longValueExact();
                exchangeCapsule.setBalance(firstTokenBalance - anotherTokenQuant, secondTokenBalance - tokenQuant);
            }
            long newBalance = accountCapsule.getBalance() - this.calcFee();
            if (Arrays.equals(tokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance + tokenQuant);
            } else {
                accountCapsule.addAssetAmountV2(tokenID, tokenQuant, this.dbManager);
            }
            if (Arrays.equals(anotherTokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance + anotherTokenQuant);
            } else {
                accountCapsule.addAssetAmountV2(anotherTokenID, anotherTokenQuant, this.dbManager);
            }
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            this.dbManager.putExchangeCapsule(exchangeCapsule);
            ret.setExchangeWithdrawAnotherAmount(anotherTokenQuant);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        ExchangeCapsule exchangeCapsule;
        Contract.ExchangeWithdrawContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ExchangeWithdrawContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeWithdrawContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ExchangeWithdrawContract)this.contract.unpack(Contract.ExchangeWithdrawContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange withdraw fee!");
        }
        try {
            exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(ByteArray.fromLong(contract.getExchangeId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Exchange[" + contract.getExchangeId() + "] not exists");
        }
        if (!accountCapsule.getAddress().equals((Object)exchangeCapsule.getCreatorAddress())) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] is not creator");
        }
        byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
        byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
        long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
        long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
        byte[] tokenID = contract.getTokenId().toByteArray();
        long tokenQuant = contract.getQuant();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 1L && !Arrays.equals(tokenID, "_".getBytes()) && !TransactionUtil.isNumber(tokenID)) {
            throw new ContractValidateException("token id is not a valid number");
        }
        if (!Arrays.equals(tokenID, firstTokenID) && !Arrays.equals(tokenID, secondTokenID)) {
            throw new ContractValidateException("token is not in exchange");
        }
        if (tokenQuant <= 0L) {
            throw new ContractValidateException("withdraw token quant must greater than zero");
        }
        if (firstTokenBalance == 0L || secondTokenBalance == 0L) {
            throw new ContractValidateException("Token balance in exchange is equal with 0,the exchange has been closed");
        }
        BigDecimal bigFirstTokenBalance = new BigDecimal(String.valueOf(firstTokenBalance));
        BigDecimal bigSecondTokenBalance = new BigDecimal(String.valueOf(secondTokenBalance));
        BigDecimal bigTokenQuant = new BigDecimal(String.valueOf(tokenQuant));
        if (Arrays.equals(tokenID, firstTokenID)) {
            long anotherTokenQuant = bigSecondTokenBalance.multiply(bigTokenQuant).divideToIntegralValue(bigFirstTokenBalance).longValueExact();
            if (firstTokenBalance < tokenQuant || secondTokenBalance < anotherTokenQuant) {
                throw new ContractValidateException("exchange balance is not enough");
            }
            if (anotherTokenQuant <= 0L) {
                throw new ContractValidateException("withdraw another token quant must greater than zero");
            }
            double remainder = bigSecondTokenBalance.multiply(bigTokenQuant).divide(bigFirstTokenBalance, 4, 4).doubleValue() - (double)anotherTokenQuant;
            if (remainder / (double)anotherTokenQuant > 1.0E-4) {
                throw new ContractValidateException("Not precise enough");
            }
        } else {
            long anotherTokenQuant = bigFirstTokenBalance.multiply(bigTokenQuant).divideToIntegralValue(bigSecondTokenBalance).longValueExact();
            if (secondTokenBalance < tokenQuant || firstTokenBalance < anotherTokenQuant) {
                throw new ContractValidateException("exchange balance is not enough");
            }
            if (anotherTokenQuant <= 0L) {
                throw new ContractValidateException("withdraw another token quant must greater than zero");
            }
            double remainder = bigFirstTokenBalance.multiply(bigTokenQuant).divide(bigSecondTokenBalance, 4, 4).doubleValue() - (double)anotherTokenQuant;
            if (remainder / (double)anotherTokenQuant > 1.0E-4) {
                throw new ContractValidateException("Not precise enough");
            }
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ExchangeWithdrawContract)this.contract.unpack(Contract.ExchangeWithdrawContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

