/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ExchangeTransactionActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeTransactionActuator.class);

    ExchangeTransactionActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.ExchangeTransactionContract exchangeTransactionContract = (Contract.ExchangeTransactionContract)this.contract.unpack(Contract.ExchangeTransactionContract.class);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(exchangeTransactionContract.getOwnerAddress().toByteArray());
            ExchangeCapsule exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(ByteArray.fromLong(exchangeTransactionContract.getExchangeId()));
            byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
            byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
            byte[] tokenID = exchangeTransactionContract.getTokenId().toByteArray();
            long tokenQuant = exchangeTransactionContract.getQuant();
            long anotherTokenQuant = exchangeCapsule.transaction(tokenID, tokenQuant);
            byte[] anotherTokenID = Arrays.equals(tokenID, firstTokenID) ? secondTokenID : firstTokenID;
            long newBalance = accountCapsule.getBalance() - this.calcFee();
            accountCapsule.setBalance(newBalance);
            if (Arrays.equals(tokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance - tokenQuant);
            } else {
                accountCapsule.reduceAssetAmountV2(tokenID, tokenQuant, this.dbManager);
            }
            if (Arrays.equals(anotherTokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance + anotherTokenQuant);
            } else {
                accountCapsule.addAssetAmountV2(anotherTokenID, anotherTokenQuant, this.dbManager);
            }
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            this.dbManager.putExchangeCapsule(exchangeCapsule);
            ret.setExchangeReceivedAmount(anotherTokenQuant);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        long anotherTokenQuant;
        long tokenBalance;
        ExchangeCapsule exchangeCapsule;
        Contract.ExchangeTransactionContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ExchangeTransactionContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeTransactionContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ExchangeTransactionContract)this.contract.unpack(Contract.ExchangeTransactionContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange transaction fee!");
        }
        try {
            exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(ByteArray.fromLong(contract.getExchangeId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Exchange[" + contract.getExchangeId() + "] not exists");
        }
        byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
        byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
        long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
        long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
        byte[] tokenID = contract.getTokenId().toByteArray();
        long tokenQuant = contract.getQuant();
        long tokenExpected = contract.getExpected();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 1L && !Arrays.equals(tokenID, "_".getBytes()) && !TransactionUtil.isNumber(tokenID)) {
            throw new ContractValidateException("token id is not a valid number");
        }
        if (!Arrays.equals(tokenID, firstTokenID) && !Arrays.equals(tokenID, secondTokenID)) {
            throw new ContractValidateException("token is not in exchange");
        }
        if (tokenQuant <= 0L) {
            throw new ContractValidateException("token quant must greater than zero");
        }
        if (tokenExpected <= 0L) {
            throw new ContractValidateException("token expected must greater than zero");
        }
        if (firstTokenBalance == 0L || secondTokenBalance == 0L) {
            throw new ContractValidateException("Token balance in exchange is equal with 0,the exchange has been closed");
        }
        long balanceLimit = this.dbManager.getDynamicPropertiesStore().getExchangeBalanceLimit();
        long l = tokenBalance = Arrays.equals(tokenID, firstTokenID) ? firstTokenBalance : secondTokenBalance;
        if ((tokenBalance += tokenQuant) > balanceLimit) {
            throw new ContractValidateException("token balance must less than " + balanceLimit);
        }
        if (Arrays.equals(tokenID, "_".getBytes())) {
            if (accountCapsule.getBalance() < tokenQuant + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(tokenID, tokenQuant, this.dbManager)) {
            throw new ContractValidateException("token balance is not enough");
        }
        if ((anotherTokenQuant = exchangeCapsule.transaction(tokenID, tokenQuant)) < tokenExpected) {
            throw new ContractValidateException("token required must greater than expected");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ExchangeTransactionContract)this.contract.unpack(Contract.ExchangeTransactionContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

