/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ExchangeCreateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeCreateActuator.class);

    ExchangeCreateActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.ExchangeCreateContract exchangeCreateContract = (Contract.ExchangeCreateContract)this.contract.unpack(Contract.ExchangeCreateContract.class);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(exchangeCreateContract.getOwnerAddress().toByteArray());
            byte[] firstTokenID = exchangeCreateContract.getFirstTokenId().toByteArray();
            byte[] secondTokenID = exchangeCreateContract.getSecondTokenId().toByteArray();
            long firstTokenBalance = exchangeCreateContract.getFirstTokenBalance();
            long secondTokenBalance = exchangeCreateContract.getSecondTokenBalance();
            long newBalance = accountCapsule.getBalance() - fee;
            accountCapsule.setBalance(newBalance);
            if (Arrays.equals(firstTokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance - firstTokenBalance);
            } else {
                accountCapsule.reduceAssetAmountV2(firstTokenID, firstTokenBalance, this.dbManager);
            }
            if (Arrays.equals(secondTokenID, "_".getBytes())) {
                accountCapsule.setBalance(newBalance - secondTokenBalance);
            } else {
                accountCapsule.reduceAssetAmountV2(secondTokenID, secondTokenBalance, this.dbManager);
            }
            long id = this.dbManager.getDynamicPropertiesStore().getLatestExchangeNum() + 1L;
            long now = this.dbManager.getHeadBlockTimeStamp();
            if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
                ExchangeCapsule exchangeCapsule = new ExchangeCapsule(exchangeCreateContract.getOwnerAddress(), id, now, firstTokenID, secondTokenID);
                exchangeCapsule.setBalance(firstTokenBalance, secondTokenBalance);
                this.dbManager.getExchangeStore().put(exchangeCapsule.createDbKey(), exchangeCapsule);
                if (!Arrays.equals(firstTokenID, "_".getBytes())) {
                    String firstTokenRealID = this.dbManager.getAssetIssueStore().get(firstTokenID).getId();
                    firstTokenID = firstTokenRealID.getBytes();
                }
                if (!Arrays.equals(secondTokenID, "_".getBytes())) {
                    String secondTokenRealID = this.dbManager.getAssetIssueStore().get(secondTokenID).getId();
                    secondTokenID = secondTokenRealID.getBytes();
                }
            }
            ExchangeCapsule exchangeCapsuleV2 = new ExchangeCapsule(exchangeCreateContract.getOwnerAddress(), id, now, firstTokenID, secondTokenID);
            exchangeCapsuleV2.setBalance(firstTokenBalance, secondTokenBalance);
            this.dbManager.getExchangeV2Store().put(exchangeCapsuleV2.createDbKey(), exchangeCapsuleV2);
            this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            this.dbManager.getDynamicPropertiesStore().saveLatestExchangeNum(id);
            this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().createDbKey(), fee);
            ret.setExchangeId(id);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.ExchangeCreateContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ExchangeCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeCreateContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ExchangeCreateContract)this.contract.unpack(Contract.ExchangeCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange create fee!");
        }
        byte[] firstTokenID = contract.getFirstTokenId().toByteArray();
        byte[] secondTokenID = contract.getSecondTokenId().toByteArray();
        long firstTokenBalance = contract.getFirstTokenBalance();
        long secondTokenBalance = contract.getSecondTokenBalance();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 1L) {
            if (!Arrays.equals(firstTokenID, "_".getBytes()) && !TransactionUtil.isNumber(firstTokenID)) {
                throw new ContractValidateException("first token id is not a valid number");
            }
            if (!Arrays.equals(secondTokenID, "_".getBytes()) && !TransactionUtil.isNumber(secondTokenID)) {
                throw new ContractValidateException("second token id is not a valid number");
            }
        }
        if (Arrays.equals(firstTokenID, secondTokenID)) {
            throw new ContractValidateException("cannot exchange same tokens");
        }
        if (firstTokenBalance <= 0L || secondTokenBalance <= 0L) {
            throw new ContractValidateException("token balance must greater than zero");
        }
        long balanceLimit = this.dbManager.getDynamicPropertiesStore().getExchangeBalanceLimit();
        if (firstTokenBalance > balanceLimit || secondTokenBalance > balanceLimit) {
            throw new ContractValidateException("token balance must less than " + balanceLimit);
        }
        if (Arrays.equals(firstTokenID, "_".getBytes())) {
            if (accountCapsule.getBalance() < firstTokenBalance + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(firstTokenID, firstTokenBalance, this.dbManager)) {
            throw new ContractValidateException("first token balance is not enough");
        }
        if (Arrays.equals(secondTokenID, "_".getBytes())) {
            if (accountCapsule.getBalance() < secondTokenBalance + this.calcFee()) {
                throw new ContractValidateException("balance is not enough");
            }
        } else if (!accountCapsule.assetBalanceEnoughV2(secondTokenID, secondTokenBalance, this.dbManager)) {
            throw new ContractValidateException("second token balance is not enough");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ExchangeCreateContract)this.contract.unpack(Contract.ExchangeCreateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return this.dbManager.getDynamicPropertiesStore().getExchangeCreateFee();
    }
}

