/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.StorageMarket;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class BuyStorageBytesActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(BuyStorageBytesActuator.class);
    private StorageMarket storageMarket;

    BuyStorageBytesActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
        this.storageMarket = new StorageMarket(dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.BuyStorageBytesContract BuyStorageBytesContract2;
        long fee = this.calcFee();
        try {
            BuyStorageBytesContract2 = (Contract.BuyStorageBytesContract)this.contract.unpack(Contract.BuyStorageBytesContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(BuyStorageBytesContract2.getOwnerAddress().toByteArray());
        long bytes = BuyStorageBytesContract2.getBytes();
        this.storageMarket.buyStorageBytes(accountCapsule, bytes);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.BuyStorageBytesContract BuyStorageBytesContract2;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.BuyStorageBytesContract.class)) {
            throw new ContractValidateException("contract type error,expected type [BuyStorageBytesContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            BuyStorageBytesContract2 = (Contract.BuyStorageBytesContract)this.contract.unpack(Contract.BuyStorageBytesContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = BuyStorageBytesContract2.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long bytes = BuyStorageBytesContract2.getBytes();
        if (bytes < 0L) {
            throw new ContractValidateException("bytes must be positive");
        }
        if (bytes < 1L) {
            throw new ContractValidateException("bytes must be larger than 1, current storage_bytes[" + bytes + "]");
        }
        long quant = this.storageMarket.tryBuyStorageBytes(bytes);
        if (quant < 1000000L) {
            throw new ContractValidateException("quantity must be larger than 1TRX");
        }
        if (quant > accountCapsule.getBalance()) {
            throw new ContractValidateException("quantity must be less than accountBalance");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.BuyStorageBytesContract)this.contract.unpack(Contract.BuyStorageBytesContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

