/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class AssetIssueActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(AssetIssueActuator.class);

    AssetIssueActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.AssetIssueContract assetIssueContract = (Contract.AssetIssueContract)this.contract.unpack(Contract.AssetIssueContract.class);
            byte[] ownerAddress = assetIssueContract.getOwnerAddress().toByteArray();
            AssetIssueCapsule assetIssueCapsule = new AssetIssueCapsule(assetIssueContract);
            AssetIssueCapsule assetIssueCapsuleV2 = new AssetIssueCapsule(assetIssueContract);
            long tokenIdNum = this.dbManager.getDynamicPropertiesStore().getTokenIdNum();
            assetIssueCapsule.setId(Long.toString(++tokenIdNum));
            assetIssueCapsuleV2.setId(Long.toString(tokenIdNum));
            this.dbManager.getDynamicPropertiesStore().saveTokenIdNum(tokenIdNum);
            if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
                assetIssueCapsuleV2.setPrecision(0);
                this.dbManager.getAssetIssueStore().put(assetIssueCapsule.createDbKey(), assetIssueCapsule);
                this.dbManager.getAssetIssueV2Store().put(assetIssueCapsuleV2.createDbV2Key(), assetIssueCapsuleV2);
            } else {
                this.dbManager.getAssetIssueV2Store().put(assetIssueCapsuleV2.createDbV2Key(), assetIssueCapsuleV2);
            }
            this.dbManager.adjustBalance(ownerAddress, -fee);
            this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().getAddress().toByteArray(), fee);
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
            List<Contract.AssetIssueContract.FrozenSupply> frozenSupplyList = assetIssueContract.getFrozenSupplyList();
            Iterator<Contract.AssetIssueContract.FrozenSupply> iterator = frozenSupplyList.iterator();
            long remainSupply = assetIssueContract.getTotalSupply();
            ArrayList<Protocol.Account.Frozen> frozenList = new ArrayList<Protocol.Account.Frozen>();
            long startTime = assetIssueContract.getStartTime();
            while (iterator.hasNext()) {
                Contract.AssetIssueContract.FrozenSupply next = iterator.next();
                long expireTime = startTime + next.getFrozenDays() * 86400000L;
                Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(next.getFrozenAmount()).setExpireTime(expireTime).build();
                frozenList.add(newFrozen);
                remainSupply -= next.getFrozenAmount();
            }
            if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
                accountCapsule.addAsset(assetIssueCapsule.createDbKey(), remainSupply);
            }
            accountCapsule.setAssetIssuedName(assetIssueCapsule.createDbKey());
            accountCapsule.setAssetIssuedID(assetIssueCapsule.createDbV2Key());
            accountCapsule.addAssetV2(assetIssueCapsuleV2.createDbV2Key(), remainSupply);
            accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().addAllFrozenSupply(frozenList).build());
            this.dbManager.getAccountStore().put(ownerAddress, accountCapsule);
            ret.setAssetIssueID(Long.toString(tokenIdNum));
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        String name;
        Contract.AssetIssueContract assetIssueContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.AssetIssueContract.class)) {
            throw new ContractValidateException("contract type error,expected type [AssetIssueContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            assetIssueContract = (Contract.AssetIssueContract)this.contract.unpack(Contract.AssetIssueContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = assetIssueContract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!TransactionUtil.validAssetName(assetIssueContract.getName().toByteArray())) {
            throw new ContractValidateException("Invalid assetName");
        }
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() != 0L && (name = assetIssueContract.getName().toStringUtf8().toLowerCase()).equals("trx")) {
            throw new ContractValidateException("assetName can't be trx");
        }
        int precision = assetIssueContract.getPrecision();
        if (precision != 0 && this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() != 0L && (precision < 0 || precision > 6)) {
            throw new ContractValidateException("precision cannot exceed 6");
        }
        if (!assetIssueContract.getAbbr().isEmpty() && !TransactionUtil.validAssetName(assetIssueContract.getAbbr().toByteArray())) {
            throw new ContractValidateException("Invalid abbreviation for token");
        }
        if (!TransactionUtil.validUrl(assetIssueContract.getUrl().toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        if (!TransactionUtil.validAssetDescription(assetIssueContract.getDescription().toByteArray())) {
            throw new ContractValidateException("Invalid description");
        }
        if (assetIssueContract.getStartTime() == 0L) {
            throw new ContractValidateException("Start time should be not empty");
        }
        if (assetIssueContract.getEndTime() == 0L) {
            throw new ContractValidateException("End time should be not empty");
        }
        if (assetIssueContract.getEndTime() <= assetIssueContract.getStartTime()) {
            throw new ContractValidateException("End time should be greater than start time");
        }
        if (assetIssueContract.getStartTime() <= this.dbManager.getHeadBlockTimeStamp()) {
            throw new ContractValidateException("Start time should be greater than HeadBlockTime");
        }
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L && this.dbManager.getAssetIssueStore().get(assetIssueContract.getName().toByteArray()) != null) {
            throw new ContractValidateException("Token exists");
        }
        if (assetIssueContract.getTotalSupply() <= 0L) {
            throw new ContractValidateException("TotalSupply must greater than 0!");
        }
        if (assetIssueContract.getTrxNum() <= 0) {
            throw new ContractValidateException("TrxNum must greater than 0!");
        }
        if (assetIssueContract.getNum() <= 0) {
            throw new ContractValidateException("Num must greater than 0!");
        }
        if (assetIssueContract.getPublicFreeAssetNetUsage() != 0L) {
            throw new ContractValidateException("PublicFreeAssetNetUsage must be 0!");
        }
        if (assetIssueContract.getFrozenSupplyCount() > this.dbManager.getDynamicPropertiesStore().getMaxFrozenSupplyNumber()) {
            throw new ContractValidateException("Frozen supply list length is too long");
        }
        if (assetIssueContract.getFreeAssetNetLimit() < 0L || assetIssueContract.getFreeAssetNetLimit() >= this.dbManager.getDynamicPropertiesStore().getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid FreeAssetNetLimit");
        }
        if (assetIssueContract.getPublicFreeAssetNetLimit() < 0L || assetIssueContract.getPublicFreeAssetNetLimit() >= this.dbManager.getDynamicPropertiesStore().getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid PublicFreeAssetNetLimit");
        }
        long remainSupply = assetIssueContract.getTotalSupply();
        long minFrozenSupplyTime = this.dbManager.getDynamicPropertiesStore().getMinFrozenSupplyTime();
        long maxFrozenSupplyTime = this.dbManager.getDynamicPropertiesStore().getMaxFrozenSupplyTime();
        List<Contract.AssetIssueContract.FrozenSupply> frozenList = assetIssueContract.getFrozenSupplyList();
        for (Contract.AssetIssueContract.FrozenSupply next : frozenList) {
            if (next.getFrozenAmount() <= 0L) {
                throw new ContractValidateException("Frozen supply must be greater than 0!");
            }
            if (next.getFrozenAmount() > remainSupply) {
                throw new ContractValidateException("Frozen supply cannot exceed total supply");
            }
            if (next.getFrozenDays() < minFrozenSupplyTime || next.getFrozenDays() > maxFrozenSupplyTime) {
                throw new ContractValidateException("frozenDuration must be less than " + maxFrozenSupplyTime + " days and more than " + minFrozenSupplyTime + " days");
            }
            remainSupply -= next.getFrozenAmount();
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("Account not exists");
        }
        if (!accountCapsule.getAssetIssuedName().isEmpty()) {
            throw new ContractValidateException("An account can only issue one asset");
        }
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for fee!");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.AssetIssueContract)this.contract.unpack(Contract.AssetIssueContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return this.dbManager.getDynamicPropertiesStore().getAssetIssueFee();
    }

    public long calcUsage() {
        return 0L;
    }
}

