/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core;

import com.google.protobuf.ByteString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.db.api.StoreAPI;
import org.tron.protos.Protocol;

@Component
public class WalletSolidity {
    private static final Logger logger = LoggerFactory.getLogger(WalletSolidity.class);
    @Autowired
    private StoreAPI storeAPI;

    public GrpcAPI.TransactionList getTransactionsFromThis(ByteString thisAddress, long offset, long limit) {
        List<Protocol.Transaction> transactionsFromThis = this.storeAPI.getTransactionsFromThis(ByteArray.toHexString(thisAddress.toByteArray()), offset, limit);
        GrpcAPI.TransactionList transactionList = GrpcAPI.TransactionList.newBuilder().addAllTransaction(transactionsFromThis).build();
        return transactionList;
    }

    public GrpcAPI.TransactionList getTransactionsToThis(ByteString toAddress, long offset, long limit) {
        List<Protocol.Transaction> transactionsToThis = this.storeAPI.getTransactionsToThis(ByteArray.toHexString(toAddress.toByteArray()), offset, limit);
        GrpcAPI.TransactionList transactionList = GrpcAPI.TransactionList.newBuilder().addAllTransaction(transactionsToThis).build();
        return transactionList;
    }
}

