/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;

public class StringUtil {
    public static boolean isHexString(String str, int bits) {
        String regex = String.format("^[A-Fa-f0-9]{%d}$", bits);
        return str.matches(regex);
    }

    public static byte[] createDbKey(ByteString string) {
        return string.toByteArray();
    }

    public static String createReadableString(byte[] bytes) {
        return ByteArray.toHexString(bytes);
    }

    public static String createReadableString(ByteString string) {
        return StringUtil.createReadableString(string.toByteArray());
    }

    public static List<String> getAddressStringList(Collection<ByteString> collection) {
        return collection.stream().map(bytes -> Wallet.encode58Check(bytes.toByteArray())).collect(Collectors.toList());
    }

    public static List<String> getAddressStringListFromByteArray(Collection<byte[]> collection) {
        return collection.stream().map(bytes -> StringUtil.createReadableString(bytes)).collect(Collectors.toList());
    }

    public static ByteString hexString2ByteString(String hexString) {
        return ByteString.copyFrom((byte[])ByteArray.fromHexString(hexString));
    }
}

