/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

class SlotBaseCounter {
    private int slotSize;
    private AtomicInteger[] slotCounter;

    public SlotBaseCounter(int slotSize) {
        this.slotSize = slotSize = slotSize < 1 ? 1 : slotSize;
        this.slotCounter = new AtomicInteger[slotSize];
        for (int i = 0; i < this.slotSize; ++i) {
            this.slotCounter[i] = new AtomicInteger(0);
        }
    }

    public void increaseSlot(int slotSize) {
        this.slotCounter[slotSize].incrementAndGet();
    }

    public void wipeSlot(int slotSize) {
        this.slotCounter[slotSize].set(0);
    }

    public int totalCount() {
        return Arrays.stream(this.slotCounter).mapToInt(slotCounter -> slotCounter.get()).sum();
    }

    public String toString() {
        return Arrays.toString(this.slotCounter);
    }
}

