/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tron.common.overlay.message.Message;
import org.tron.common.utils.ALock;
import org.tron.common.utils.Sha256Hash;

public class SafeMessageMap {
    protected final Map<Sha256Hash, Message> storage;
    protected ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected ALock readLock = new ALock(this.rwLock.readLock());
    protected ALock writeLock = new ALock(this.rwLock.writeLock());

    public SafeMessageMap() {
        this.storage = new HashMap<Sha256Hash, Message>();
    }

    public void put(Sha256Hash msgId, Message msg) {
        if (msg == null) {
            this.delete(msgId);
        } else {
            try (ALock l = this.writeLock.lock();){
                this.storage.put(msgId, msg);
            }
        }
    }

    public void put(Message msg) {
        this.put(Sha256Hash.of(msg.getData()), msg);
    }

    public Message get(Sha256Hash msgId) {
        try (ALock l = this.readLock.lock();){
            Message message = this.storage.get(msgId);
            return message;
        }
    }

    public void delete(Sha256Hash msgId) {
        try (ALock l = this.writeLock.lock();){
            this.storage.remove(msgId);
        }
    }
}

