/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.Manager;

public class ForkController {
    private static final Logger logger = LoggerFactory.getLogger(ForkController.class);
    private static final byte[] check = new byte[1024];
    private Manager manager;
    private Set<Integer> passSet = new HashSet<Integer>();

    public void init(Manager manager) {
        this.manager = manager;
        this.passSet.clear();
    }

    public synchronized boolean pass(int version) {
        if (this.passSet.contains(version)) {
            return true;
        }
        byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(version);
        boolean pass = this.check(stats);
        if (pass) {
            this.passSet.add(version);
        }
        return pass;
    }

    private boolean check(byte[] stats) {
        if (stats == null || stats.length == 0) {
            return false;
        }
        for (int i = 0; i < stats.length; ++i) {
            if (check[i] == stats[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized void update(BlockCapsule blockCapsule) {
        ByteString witness;
        List<ByteString> witnesses = this.manager.getWitnessController().getActiveWitnesses();
        int slot = witnesses.indexOf(witness = blockCapsule.getWitnessAddress());
        if (slot < 0) {
            return;
        }
        int version = blockCapsule.getInstance().getBlockHeader().getRawData().getVersion();
        if (version < 5 || this.passSet.contains(version)) {
            return;
        }
        byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(version);
        if (this.check(stats)) {
            this.passSet.add(version);
            return;
        }
        if (stats == null) {
            stats = new byte[witnesses.size()];
        }
        stats[slot] = 1;
        this.manager.getDynamicPropertiesStore().statsByVersion(version, stats);
        logger.info("*******update hard fork:{}, witness size:{}, solt:{}, witness:{}, version:{}", new Object[]{Streams.zip(witnesses.stream(), Stream.of(ArrayUtils.toObject((byte[])stats)), Maps::immutableEntry).map(e -> Maps.immutableEntry((Object)Wallet.encode58Check(((ByteString)e.getKey()).toByteArray()), e.getValue())).map(e -> Maps.immutableEntry((Object)StringUtils.substring((String)((String)e.getKey()), (int)(((String)e.getKey()).length() - 4)), e.getValue())).collect(Collectors.toList()), witnesses.size(), slot, Wallet.encode58Check(witness.toByteArray()), version});
    }

    public synchronized void reset(BlockCapsule blockCapsule) {
        int version = blockCapsule.getInstance().getBlockHeader().getRawData().getVersion();
        if (version < 5 || this.passSet.contains(version)) {
            return;
        }
        byte[] stats = this.manager.getDynamicPropertiesStore().statsByVersion(version);
        if (this.check(stats)) {
            this.passSet.add(version);
            return;
        }
        if (stats != null) {
            Arrays.fill(stats, (byte)0);
            this.manager.getDynamicPropertiesStore().statsByVersion(version, stats);
        }
    }

    public static ForkController instance() {
        return ForkControllerEnum.INSTANCE.getInstance();
    }

    private ForkController() {
    }

    public Manager getManager() {
        return this.manager;
    }

    static {
        Arrays.fill(check, (byte)1);
    }

    private static enum ForkControllerEnum {
        INSTANCE;

        private ForkController instance = new ForkController();

        private ForkController getInstance() {
            return this.instance;
        }
    }
}

