/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.utils.ByteUtil;

public class CompactEncoder {
    private static final byte TERMINATOR = 16;
    private static final Map<Character, Byte> hexMap = new HashMap<Character, Byte>();

    public static byte[] packNibbles(byte[] nibbles) {
        byte[] flags;
        int terminator = 0;
        if (nibbles[nibbles.length - 1] == 16) {
            terminator = 1;
            nibbles = Arrays.copyOf(nibbles, nibbles.length - 1);
        }
        int oddlen = nibbles.length % 2;
        int flag = 2 * terminator + oddlen;
        if (oddlen != 0) {
            flags = new byte[]{(byte)flag};
            nibbles = org.spongycastle.util.Arrays.concatenate((byte[])flags, (byte[])nibbles);
        } else {
            flags = new byte[]{(byte)flag, 0};
            nibbles = org.spongycastle.util.Arrays.concatenate((byte[])flags, (byte[])nibbles);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < nibbles.length; i += 2) {
            buffer.write(16 * nibbles[i] + nibbles[i + 1]);
        }
        return buffer.toByteArray();
    }

    public static boolean hasTerminator(byte[] packedKey) {
        return (packedKey[0] >> 4 & 2) != 0;
    }

    public static byte[] unpackToNibbles(byte[] str) {
        byte[] base = CompactEncoder.binToNibbles(str);
        if ((base = Arrays.copyOf(base, base.length - 1))[0] >= 2) {
            base = ByteUtil.appendByte(base, (byte)16);
        }
        base = base[0] % 2 != 0 ? Arrays.copyOfRange(base, 1, base.length) : Arrays.copyOfRange(base, 2, base.length);
        return base;
    }

    public static byte[] binToNibbles(byte[] str) {
        byte[] hexEncoded = Hex.encode((byte[])str);
        byte[] hexEncodedTerminated = Arrays.copyOf(hexEncoded, hexEncoded.length + 1);
        for (int i = 0; i < hexEncoded.length; ++i) {
            byte b = hexEncodedTerminated[i];
            hexEncodedTerminated[i] = hexMap.get(Character.valueOf((char)b));
        }
        hexEncodedTerminated[hexEncodedTerminated.length - 1] = 16;
        return hexEncodedTerminated;
    }

    public static byte[] binToNibblesNoTerminator(byte[] str) {
        byte[] hexEncoded = Hex.encode((byte[])str);
        for (int i = 0; i < hexEncoded.length; ++i) {
            byte b = hexEncoded[i];
            hexEncoded[i] = hexMap.get(Character.valueOf((char)b));
        }
        return hexEncoded;
    }

    static {
        hexMap.put(Character.valueOf('0'), (byte)0);
        hexMap.put(Character.valueOf('1'), (byte)1);
        hexMap.put(Character.valueOf('2'), (byte)2);
        hexMap.put(Character.valueOf('3'), (byte)3);
        hexMap.put(Character.valueOf('4'), (byte)4);
        hexMap.put(Character.valueOf('5'), (byte)5);
        hexMap.put(Character.valueOf('6'), (byte)6);
        hexMap.put(Character.valueOf('7'), (byte)7);
        hexMap.put(Character.valueOf('8'), (byte)8);
        hexMap.put(Character.valueOf('9'), (byte)9);
        hexMap.put(Character.valueOf('a'), (byte)10);
        hexMap.put(Character.valueOf('b'), (byte)11);
        hexMap.put(Character.valueOf('c'), (byte)12);
        hexMap.put(Character.valueOf('d'), (byte)13);
        hexMap.put(Character.valueOf('e'), (byte)14);
        hexMap.put(Character.valueOf('f'), (byte)15);
    }
}

