/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.trace;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteUtil;

public class OpActions {
    private List<Action> stack = new ArrayList<Action>();
    private List<Action> memory = new ArrayList<Action>();
    private List<Action> storage = new ArrayList<Action>();

    public List<Action> getStack() {
        return this.stack;
    }

    public void setStack(List<Action> stack) {
        this.stack = stack;
    }

    public List<Action> getMemory() {
        return this.memory;
    }

    public void setMemory(List<Action> memory) {
        this.memory = memory;
    }

    public List<Action> getStorage() {
        return this.storage;
    }

    public void setStorage(List<Action> storage) {
        this.storage = storage;
    }

    private static Action addAction(List<Action> container, Action.Name name) {
        Action action = new Action();
        action.setName(name);
        container.add(action);
        return action;
    }

    public Action addStackPop() {
        return OpActions.addAction(this.stack, Action.Name.pop);
    }

    public Action addStackPush(DataWord value) {
        return OpActions.addAction(this.stack, Action.Name.push).addParam("value", value);
    }

    public Action addStackSwap(int from, int to) {
        return OpActions.addAction(this.stack, Action.Name.swap).addParam("from", from).addParam("to", to);
    }

    public Action addMemoryExtend(long delta) {
        return OpActions.addAction(this.memory, Action.Name.extend).addParam("delta", delta);
    }

    public Action addMemoryWrite(int address, byte[] data, int size) {
        return OpActions.addAction(this.memory, Action.Name.write).addParam("address", address).addParam("data", ByteUtil.toHexString(data).substring(0, size));
    }

    public Action addStoragePut(DataWord key, DataWord value) {
        return OpActions.addAction(this.storage, Action.Name.put).addParam("key", key).addParam("value", value);
    }

    public Action addStorageRemove(DataWord key) {
        return OpActions.addAction(this.storage, Action.Name.remove).addParam("key", key);
    }

    public Action addStorageClear() {
        return OpActions.addAction(this.storage, Action.Name.clear);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Action {
        private Name name;
        private Map<String, Object> params;

        public Name getName() {
            return this.name;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        Action addParam(String name, Object value) {
            if (value != null) {
                if (this.params == null) {
                    this.params = new HashMap<String, Object>();
                }
                this.params.put(name, value.toString());
            }
            return this;
        }

        public static enum Name {
            pop,
            push,
            swap,
            extend,
            write,
            put,
            remove,
            clear;

        }
    }
}

