/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program.listener;

import java.util.ArrayList;
import java.util.List;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.program.listener.ProgramListener;

public class CompositeProgramListener
implements ProgramListener {
    private List<ProgramListener> listeners = new ArrayList<ProgramListener>();

    @Override
    public void onMemoryExtend(int delta) {
        for (ProgramListener listener : this.listeners) {
            listener.onMemoryExtend(delta);
        }
    }

    @Override
    public void onMemoryWrite(int address, byte[] data, int size) {
        for (ProgramListener listener : this.listeners) {
            listener.onMemoryWrite(address, data, size);
        }
    }

    @Override
    public void onStackPop() {
        for (ProgramListener listener : this.listeners) {
            listener.onStackPop();
        }
    }

    @Override
    public void onStackPush(DataWord value) {
        for (ProgramListener listener : this.listeners) {
            listener.onStackPush(value);
        }
    }

    @Override
    public void onStackSwap(int from, int to) {
        for (ProgramListener listener : this.listeners) {
            listener.onStackSwap(from, to);
        }
    }

    @Override
    public void onStoragePut(DataWord key, DataWord value) {
        for (ProgramListener listener : this.listeners) {
            listener.onStoragePut(key, value);
        }
    }

    @Override
    public void onStorageClear() {
        for (ProgramListener listener : this.listeners) {
            listener.onStorageClear();
        }
    }

    public void addListener(ProgramListener listener) {
        this.listeners.add(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }
}

