/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.OpCode;

public class ProgramPrecompile {
    private static final Logger logger = LoggerFactory.getLogger((String)"ProgramPrecompile");
    private Set<Integer> jumpdest = new HashSet<Integer>();

    public static ProgramPrecompile compile(byte[] ops) {
        ProgramPrecompile ret = new ProgramPrecompile();
        for (int i = 0; i < ops.length; ++i) {
            OpCode op = OpCode.code(ops[i]);
            if (op == null) continue;
            if (op.equals((Object)OpCode.JUMPDEST)) {
                logger.debug("JUMPDEST:" + i);
                ret.jumpdest.add(i);
            }
            if (op.asInt() < OpCode.PUSH1.asInt() || op.asInt() > OpCode.PUSH32.asInt()) continue;
            i += op.asInt() - OpCode.PUSH1.asInt() + 1;
        }
        return ret;
    }

    public static byte[] getCode(byte[] ops) {
        for (int i = 0; i < ops.length; ++i) {
            OpCode op = OpCode.code(ops[i]);
            if (op == null) continue;
            if (op.equals((Object)OpCode.RETURN)) {
                logger.debug("return");
            }
            if (op.equals((Object)OpCode.RETURN) && i + 1 < ops.length && OpCode.code(ops[i + 1]) != null && OpCode.code(ops[i + 1]).equals((Object)OpCode.STOP)) {
                byte[] ret = new byte[ops.length - ++i - 1];
                System.arraycopy(ops, i + 1, ret, 0, ops.length - i - 1);
                return ret;
            }
            if (op.asInt() < OpCode.PUSH1.asInt() || op.asInt() > OpCode.PUSH32.asInt()) continue;
            i += op.asInt() - OpCode.PUSH1.asInt() + 1;
        }
        return new DataWord(0).getData();
    }

    public boolean hasJumpDest(int pc) {
        return this.jumpdest.contains(pc);
    }
}

