/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.FastByteComparisons;
import org.tron.core.db.ByteArrayWrapper;

public class DataWord
implements Comparable<DataWord> {
    public static final int DATAWORD_UNIT_SIZE = 32;
    public static final BigInteger _2_256 = BigInteger.valueOf(2L).pow(256);
    public static final BigInteger MAX_VALUE = _2_256.subtract(BigInteger.ONE);
    public static final DataWord ZERO = new DataWord(new byte[32]);
    public static final DataWord ZERO_EMPTY_ARRAY = new DataWord(new byte[0]);
    private byte[] data = new byte[32];

    public DataWord() {
    }

    public DataWord(int num) {
        this(ByteBuffer.allocate(4).putInt(num));
    }

    public DataWord(long num) {
        this(ByteBuffer.allocate(8).putLong(num));
    }

    private DataWord(ByteBuffer buffer) {
        ByteBuffer targetByteBuffer = ByteBuffer.allocate(32);
        byte[] array = buffer.array();
        System.arraycopy(array, 0, targetByteBuffer.array(), 32 - array.length, array.length);
        this.data = targetByteBuffer.array();
    }

    @JsonCreator
    public DataWord(String data) {
        this(Hex.decode((String)data));
    }

    public DataWord(ByteArrayWrapper wrappedData) {
        this(wrappedData.getData());
    }

    public DataWord(byte[] data) {
        if (data == null) {
            this.data = ByteUtil.EMPTY_BYTE_ARRAY;
        } else if (data.length == 32) {
            this.data = data;
        } else if (data.length <= 32) {
            System.arraycopy(data, 0, this.data, 32 - data.length, data.length);
        } else {
            throw new RuntimeException("Data word can't exceed 32 bytes: " + data);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getNoLeadZeroesData() {
        return ByteUtil.stripLeadingZeroes(this.data);
    }

    public byte[] getLast20Bytes() {
        return Arrays.copyOfRange((byte[])this.data, (int)12, (int)this.data.length);
    }

    public BigInteger value() {
        return new BigInteger(1, this.data);
    }

    public int intValue() {
        int intVal = 0;
        for (byte aData : this.data) {
            intVal = (intVal << 8) + (aData & 0xFF);
        }
        return intVal;
    }

    public int intValueSafe() {
        int bytesOccupied = this.bytesOccupied();
        int intValue = this.intValue();
        if (bytesOccupied > 4 || intValue < 0) {
            return Integer.MAX_VALUE;
        }
        return intValue;
    }

    public long longValue() {
        long longVal = 0L;
        for (byte aData : this.data) {
            longVal = (longVal << 8) + (long)(aData & 0xFF);
        }
        return longVal;
    }

    public long longValueSafe() {
        int bytesOccupied = this.bytesOccupied();
        long longValue = this.longValue();
        if (bytesOccupied > 8 || longValue < 0L) {
            return Long.MAX_VALUE;
        }
        return longValue;
    }

    public BigInteger sValue() {
        return new BigInteger(this.data);
    }

    public String bigIntValue() {
        return new BigInteger(this.data).toString();
    }

    public boolean isZero() {
        for (byte tmp : this.data) {
            if (tmp == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNegative() {
        int result = this.data[0] & 0x80;
        return result == 128;
    }

    public DataWord and(DataWord w2) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] & w2.data[i]);
        }
        return this;
    }

    public DataWord or(DataWord w2) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] | w2.data[i]);
        }
        return this;
    }

    public DataWord xor(DataWord w2) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] ^ w2.data[i]);
        }
        return this;
    }

    public void negate() {
        int i;
        if (this.isZero()) {
            return;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = ~this.data[i];
        }
        for (i = this.data.length - 1; i >= 0; --i) {
            this.data[i] = (byte)(1 + this.data[i] & 0xFF);
            if (this.data[i] != 0) break;
        }
    }

    public void bnot() {
        if (this.isZero()) {
            this.data = ByteUtil.copyToArray(MAX_VALUE);
            return;
        }
        this.data = ByteUtil.copyToArray(MAX_VALUE.subtract(this.value()));
    }

    public void add(DataWord word) {
        byte[] result = new byte[32];
        int overflow = 0;
        for (int i = 31; i >= 0; --i) {
            int v = (this.data[i] & 0xFF) + (word.data[i] & 0xFF) + overflow;
            result[i] = (byte)v;
            overflow = v >>> 8;
        }
        this.data = result;
    }

    public void add2(DataWord word) {
        BigInteger result = this.value().add(word.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void mul(DataWord word) {
        BigInteger result = this.value().multiply(word.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void div(DataWord word) {
        if (word.isZero()) {
            this.and(ZERO);
            return;
        }
        BigInteger result = this.value().divide(word.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void sDiv(DataWord word) {
        if (word.isZero()) {
            this.and(ZERO);
            return;
        }
        BigInteger result = this.sValue().divide(word.sValue());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void sub(DataWord word) {
        BigInteger result = this.value().subtract(word.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void exp(DataWord word) {
        BigInteger result = this.value().modPow(word.value(), _2_256);
        this.data = ByteUtil.copyToArray(result);
    }

    public void mod(DataWord word) {
        if (word.isZero()) {
            this.and(ZERO);
            return;
        }
        BigInteger result = this.value().mod(word.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void sMod(DataWord word) {
        if (word.isZero()) {
            this.and(ZERO);
            return;
        }
        BigInteger result = this.sValue().abs().mod(word.sValue().abs());
        result = this.sValue().signum() == -1 ? result.negate() : result;
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void addmod(DataWord word1, DataWord word2) {
        if (word2.isZero()) {
            this.data = new byte[32];
            return;
        }
        BigInteger result = this.value().add(word1.value()).mod(word2.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    public void mulmod(DataWord word1, DataWord word2) {
        if (this.isZero() || word1.isZero() || word2.isZero()) {
            this.data = new byte[32];
            return;
        }
        BigInteger result = this.value().multiply(word1.value()).mod(word2.value());
        this.data = ByteUtil.copyToArray(result.and(MAX_VALUE));
    }

    @JsonValue
    public String toString() {
        return Hex.toHexString((byte[])this.data);
    }

    public String toPrefixString() {
        byte[] pref = this.getNoLeadZeroesData();
        if (pref.length == 0) {
            return "";
        }
        if (pref.length < 7) {
            return Hex.toHexString((byte[])pref);
        }
        return Hex.toHexString((byte[])pref).substring(0, 6);
    }

    public String shortHex() {
        String hexValue = Hex.toHexString((byte[])this.getNoLeadZeroesData()).toUpperCase();
        return "0x" + hexValue.replaceFirst("^0+(?!$)", "");
    }

    public DataWord clone() {
        return new DataWord(Arrays.clone((byte[])this.data));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataWord dataWord = (DataWord)o;
        return java.util.Arrays.equals(this.data, dataWord.data);
    }

    public int hashCode() {
        return java.util.Arrays.hashCode(this.data);
    }

    @Override
    public int compareTo(DataWord o) {
        if (o == null || o.getData() == null) {
            return -1;
        }
        int result = FastByteComparisons.compareTo(this.data, 0, this.data.length, o.getData(), 0, o.getData().length);
        return (int)Math.signum(result);
    }

    public void signExtend(byte k) {
        if (0 > k || k > 31) {
            throw new IndexOutOfBoundsException();
        }
        int mask = this.sValue().testBit(k * 8 + 7) ? -1 : 0;
        for (int i = 31; i > k; --i) {
            this.data[31 - i] = mask;
        }
    }

    public int bytesOccupied() {
        int firstNonZero = ByteUtil.firstNonZeroByte(this.data);
        if (firstNonZero == -1) {
            return 0;
        }
        return 31 - firstNonZero + 1;
    }

    public boolean isHex(String hex) {
        return Hex.toHexString((byte[])this.data).equals(hex);
    }

    public String asString() {
        return new String(this.getNoLeadZeroesData());
    }

    public String toHexString() {
        return Hex.toHexString((byte[])this.data);
    }
}

