/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.ChannelManager;
import org.tron.core.net.node.NodeImpl;
import org.tron.core.net.peer.PeerConnection;

@Component
@Scope(value="prototype")
public class TronChannelInitializer
extends ChannelInitializer<NioSocketChannel> {
    private static final Logger logger = LoggerFactory.getLogger((String)"TronChannelInitializer");
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    ChannelManager channelManager;
    private NodeImpl p2pNode;
    private String remoteId;
    private boolean peerDiscoveryMode = false;

    public TronChannelInitializer(String remoteId) {
        this.remoteId = remoteId;
    }

    public void initChannel(NioSocketChannel ch) throws Exception {
        try {
            Channel channel = (Channel)this.ctx.getBean(PeerConnection.class);
            channel.init(ch.pipeline(), this.remoteId, this.peerDiscoveryMode, this.channelManager, this.p2pNode);
            ch.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(262144));
            ch.config().setOption(ChannelOption.SO_RCVBUF, (Object)262144);
            ch.config().setOption(ChannelOption.SO_BACKLOG, (Object)1024);
            ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                logger.info("Close channel:" + channel);
                if (!this.peerDiscoveryMode) {
                    this.channelManager.notifyDisconnect(channel);
                }
            }));
        }
        catch (Exception e) {
            logger.error("Unexpected error: ", (Throwable)e);
        }
    }

    private boolean isInbound() {
        return this.remoteId == null || this.remoteId.isEmpty();
    }

    public void setPeerDiscoveryMode(boolean peerDiscoveryMode) {
        this.peerDiscoveryMode = peerDiscoveryMode;
    }

    public void setNodeImpl(NodeImpl p2pNode) {
        this.p2pNode = p2pNode;
    }
}

