/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node.statistics;

import java.util.concurrent.atomic.AtomicLong;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.statistics.MessageCount;
import org.tron.common.overlay.discover.node.statistics.MessageStatistics;
import org.tron.common.overlay.discover.node.statistics.Reputation;
import org.tron.core.config.args.Args;
import org.tron.protos.Protocol;

public class NodeStatistics {
    public static final int REPUTATION_PREDEFINED = 100000;
    public static final long TOO_MANY_PEERS_PENALIZE_TIMEOUT = 60000L;
    private static final long CLEAR_CYCLE_TIME = 3600000L;
    private final long MIN_DATA_LENGTH = Args.getInstance().getReceiveTcpMinDataLength();
    private boolean isPredefined = false;
    private int persistedReputation = 0;
    private int disconnectTimes = 0;
    private Protocol.ReasonCode tronLastRemoteDisconnectReason = null;
    private Protocol.ReasonCode tronLastLocalDisconnectReason = null;
    private long lastDisconnectedTime = 0L;
    private long firstDisconnectedTime = 0L;
    public final MessageStatistics messageStatistics = new MessageStatistics();
    public final MessageCount p2pHandShake = new MessageCount();
    public final MessageCount tcpFlow = new MessageCount();
    public final SimpleStatter discoverMessageLatency;
    public final AtomicLong lastPongReplyTime = new AtomicLong(0L);
    private Reputation reputation;

    public NodeStatistics(Node node) {
        this.discoverMessageLatency = new SimpleStatter(node.getIdString());
        this.reputation = new Reputation(this);
    }

    public int getReputation() {
        int score = 0;
        if (!this.isReputationPenalized()) {
            score += this.persistedReputation / 5 + this.reputation.calculate();
        }
        if (this.isPredefined) {
            score += 100000;
        }
        return score;
    }

    public Protocol.ReasonCode getDisconnectReason() {
        if (this.tronLastLocalDisconnectReason != null) {
            return this.tronLastLocalDisconnectReason;
        }
        if (this.tronLastRemoteDisconnectReason != null) {
            return this.tronLastRemoteDisconnectReason;
        }
        return Protocol.ReasonCode.UNKNOWN;
    }

    public boolean isReputationPenalized() {
        if (this.wasDisconnected() && this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.TOO_MANY_PEERS && System.currentTimeMillis() - this.lastDisconnectedTime < 60000L) {
            return true;
        }
        if (this.wasDisconnected() && this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.DUPLICATE_PEER && System.currentTimeMillis() - this.lastDisconnectedTime < 60000L) {
            return true;
        }
        if (this.firstDisconnectedTime > 0L && System.currentTimeMillis() - this.firstDisconnectedTime > 3600000L) {
            this.tronLastLocalDisconnectReason = null;
            this.tronLastRemoteDisconnectReason = null;
            this.disconnectTimes = 0;
            this.persistedReputation = 0;
            this.firstDisconnectedTime = 0L;
        }
        if (this.tronLastLocalDisconnectReason == Protocol.ReasonCode.INCOMPATIBLE_PROTOCOL || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.INCOMPATIBLE_PROTOCOL || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.BAD_PROTOCOL || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.BAD_PROTOCOL || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.BAD_BLOCK || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.BAD_BLOCK || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.BAD_TX || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.BAD_TX || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.FORKED || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.FORKED || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.UNLINKABLE || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.UNLINKABLE || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.INCOMPATIBLE_CHAIN || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.INCOMPATIBLE_CHAIN || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.SYNC_FAIL || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.SYNC_FAIL || this.tronLastRemoteDisconnectReason == Protocol.ReasonCode.INCOMPATIBLE_VERSION || this.tronLastLocalDisconnectReason == Protocol.ReasonCode.INCOMPATIBLE_VERSION) {
            this.persistedReputation = 0;
            return true;
        }
        return false;
    }

    public void nodeDisconnectedRemote(Protocol.ReasonCode reason) {
        this.lastDisconnectedTime = System.currentTimeMillis();
        this.tronLastRemoteDisconnectReason = reason;
    }

    public void nodeDisconnectedLocal(Protocol.ReasonCode reason) {
        this.lastDisconnectedTime = System.currentTimeMillis();
        this.tronLastLocalDisconnectReason = reason;
    }

    public void notifyDisconnect() {
        this.lastDisconnectedTime = System.currentTimeMillis();
        if (this.firstDisconnectedTime <= 0L) {
            this.firstDisconnectedTime = this.lastDisconnectedTime;
        }
        if (this.tronLastLocalDisconnectReason == Protocol.ReasonCode.RESET) {
            return;
        }
        ++this.disconnectTimes;
        this.persistedReputation /= 2;
    }

    public boolean wasDisconnected() {
        return this.lastDisconnectedTime > 0L;
    }

    public void setPredefined(boolean isPredefined) {
        this.isPredefined = isPredefined;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public void setPersistedReputation(int persistedReputation) {
        this.persistedReputation = persistedReputation;
    }

    public String toString() {
        return "NodeStat[reput: " + this.getReputation() + "(" + this.persistedReputation + "), discover: " + this.messageStatistics.discoverInPong + "/" + this.messageStatistics.discoverOutPing + " " + this.messageStatistics.discoverOutPong + "/" + this.messageStatistics.discoverInPing + " " + this.messageStatistics.discoverInNeighbours + "/" + this.messageStatistics.discoverOutFindNode + " " + this.messageStatistics.discoverOutNeighbours + "/" + this.messageStatistics.discoverInFindNode + " " + (int)this.discoverMessageLatency.getAvrg() + "ms, p2p: " + this.p2pHandShake + "/" + this.messageStatistics.p2pInHello + "/" + this.messageStatistics.p2pOutHello + " , tron: " + this.messageStatistics.tronInMessage + "/" + this.messageStatistics.tronOutMessage + " " + (this.wasDisconnected() ? "X " + this.disconnectTimes : "") + (this.tronLastLocalDisconnectReason != null ? "<=" + (Object)((Object)this.tronLastLocalDisconnectReason) : " ") + (this.tronLastRemoteDisconnectReason != null ? "=>" + (Object)((Object)this.tronLastRemoteDisconnectReason) : " ") + ", tcp flow: " + this.tcpFlow.getTotalCount();
    }

    public boolean nodeIsHaveDataTransfer() {
        return this.tcpFlow.getTotalCount() > this.MIN_DATA_LENGTH;
    }

    public void resetTcpFlow() {
        this.tcpFlow.reset();
    }

    public int getDisconnectTimes() {
        return this.disconnectTimes;
    }

    public Protocol.ReasonCode getTronLastRemoteDisconnectReason() {
        return this.tronLastRemoteDisconnectReason;
    }

    public Protocol.ReasonCode getTronLastLocalDisconnectReason() {
        return this.tronLastLocalDisconnectReason;
    }

    public class SimpleStatter {
        private final String name;
        private volatile double last;
        private volatile double sum;
        private volatile int count;

        public SimpleStatter(String name) {
            this.name = name;
        }

        public void add(double value) {
            this.last = value;
            this.sum += value;
            ++this.count;
        }

        public double getLast() {
            return this.last;
        }

        public int getCount() {
            return this.count;
        }

        public double getSum() {
            return this.sum;
        }

        public double getAvrg() {
            return this.count == 0 ? 0.0 : this.sum / (double)this.count;
        }

        public String getName() {
            return this.name;
        }
    }
}

