/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.dht;

import java.util.ArrayList;
import java.util.List;
import org.tron.common.overlay.discover.dht.Peer;

public class Bucket {
    public static int MAX_KADEMLIA_K = 5;
    Bucket left;
    Bucket right;
    String name;
    List<Peer> peers = new ArrayList<Peer>();

    public Bucket(String name) {
        this.name = name;
    }

    public void add(Peer peer) {
        if (peer == null) {
            throw new Error("Not a leaf");
        }
        if (this.peers == null) {
            if (peer.nextBit(this.name) == 1) {
                this.left.add(peer);
            } else {
                this.right.add(peer);
            }
            return;
        }
        this.peers.add(peer);
        if (this.peers.size() > MAX_KADEMLIA_K) {
            this.splitBucket();
        }
    }

    public void splitBucket() {
        this.left = new Bucket(this.name + "1");
        this.right = new Bucket(this.name + "0");
        for (Peer id : this.peers) {
            if (id.nextBit(this.name) == 1) {
                this.left.add(id);
                continue;
            }
            this.right.add(id);
        }
        this.peers = null;
    }

    public Bucket left() {
        return this.left;
    }

    public Bucket right() {
        return this.right;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("\n");
        if (this.peers == null) {
            return sb.toString();
        }
        for (Peer id : this.peers) {
            sb.append(id.toBinaryString()).append("\n");
        }
        return sb.toString();
    }

    public void traverseTree(DoOnTree doOnTree) {
        if (this.left != null) {
            this.left.traverseTree(doOnTree);
        }
        if (this.right != null) {
            this.right.traverseTree(doOnTree);
        }
        doOnTree.call(this);
    }

    public String getName() {
        return this.name;
    }

    public List<Peer> getPeers() {
        return this.peers;
    }

    public static class SaveLeaf
    implements DoOnTree {
        List<Bucket> leafs = new ArrayList<Bucket>();

        @Override
        public void call(Bucket bucket) {
            if (bucket.peers != null) {
                this.leafs.add(bucket);
            }
        }

        public List<Bucket> getLeafs() {
            return this.leafs;
        }

        public void setLeafs(List<Bucket> leafs) {
            this.leafs = leafs;
        }
    }

    public static interface DoOnTree {
        public void call(Bucket var1);
    }
}

