/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.tron.common.overlay.discover.DiscoverTask;
import org.tron.common.overlay.discover.RefreshTask;
import org.tron.common.overlay.discover.node.NodeManager;

public class DiscoveryExecutor {
    ScheduledExecutorService discoverer = Executors.newSingleThreadScheduledExecutor();
    ScheduledExecutorService refresher = Executors.newSingleThreadScheduledExecutor();
    NodeManager nodeManager;

    public DiscoveryExecutor(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void start() {
        this.discoverer.scheduleWithFixedDelay(new DiscoverTask(this.nodeManager), 1L, 30L, TimeUnit.SECONDS);
        this.refresher.scheduleWithFixedDelay(new RefreshTask(this.nodeManager), 1L, 7200L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.discoverer.shutdownNow();
        this.refresher.shutdownNow();
    }
}

