/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.net.udp.message.discover;

import com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.message.Message;
import org.tron.common.net.udp.message.UdpMessageTypeEnum;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.utils.ByteArray;
import org.tron.core.config.args.Args;
import org.tron.protos.Discover;

public class PingMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(PingMessage.class);
    private Discover.PingMessage pingMessage;

    public PingMessage(byte[] data) throws Exception {
        super(UdpMessageTypeEnum.DISCOVER_PING, data);
        this.pingMessage = Discover.PingMessage.parseFrom(data);
    }

    public PingMessage(Node from, Node to) {
        super(UdpMessageTypeEnum.DISCOVER_PING, null);
        Discover.Endpoint fromEndpoint = Discover.Endpoint.newBuilder().setNodeId(ByteString.copyFrom((byte[])from.getId())).setPort(from.getPort()).setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(from.getHost()))).build();
        Discover.Endpoint toEndpoint = Discover.Endpoint.newBuilder().setNodeId(ByteString.copyFrom((byte[])to.getId())).setPort(to.getPort()).setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(to.getHost()))).build();
        this.pingMessage = Discover.PingMessage.newBuilder().setVersion(Args.getInstance().getNodeP2pVersion()).setFrom(fromEndpoint).setTo(toEndpoint).setTimestamp(System.currentTimeMillis()).build();
        this.data = this.pingMessage.toByteArray();
    }

    public int getVersion() {
        return this.pingMessage.getVersion();
    }

    public Node getTo() {
        Discover.Endpoint to = this.pingMessage.getTo();
        Node node = new Node(to.getNodeId().toByteArray(), ByteArray.toStr(to.getAddress().toByteArray()), to.getPort());
        return node;
    }

    @Override
    public Node getFrom() {
        return Message.getNode(this.pingMessage.getFrom());
    }

    @Override
    public String toString() {
        return "[pingMessage: " + this.pingMessage;
    }
}

