/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.net.udp.message.discover;

import com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.message.Message;
import org.tron.common.net.udp.message.UdpMessageTypeEnum;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.utils.ByteArray;
import org.tron.protos.Discover;

public class FindNodeMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(FindNodeMessage.class);
    private Discover.FindNeighbours findNeighbours;

    public FindNodeMessage(byte[] data) throws Exception {
        super(UdpMessageTypeEnum.DISCOVER_FIND_NODE, data);
        this.findNeighbours = Discover.FindNeighbours.parseFrom(data);
    }

    public FindNodeMessage(Node from, byte[] targetId) {
        super(UdpMessageTypeEnum.DISCOVER_FIND_NODE, null);
        Discover.Endpoint fromEndpoint = Discover.Endpoint.newBuilder().setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(from.getHost()))).setPort(from.getPort()).setNodeId(ByteString.copyFrom((byte[])from.getId())).build();
        this.findNeighbours = Discover.FindNeighbours.newBuilder().setFrom(fromEndpoint).setTargetId(ByteString.copyFrom((byte[])targetId)).setTimestamp(System.currentTimeMillis()).build();
        this.data = this.findNeighbours.toByteArray();
    }

    public byte[] getTargetId() {
        return this.findNeighbours.getTargetId().toByteArray();
    }

    @Override
    public Node getFrom() {
        return Message.getNode(this.findNeighbours.getFrom());
    }

    @Override
    public String toString() {
        return "[findNeighbours: " + this.findNeighbours;
    }
}

