/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.net.udp.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.handler.UdpEvent;
import org.tron.common.net.udp.message.Message;

public class PacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private static final Logger logger = LoggerFactory.getLogger((String)"PacketDecoder");
    private static final int MAXSIZE = 2048;

    public void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        int length = buf.readableBytes();
        if (length <= 1 || length >= 2048) {
            logger.error("UDP rcv bad packet, from {} length = {}", (Object)ctx.channel().remoteAddress(), (Object)length);
            return;
        }
        byte[] encoded = new byte[length];
        buf.readBytes(encoded);
        try {
            UdpEvent event = new UdpEvent(Message.parse(encoded), (InetSocketAddress)packet.sender());
            out.add(event);
        }
        catch (Exception e) {
            logger.error("Parse msg failed, type {}, len {}, address {}", new Object[]{encoded[0], encoded.length, packet.sender()});
        }
    }
}

