/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tron.common.entity.PeerInfo;
import org.tron.protos.Protocol;

public class NodeInfo {
    private long beginSyncNum;
    private String block;
    private String solidityBlock;
    private int currentConnectCount;
    private int activeConnectCount;
    private int passiveConnectCount;
    private long totalFlow;
    private List<PeerInfo> peerList = new ArrayList<PeerInfo>();
    private ConfigNodeInfo configNodeInfo;
    private MachineInfo machineInfo;
    private Map<String, String> cheatWitnessInfoMap = new HashMap<String, String>();

    public long getBeginSyncNum() {
        return this.beginSyncNum;
    }

    public NodeInfo setBeginSyncNum(long beginSyncNum) {
        this.beginSyncNum = beginSyncNum;
        return this;
    }

    public String getBlock() {
        return this.block;
    }

    public NodeInfo setBlock(String block) {
        this.block = block;
        return this;
    }

    public String getSolidityBlock() {
        return this.solidityBlock;
    }

    public NodeInfo setSolidityBlock(String solidityBlock) {
        this.solidityBlock = solidityBlock;
        return this;
    }

    public int getCurrentConnectCount() {
        return this.currentConnectCount;
    }

    public NodeInfo setCurrentConnectCount(int currentConnectCount) {
        this.currentConnectCount = currentConnectCount;
        return this;
    }

    public int getActiveConnectCount() {
        return this.activeConnectCount;
    }

    public NodeInfo setActiveConnectCount(int activeConnectCount) {
        this.activeConnectCount = activeConnectCount;
        return this;
    }

    public int getPassiveConnectCount() {
        return this.passiveConnectCount;
    }

    public NodeInfo setPassiveConnectCount(int passiveConnectCount) {
        this.passiveConnectCount = passiveConnectCount;
        return this;
    }

    public long getTotalFlow() {
        return this.totalFlow;
    }

    public NodeInfo setTotalFlow(long totalFlow) {
        this.totalFlow = totalFlow;
        return this;
    }

    public List<PeerInfo> getPeerList() {
        return new ArrayList<PeerInfo>(this.peerList);
    }

    public NodeInfo setPeerList(List<PeerInfo> peerList) {
        this.peerList = new ArrayList<PeerInfo>(peerList);
        return this;
    }

    public ConfigNodeInfo getConfigNodeInfo() {
        return this.configNodeInfo;
    }

    public NodeInfo setConfigNodeInfo(ConfigNodeInfo configNodeInfo) {
        this.configNodeInfo = configNodeInfo;
        return this;
    }

    public MachineInfo getMachineInfo() {
        return this.machineInfo;
    }

    public NodeInfo setMachineInfo(MachineInfo machineInfo) {
        this.machineInfo = machineInfo;
        return this;
    }

    public Map<String, String> getCheatWitnessInfoMap() {
        return this.cheatWitnessInfoMap;
    }

    public NodeInfo setCheatWitnessInfoMap(Map<String, String> cheatWitnessInfoMap) {
        this.cheatWitnessInfoMap = cheatWitnessInfoMap;
        return this;
    }

    public Protocol.NodeInfo transferToProtoEntity() {
        MachineInfo machineInfo;
        Protocol.NodeInfo.Builder builder = Protocol.NodeInfo.newBuilder();
        builder.setBeginSyncNum(this.getBeginSyncNum());
        builder.setBlock(this.getBlock());
        builder.setSolidityBlock(this.getSolidityBlock());
        builder.setCurrentConnectCount(this.getCurrentConnectCount());
        builder.setActiveConnectCount(this.getActiveConnectCount());
        builder.setPassiveConnectCount(this.getPassiveConnectCount());
        builder.setTotalFlow(this.getTotalFlow());
        builder.putAllCheatWitnessInfoMap(this.getCheatWitnessInfoMap());
        for (PeerInfo peerInfo : this.getPeerList()) {
            Protocol.NodeInfo.PeerInfo.Builder peerInfoBuilder = Protocol.NodeInfo.PeerInfo.newBuilder();
            peerInfoBuilder.setLastSyncBlock(peerInfo.getLastSyncBlock());
            peerInfoBuilder.setRemainNum(peerInfo.getRemainNum());
            peerInfoBuilder.setLastBlockUpdateTime(peerInfo.getLastBlockUpdateTime());
            peerInfoBuilder.setSyncFlag(peerInfo.isSyncFlag());
            peerInfoBuilder.setHeadBlockTimeWeBothHave(peerInfo.getHeadBlockTimeWeBothHave());
            peerInfoBuilder.setNeedSyncFromPeer(peerInfo.isSyncFlag());
            peerInfoBuilder.setNeedSyncFromUs(peerInfo.isNeedSyncFromUs());
            peerInfoBuilder.setHost(peerInfo.getHost());
            peerInfoBuilder.setPort(peerInfo.getPort());
            peerInfoBuilder.setNodeId(peerInfo.getNodeId());
            peerInfoBuilder.setConnectTime(peerInfo.getConnectTime());
            peerInfoBuilder.setAvgLatency(peerInfo.getAvgLatency());
            peerInfoBuilder.setSyncToFetchSize(peerInfo.getSyncToFetchSize());
            peerInfoBuilder.setSyncToFetchSizePeekNum(peerInfo.getSyncToFetchSizePeekNum());
            peerInfoBuilder.setSyncBlockRequestedSize(peerInfo.getSyncBlockRequestedSize());
            peerInfoBuilder.setUnFetchSynNum(peerInfo.getUnFetchSynNum());
            peerInfoBuilder.setBlockInPorcSize(peerInfo.getBlockInPorcSize());
            peerInfoBuilder.setHeadBlockWeBothHave(peerInfo.getHeadBlockWeBothHave());
            peerInfoBuilder.setIsActive(peerInfo.isActive());
            peerInfoBuilder.setScore(peerInfo.getScore());
            peerInfoBuilder.setNodeCount(peerInfo.getNodeCount());
            peerInfoBuilder.setInFlow(peerInfo.getInFlow());
            peerInfoBuilder.setDisconnectTimes(peerInfo.getDisconnectTimes());
            peerInfoBuilder.setLocalDisconnectReason(peerInfo.getLocalDisconnectReason());
            peerInfoBuilder.setRemoteDisconnectReason(peerInfo.getRemoteDisconnectReason());
            builder.addPeerInfoList(peerInfoBuilder.build());
        }
        ConfigNodeInfo configNodeInfo = this.getConfigNodeInfo();
        if (configNodeInfo != null) {
            Protocol.NodeInfo.ConfigNodeInfo.Builder configBuilder = Protocol.NodeInfo.ConfigNodeInfo.newBuilder();
            configBuilder.setCodeVersion(configNodeInfo.getCodeVersion());
            configBuilder.setP2PVersion(configNodeInfo.getP2pVersion());
            configBuilder.setListenPort(configNodeInfo.getListenPort());
            configBuilder.setDiscoverEnable(configNodeInfo.isDiscoverEnable());
            configBuilder.setActiveNodeSize(configNodeInfo.getActiveNodeSize());
            configBuilder.setPassiveNodeSize(configNodeInfo.getPassiveNodeSize());
            configBuilder.setSendNodeSize(configNodeInfo.getSendNodeSize());
            configBuilder.setMaxConnectCount(configNodeInfo.getMaxConnectCount());
            configBuilder.setSameIpMaxConnectCount(configNodeInfo.getSameIpMaxConnectCount());
            configBuilder.setBackupListenPort(configNodeInfo.getBackupListenPort());
            configBuilder.setBackupMemberSize(configNodeInfo.getBackupMemberSize());
            configBuilder.setBackupPriority(configNodeInfo.getBackupPriority());
            configBuilder.setDbVersion(configNodeInfo.getDbVersion());
            configBuilder.setMinParticipationRate(configNodeInfo.getMinParticipationRate());
            configBuilder.setSupportConstant(configNodeInfo.isSupportConstant());
            configBuilder.setMinTimeRatio(configNodeInfo.getMinTimeRatio());
            configBuilder.setMaxTimeRatio(configNodeInfo.getMaxTimeRatio());
            configBuilder.setAllowCreationOfContracts(configNodeInfo.getAllowCreationOfContracts());
            configBuilder.setAllowAdaptiveEnergy(configNodeInfo.getAllowAdaptiveEnergy());
            builder.setConfigNodeInfo(configBuilder.build());
        }
        if ((machineInfo = this.getMachineInfo()) != null) {
            Protocol.NodeInfo.MachineInfo.Builder machineBuilder = Protocol.NodeInfo.MachineInfo.newBuilder();
            machineBuilder.setThreadCount(machineInfo.getThreadCount());
            machineBuilder.setDeadLockThreadCount(machineInfo.getDeadLockThreadCount());
            machineBuilder.setCpuCount(machineInfo.getCpuCount());
            machineBuilder.setTotalMemory(machineInfo.getTotalMemory());
            machineBuilder.setFreeMemory(machineInfo.getFreeMemory());
            machineBuilder.setCpuRate(machineInfo.getCpuRate());
            machineBuilder.setJavaVersion(machineInfo.getJavaVersion());
            machineBuilder.setOsName(machineInfo.getOsName());
            machineBuilder.setJvmTotalMemoery(machineInfo.getJvmTotalMemoery());
            machineBuilder.setJvmFreeMemory(machineInfo.getJvmFreeMemory());
            machineBuilder.setProcessCpuRate(machineInfo.getProcessCpuRate());
            for (MachineInfo.MemoryDescInfo memoryDescInfo : machineInfo.getMemoryDescInfoList()) {
                Protocol.NodeInfo.MachineInfo.MemoryDescInfo.Builder descBuilder = Protocol.NodeInfo.MachineInfo.MemoryDescInfo.newBuilder();
                descBuilder.setName(memoryDescInfo.getName());
                descBuilder.setInitSize(memoryDescInfo.getInitSize());
                descBuilder.setUseSize(memoryDescInfo.getUseSize());
                descBuilder.setMaxSize(memoryDescInfo.getMaxSize());
                descBuilder.setUseRate(memoryDescInfo.getUseRate());
                machineBuilder.addMemoryDescInfoList(descBuilder.build());
            }
            for (MachineInfo.DeadLockThreadInfo deadLockThreadInfo : machineInfo.getDeadLockThreadInfoList()) {
                Protocol.NodeInfo.MachineInfo.DeadLockThreadInfo.Builder deadBuilder = Protocol.NodeInfo.MachineInfo.DeadLockThreadInfo.newBuilder();
                deadBuilder.setName(deadLockThreadInfo.getName());
                deadBuilder.setLockName(deadLockThreadInfo.getLockName());
                deadBuilder.setLockOwner(deadLockThreadInfo.getLockOwner());
                deadBuilder.setState(deadLockThreadInfo.getState());
                deadBuilder.setBlockTime(deadLockThreadInfo.getBlockTime());
                deadBuilder.setWaitTime(deadLockThreadInfo.getWaitTime());
                deadBuilder.setStackTrace(deadLockThreadInfo.getStackTrace());
                machineBuilder.addDeadLockThreadInfoList(deadBuilder.build());
            }
            builder.setMachineInfo(machineBuilder.build());
        }
        return builder.build();
    }

    public static class ConfigNodeInfo {
        private String codeVersion;
        private String p2pVersion;
        private int listenPort;
        private boolean discoverEnable;
        private int activeNodeSize;
        private int passiveNodeSize;
        private int sendNodeSize;
        private int maxConnectCount;
        private int sameIpMaxConnectCount;
        private int backupListenPort;
        private int backupMemberSize;
        private int backupPriority;
        private int dbVersion;
        private int minParticipationRate;
        private boolean supportConstant;
        private double minTimeRatio;
        private double maxTimeRatio;
        private long allowCreationOfContracts;
        private long allowAdaptiveEnergy;

        public String getCodeVersion() {
            return this.codeVersion;
        }

        public ConfigNodeInfo setCodeVersion(String codeVersion) {
            this.codeVersion = codeVersion;
            return this;
        }

        public String getP2pVersion() {
            return this.p2pVersion;
        }

        public ConfigNodeInfo setP2pVersion(String p2pVersion) {
            this.p2pVersion = p2pVersion;
            return this;
        }

        public int getListenPort() {
            return this.listenPort;
        }

        public ConfigNodeInfo setListenPort(int listenPort) {
            this.listenPort = listenPort;
            return this;
        }

        public boolean isDiscoverEnable() {
            return this.discoverEnable;
        }

        public ConfigNodeInfo setDiscoverEnable(boolean discoverEnable) {
            this.discoverEnable = discoverEnable;
            return this;
        }

        public int getActiveNodeSize() {
            return this.activeNodeSize;
        }

        public ConfigNodeInfo setActiveNodeSize(int activeNodeSize) {
            this.activeNodeSize = activeNodeSize;
            return this;
        }

        public int getPassiveNodeSize() {
            return this.passiveNodeSize;
        }

        public ConfigNodeInfo setPassiveNodeSize(int passiveNodeSize) {
            this.passiveNodeSize = passiveNodeSize;
            return this;
        }

        public int getSendNodeSize() {
            return this.sendNodeSize;
        }

        public ConfigNodeInfo setSendNodeSize(int sendNodeSize) {
            this.sendNodeSize = sendNodeSize;
            return this;
        }

        public int getMaxConnectCount() {
            return this.maxConnectCount;
        }

        public ConfigNodeInfo setMaxConnectCount(int maxConnectCount) {
            this.maxConnectCount = maxConnectCount;
            return this;
        }

        public int getSameIpMaxConnectCount() {
            return this.sameIpMaxConnectCount;
        }

        public ConfigNodeInfo setSameIpMaxConnectCount(int sameIpMaxConnectCount) {
            this.sameIpMaxConnectCount = sameIpMaxConnectCount;
            return this;
        }

        public int getBackupListenPort() {
            return this.backupListenPort;
        }

        public ConfigNodeInfo setBackupListenPort(int backupListenPort) {
            this.backupListenPort = backupListenPort;
            return this;
        }

        public int getBackupMemberSize() {
            return this.backupMemberSize;
        }

        public ConfigNodeInfo setBackupMemberSize(int backupMemberSize) {
            this.backupMemberSize = backupMemberSize;
            return this;
        }

        public int getBackupPriority() {
            return this.backupPriority;
        }

        public ConfigNodeInfo setBackupPriority(int backupPriority) {
            this.backupPriority = backupPriority;
            return this;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public ConfigNodeInfo setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public int getMinParticipationRate() {
            return this.minParticipationRate;
        }

        public ConfigNodeInfo setMinParticipationRate(int minParticipationRate) {
            this.minParticipationRate = minParticipationRate;
            return this;
        }

        public boolean isSupportConstant() {
            return this.supportConstant;
        }

        public ConfigNodeInfo setSupportConstant(boolean supportConstant) {
            this.supportConstant = supportConstant;
            return this;
        }

        public double getMinTimeRatio() {
            return this.minTimeRatio;
        }

        public ConfigNodeInfo setMinTimeRatio(double minTimeRatio) {
            this.minTimeRatio = minTimeRatio;
            return this;
        }

        public double getMaxTimeRatio() {
            return this.maxTimeRatio;
        }

        public ConfigNodeInfo setMaxTimeRatio(double maxTimeRatio) {
            this.maxTimeRatio = maxTimeRatio;
            return this;
        }

        public long getAllowCreationOfContracts() {
            return this.allowCreationOfContracts;
        }

        public ConfigNodeInfo setAllowCreationOfContracts(long allowCreationOfContracts) {
            this.allowCreationOfContracts = allowCreationOfContracts;
            return this;
        }

        public long getAllowAdaptiveEnergy() {
            return this.allowAdaptiveEnergy;
        }

        public ConfigNodeInfo setAllowAdaptiveEnergy(long allowAdaptiveEnergy) {
            this.allowAdaptiveEnergy = allowAdaptiveEnergy;
            return this;
        }
    }

    public static class MachineInfo {
        private int threadCount;
        private int deadLockThreadCount;
        private int cpuCount;
        private long totalMemory;
        private long freeMemory;
        private double cpuRate;
        private String javaVersion;
        private String osName;
        private long jvmTotalMemoery;
        private long jvmFreeMemory;
        private double processCpuRate;
        private List<MemoryDescInfo> memoryDescInfoList = new ArrayList<MemoryDescInfo>();
        private List<DeadLockThreadInfo> deadLockThreadInfoList = new ArrayList<DeadLockThreadInfo>();

        public int getThreadCount() {
            return this.threadCount;
        }

        public MachineInfo setThreadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public int getCpuCount() {
            return this.cpuCount;
        }

        public MachineInfo setCpuCount(int cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public MachineInfo setTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public MachineInfo setFreeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
            return this;
        }

        public double getCpuRate() {
            return this.cpuRate;
        }

        public MachineInfo setCpuRate(double cpuRate) {
            this.cpuRate = cpuRate;
            return this;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public MachineInfo setJavaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            return this;
        }

        public String getOsName() {
            return this.osName;
        }

        public MachineInfo setOsName(String osName) {
            this.osName = osName;
            return this;
        }

        public long getJvmTotalMemoery() {
            return this.jvmTotalMemoery;
        }

        public MachineInfo setJvmTotalMemoery(long jvmTotalMemoery) {
            this.jvmTotalMemoery = jvmTotalMemoery;
            return this;
        }

        public long getJvmFreeMemory() {
            return this.jvmFreeMemory;
        }

        public MachineInfo setJvmFreeMemory(long jvmFreeMemory) {
            this.jvmFreeMemory = jvmFreeMemory;
            return this;
        }

        public double getProcessCpuRate() {
            return this.processCpuRate;
        }

        public MachineInfo setProcessCpuRate(double processCpuRate) {
            this.processCpuRate = processCpuRate;
            return this;
        }

        public List<MemoryDescInfo> getMemoryDescInfoList() {
            return new ArrayList<MemoryDescInfo>(this.memoryDescInfoList);
        }

        public MachineInfo setMemoryDescInfoList(List<MemoryDescInfo> memoryDescInfoList) {
            this.memoryDescInfoList = new ArrayList<MemoryDescInfo>(memoryDescInfoList);
            return this;
        }

        public int getDeadLockThreadCount() {
            return this.deadLockThreadCount;
        }

        public MachineInfo setDeadLockThreadCount(int deadLockThreadCount) {
            this.deadLockThreadCount = deadLockThreadCount;
            return this;
        }

        public List<DeadLockThreadInfo> getDeadLockThreadInfoList() {
            return new ArrayList<DeadLockThreadInfo>(this.deadLockThreadInfoList);
        }

        public MachineInfo setDeadLockThreadInfoList(List<DeadLockThreadInfo> deadLockThreadInfoList) {
            this.deadLockThreadInfoList = new ArrayList<DeadLockThreadInfo>(deadLockThreadInfoList);
            return this;
        }

        public static class DeadLockThreadInfo {
            private String name;
            private String lockName;
            private String lockOwner;
            private String state;
            private long blockTime;
            private long waitTime;
            private String stackTrace;

            public String getName() {
                return this.name;
            }

            public DeadLockThreadInfo setName(String name) {
                this.name = name;
                return this;
            }

            public String getLockName() {
                return this.lockName;
            }

            public DeadLockThreadInfo setLockName(String lockName) {
                this.lockName = lockName;
                return this;
            }

            public String getLockOwner() {
                return this.lockOwner;
            }

            public DeadLockThreadInfo setLockOwner(String lockOwner) {
                this.lockOwner = lockOwner;
                return this;
            }

            public String getState() {
                return this.state;
            }

            public DeadLockThreadInfo setState(String state) {
                this.state = state;
                return this;
            }

            public long getBlockTime() {
                return this.blockTime;
            }

            public DeadLockThreadInfo setBlockTime(long blockTime) {
                this.blockTime = blockTime;
                return this;
            }

            public long getWaitTime() {
                return this.waitTime;
            }

            public DeadLockThreadInfo setWaitTime(long waitTime) {
                this.waitTime = waitTime;
                return this;
            }

            public String getStackTrace() {
                return this.stackTrace;
            }

            public DeadLockThreadInfo setStackTrace(String stackTrace) {
                this.stackTrace = stackTrace;
                return this;
            }
        }

        public static class MemoryDescInfo {
            private String name;
            private long initSize;
            private long useSize;
            private long maxSize;
            private double useRate;

            public String getName() {
                return this.name;
            }

            public MemoryDescInfo setName(String name) {
                this.name = name;
                return this;
            }

            public long getInitSize() {
                return this.initSize;
            }

            public MemoryDescInfo setInitSize(long initSize) {
                this.initSize = initSize;
                return this;
            }

            public long getUseSize() {
                return this.useSize;
            }

            public MemoryDescInfo setUseSize(long useSize) {
                this.useSize = useSize;
                return this;
            }

            public long getMaxSize() {
                return this.maxSize;
            }

            public MemoryDescInfo setMaxSize(long maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public double getUseRate() {
                return this.useRate;
            }

            public MemoryDescInfo setUseRate(double useRate) {
                this.useRate = useRate;
                return this;
            }
        }
    }
}

