/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import java.math.BigInteger;
import org.tron.common.crypto.zksnark.BN128;
import org.tron.common.crypto.zksnark.BN128Fp2;
import org.tron.common.crypto.zksnark.Fp2;
import org.tron.common.crypto.zksnark.Params;

public class BN128G2
extends BN128Fp2 {
    static final BigInteger FR_NEG_ONE = BigInteger.ONE.negate().mod(Params.R);

    BN128G2(BN128<Fp2> p) {
        super((Fp2)p.x, (Fp2)p.y, (Fp2)p.z);
    }

    BN128G2(Fp2 x, Fp2 y, Fp2 z) {
        super(x, y, z);
    }

    public BN128G2 toAffine() {
        return new BN128G2(super.toAffine());
    }

    public static BN128G2 create(byte[] a, byte[] b, byte[] c, byte[] d) {
        BN128<Fp2> p = BN128Fp2.create(a, b, c, d);
        if (p == null) {
            return null;
        }
        if (!BN128G2.isGroupMember(p)) {
            return null;
        }
        return new BN128G2(p);
    }

    private static boolean isGroupMember(BN128<Fp2> p) {
        BN128<Fp2> left = p.mul(FR_NEG_ONE).add(p);
        return left.isZero();
    }

    BN128G2 mulByP() {
        Fp2 rx = Params.TWIST_MUL_BY_P_X.mul(((Fp2)this.x).frobeniusMap(1));
        Fp2 ry = Params.TWIST_MUL_BY_P_Y.mul(((Fp2)this.y).frobeniusMap(1));
        Fp2 rz = ((Fp2)this.z).frobeniusMap(1);
        return new BN128G2(rx, ry, rz);
    }
}

