/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmEncoder {
    private static final Logger logger = LoggerFactory.getLogger(SymmEncoder.class);

    public static SecretKey restoreSecretKey(byte[] secretBytes, String algorithm) {
        SecretKeySpec secretKey = new SecretKeySpec(secretBytes, algorithm);
        return secretKey;
    }

    public static byte[] AES128EcbEnc(byte[] plain, byte[] aesKey) {
        if (aesKey == null || aesKey.length != 16) {
            logger.error("AesKey need 16 bytes !!!");
            return null;
        }
        if (plain == null || (plain.length & 0xF) != 0) {
            logger.error("The length of encoded must be a multiple of 16 !!!");
            return null;
        }
        SecretKey key = SymmEncoder.restoreSecretKey(aesKey, "AES");
        return SymmEncoder.AesEcbEncode(plain, key);
    }

    public static byte[] AES128EcbDec(byte[] encoded, byte[] aesKey) {
        if (aesKey == null || aesKey.length != 16) {
            logger.error("AesKey need 16 bytes !!!");
            return null;
        }
        if (encoded == null || (encoded.length & 0xF) != 0) {
            logger.error("The length of encoded must be a multiple of 16 !!!");
            return null;
        }
        SecretKey key = SymmEncoder.restoreSecretKey(aesKey, "AES");
        return SymmEncoder.AesEcbDecode(encoded, key);
    }

    private static byte[] AesEcbEncode(byte[] plainText, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, key);
            return cipher.doFinal(plainText);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static byte[] AesEcbDecode(byte[] encodedText, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, key);
            return cipher.doFinal(encodedText);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

