/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.jce.TronCastleProvider;
import org.tron.core.Wallet;

public class Hash {
    private static final Logger logger = LoggerFactory.getLogger(Hash.class);
    private static final Provider CRYPTO_PROVIDER;
    private static final String HASH_256_ALGORITHM_NAME;
    private static final String HASH_512_ALGORITHM_NAME;

    public static byte[] sha3(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input1, byte[] input2) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input1, 0, input1.length);
            digest.update(input2, 0, input2.length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input, int start, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input, start, length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha512(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_512_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3omit12(byte[] input) {
        byte[] hash = Hash.sha3(input);
        byte[] address = Arrays.copyOfRange(hash, 11, hash.length);
        address[0] = Wallet.getAddressPreFixByte();
        return address;
    }

    static {
        Security.addProvider(TronCastleProvider.getInstance());
        CRYPTO_PROVIDER = Security.getProvider("SC");
        HASH_256_ALGORITHM_NAME = "TRON-KECCAK-256";
        HASH_512_ALGORITHM_NAME = "TRON-KECCAK-512";
    }
}

