/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.application;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.application.Service;
import org.tron.core.config.args.Args;

public class ServiceContainer {
    private static final Logger logger = LoggerFactory.getLogger(ServiceContainer.class);
    private ArrayList<Service> services = new ArrayList();

    public void add(Service service) {
        this.services.add(service);
    }

    public void init() {
        for (Service service : this.services) {
            logger.debug("Initing " + service.getClass().getSimpleName());
            service.init();
        }
    }

    public void init(Args args) {
        for (Service service : this.services) {
            logger.debug("Initing " + service.getClass().getSimpleName());
            service.init(args);
        }
    }

    public void start() {
        logger.debug("Starting services");
        for (Service service : this.services) {
            logger.debug("Starting " + service.getClass().getSimpleName());
            service.start();
        }
    }

    public void stop() {
        for (Service service : this.services) {
            logger.debug("Stopping " + service.getClass().getSimpleName());
            service.stop();
        }
    }
}

