/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.application;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.application.Application;
import org.tron.common.application.Service;
import org.tron.common.application.ServiceContainer;
import org.tron.core.config.args.Args;
import org.tron.core.db.BlockStore;
import org.tron.core.db.Manager;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.net.node.Node;
import org.tron.core.net.node.NodeDelegate;
import org.tron.core.net.node.NodeDelegateImpl;
import org.tron.core.net.node.NodeImpl;

@Component
public class ApplicationImpl
implements Application {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationImpl.class);
    @Autowired
    private NodeImpl p2pNode;
    private BlockStore blockStoreDb;
    private ServiceContainer services;
    private NodeDelegate nodeDelegate;
    @Autowired
    private Manager dbManager;
    private boolean isProducer;

    private void resetP2PNode() {
        this.p2pNode.listen();
        this.p2pNode.syncFrom(null);
    }

    @Override
    public void setOptions(Args args) {
    }

    @Override
    @Autowired
    public void init(Args args) {
        this.blockStoreDb = this.dbManager.getBlockStore();
        this.services = new ServiceContainer();
        this.nodeDelegate = new NodeDelegateImpl(this.dbManager);
    }

    @Override
    public void addService(Service service) {
        this.services.add(service);
    }

    @Override
    public void initServices(Args args) {
        this.services.init(args);
    }

    @Override
    public void startup() {
        this.p2pNode.setNodeDelegate(this.nodeDelegate);
        this.resetP2PNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        logger.info("******** begin to shutdown ********");
        RevokingDatabase revokingDatabase = this.dbManager.getRevokingStore();
        synchronized (revokingDatabase) {
            this.closeRevokingStore();
            this.closeAllStore();
        }
        this.closeConnection();
        this.dbManager.stopRepushThread();
        logger.info("******** end to shutdown ********");
    }

    @Override
    public void startServices() {
        this.services.start();
    }

    @Override
    public void shutdownServices() {
        this.services.stop();
    }

    @Override
    public Node getP2pNode() {
        return this.p2pNode;
    }

    @Override
    public BlockStore getBlockStoreS() {
        return this.blockStoreDb;
    }

    @Override
    public Manager getDbManager() {
        return this.dbManager;
    }

    public boolean isProducer() {
        return this.isProducer;
    }

    public void setIsProducer(boolean producer) {
        this.isProducer = producer;
    }

    private void closeConnection() {
        logger.info("******** begin to shutdown connection ********");
        try {
            this.p2pNode.close();
        }
        catch (Exception e) {
            logger.info("failed to close p2pNode. " + e);
        }
        finally {
            logger.info("******** end to shutdown connection ********");
        }
    }

    private void closeRevokingStore() {
        this.dbManager.getRevokingStore().shutdown();
    }

    private void closeAllStore() {
        this.dbManager.closeAllStore();
    }
}

